/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.voicebrowser;

import org.eclipse.actf.visualization.internal.engines.voicebrowser.Context;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.IElementRenderer;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.MessageCollection;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.OutLoud;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.Packet;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.PacketCollection;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.TextUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class StaticIMGRenderer
implements IElementRenderer {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PacketCollection getPacketCollectionIn(Element element, Context curContext, String url, MessageCollection mc) {
        String result;
        this.setContextIn(element, curContext);
        NamedNodeMap attrs = element.getAttributes();
        Node altNode = attrs.getNamedItem("alt");
        String altstr = null;
        if (altNode == null) {
            return null;
        }
        altstr = altNode.getNodeValue();
        if ((altstr = TextUtil.trim(altstr)).length() == 0) {
            if (OutLoud.jwat_mode != 2) return null;
            Node node = element.getParentNode();
            while (true) {
                if (node == null) {
                    return null;
                }
                if (node.getNodeType() == 1 && node.getNodeName().toLowerCase().equals("body")) {
                    return null;
                }
                if (node.getNodeType() == 1 && node.getNodeName().toLowerCase().equals("a")) break;
                node = node.getParentNode();
            }
            Node srcNode = attrs.getNamedItem("src");
            if (srcNode == null) return null;
            String srcstr = srcNode.getNodeValue();
            altstr = srcstr = TextUtil.trim(srcstr);
        }
        if ((result = OutLoud.buildResultString(mc, url, element, null, null, "<name=str1>", altstr)) == null && OutLoud.hprDefltMsg) {
            result = "[" + altstr + ".]";
        }
        if (result == null) return new PacketCollection(new Packet(element, result, curContext, true));
        result = result.trim();
        return new PacketCollection(new Packet(element, result, curContext, true));
    }

    public PacketCollection getPacketCollectionOut(Element element, Context curContext, String url, MessageCollection mc) {
        this.setContextOut(element, curContext);
        return null;
    }

    public void setContextIn(Element element, Context curContext) {
        curContext.setGoChild(true);
        curContext.setLineDelimiter(false);
        curContext.setLinkTag(false);
    }

    public void setContextOut(Element element, Context curContext) {
        curContext.setGoChild(true);
        curContext.setLineDelimiter(false);
        curContext.setLinkTag(false);
    }
}

