/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.internal.httpproxy.core;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.actf.util.httpproxy.core.TimeoutException;
import org.eclipse.actf.util.httpproxy.util.Logger;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPMessage;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPMessageBuffer;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPMessageReader;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPResponseStreamMessage;

public class HTTPResponseReader
extends HTTPMessageReader {
    private static final Logger LOGGER = Logger.getLogger(HTTPResponseReader.class);
    private final int id;

    public HTTPResponseReader(int id, InputStream in) {
        super(in);
        this.id = id;
    }

    protected void readFirstLine(HTTPMessage msg, long timeout) throws IOException, TimeoutException {
        HTTPResponseStreamMessage response = (HTTPResponseStreamMessage)msg;
        HTTPMessageBuffer buf = msg.getBuffer();
        this.readNextToken(timeout, buf, response.getHTTPVersion(), ' ');
        if (this.getLastByte() != 32) {
            throw new IOException("Unexpected char (expected=SP): " + Integer.toString(this.getLastByte()));
        }
        this.skipSpaces(timeout, buf);
        this.readNextToken(timeout, buf, response.getStatusCode(), ' ');
        if (this.getLastByte() != 32) {
            throw new IOException("Unexpected char (expected=SP): " + Integer.toString(this.getLastByte()));
        }
        this.skipSpaces(timeout, buf);
        this.readNextToken(timeout, buf, response.getReasonPhrase());
        if (this.getLastByte() != 10) {
            throw new IOException("Unexpected char (expected=LF): " + Integer.toString(this.getLastByte()));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Response-RFL:" + response.getHTTPVersionAsString() + " " + response.getStatusCodeAsString() + " " + response.getReasonPhraseAsString());
        }
    }
}

