/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.dom.sgml.impl;

import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.actf.model.dom.html.IErrorHandler;
import org.eclipse.actf.model.dom.html.IErrorLogListener;
import org.eclipse.actf.model.dom.html.ParseException;
import org.eclipse.actf.model.internal.dom.sgml.ISGMLConstants;
import org.eclipse.actf.model.internal.dom.sgml.ISGMLParser;
import org.eclipse.actf.model.internal.dom.sgml.errorhandler.AttributeValueErrorHandler;
import org.eclipse.actf.model.internal.dom.sgml.errorhandler.DefaultErrorHandler;
import org.eclipse.actf.model.internal.dom.sgml.errorhandler.ITokenErrorHandler;
import org.eclipse.actf.model.internal.dom.sgml.impl.AttributeDefinition;
import org.eclipse.actf.model.internal.dom.sgml.impl.AttributeListImpl;
import org.eclipse.actf.model.internal.dom.sgml.impl.DTDParser;
import org.eclipse.actf.model.internal.dom.sgml.impl.DTDTokenizer;
import org.eclipse.actf.model.internal.dom.sgml.impl.ElementDefinition;
import org.eclipse.actf.model.internal.dom.sgml.impl.EndTag;
import org.eclipse.actf.model.internal.dom.sgml.impl.InsTokenizer;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLDOMImpl;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLDocType;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLDocTypeDef;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLDocument;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLEntityDeclaration;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLEntityReference;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLText;
import org.eclipse.actf.model.internal.dom.sgml.modelgroup.AndModelGroup;
import org.eclipse.actf.model.internal.dom.sgml.modelgroup.IModelGroup;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.DocumentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SGMLParser
implements ISGMLConstants,
ISGMLParser {
    private boolean isXHTML = false;
    private boolean isEmptyElement = true;
    private boolean isEndWithSlash = false;
    private String currentTagName = "";
    private DOMImplementation domImpl;
    private static Class[] createDocumentMethodParamTypes = new Class[]{String.class, String.class, DocumentType.class};
    public IErrorHandler[] errorHandlers = new IErrorHandler[8];
    private ITokenErrorHandler[] tokenErrorHandlers = new ITokenErrorHandler[8];
    public int errorHandlerNum = 0;
    private int tokenErrorHandlerNum = 0;
    public static final boolean _DEBUG = false;
    private boolean extractNum = true;
    private boolean extractChar = true;
    public InsTokenizer tokenizer;
    private Document doc = null;
    public static Hashtable<String, String> pubEntityMap = new Hashtable();
    public ElementDefinition lastDef = null;
    static IModelGroup pcdata = new IModelGroup(){

        public boolean match(ISGMLParser parser, Node parent, Node child) {
            if (child instanceof Text && !(child instanceof CDATASection)) {
                parent.appendChild(child);
                return true;
            }
            return false;
        }

        public boolean optional() {
            return false;
        }

        public void refer(boolean infinite) {
        }

        public String toString() {
            return "#PCDATA";
        }

        public boolean match(int number) {
            return true;
        }

        public boolean[] rehash(int totalSize) {
            boolean[] ret = new boolean[totalSize];
            ret[totalSize - 2] = true;
            return ret;
        }
    };
    static IModelGroup cdata = new IModelGroup(){

        public boolean match(ISGMLParser parser, Node parent, Node child) {
            if (child instanceof CDATASection) {
                parent.appendChild(child);
                return true;
            }
            return false;
        }

        public boolean optional() {
            return false;
        }

        public void refer(boolean infinite) {
        }

        public String toString() {
            return "CDATA";
        }

        public boolean match(int number) {
            return false;
        }

        public boolean[] rehash(int totalSize) {
            return null;
        }
    };
    static IModelGroup empty = new IModelGroup(){

        public boolean match(ISGMLParser parser, Node parent, Node child) {
            return false;
        }

        public boolean optional() {
            return true;
        }

        public void refer(boolean infinite) {
        }

        public String toString() {
            return "EMPTY";
        }

        public boolean match(int number) {
            return false;
        }

        public boolean[] rehash(int totalSize) {
            return null;
        }
    };
    static IModelGroup any = new IModelGroup(){

        public boolean match(ISGMLParser parser, Node parent, Node child) {
            parent.appendChild(child);
            return true;
        }

        public boolean optional() {
            return true;
        }

        public void refer(boolean infinite) {
        }

        public boolean match(int number) {
            return true;
        }

        public boolean[] rehash(int totalSize) {
            return null;
        }
    };
    public ElementDefinition anonymousElementDef;
    public SGMLDocTypeDef dtd;
    public Hashtable<Node, AndModelGroup.AndContext> andMap = new Hashtable();
    public Hashtable<Node, Integer> seqMap = new Hashtable();
    public Hashtable<Node, Node> plusMap = new Hashtable();
    public IErrorLogListener[] errorLogListeners = new IErrorLogListener[8];
    public int errorLogListenerNum = 0;
    private static final int BUF_SIZ = 256;
    public int bufCount = 0;
    public Node[] buf = new Node[256];
    public int pcdataNumber;
    public IModelGroup[] seqArray;
    public Element context = null;
    public Element[] forwardPath = new Element[256];
    public ElementDefinition[] ancesterElementDefs = new ElementDefinition[256];
    public Element[] ancesters = new Element[256];
    public int depth = 0;
    public int bufSize = 256;
    public AttributeListImpl nullAttributeList = this.createAttributeList();
    public Vector<Element> nodesWithEndtag = new Vector();
    private Vector<EndTag> missedEndtags = new Vector();
    private Vector<CATB> commentsBeforeDoctype = new Vector();
    private Node[] nodesWithIllegalChildren = new Node[256];
    private int nodeWithIllegalChildNum = 0;
    public AttributeListImpl attrlist = null;
    public int lastElementNumber;
    public ElementDefinition lastElementDef;
    protected String defaultDTD = null;
    private String defaultTopElement = null;
    public int defaultTagCase = 0;
    public int tagCase = 2;
    public int attrCase = 2;
    private String enforcedDoctype = null;
    public Object extraErrInfo = null;
    public DocumentHandler docHandler = null;
    public boolean preserveWhitespace = false;
    public boolean eHandleLogical = true;
    public Vector<Element> autoGenerated = new Vector();
    private boolean keepUnknowns;
    public Node currentNode;
    private boolean keepComment = true;
    private char[] saxch;
    private int begin;
    private int len;
    private LexicalHandler lexHandler;

    public DOMImplementation setDOMImplementation(DOMImplementation domImpl) {
        Class<DOMImplementation> domImpleInterface = DOMImplementation.class;
        try {
            Method createDocumentMethod = domImpleInterface.getMethod("createDocument", createDocumentMethodParamTypes);
            if (createDocumentMethod != null) {
                this.domImpl = domImpl;
                this.doc = null;
                return domImpl;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public DOMImplementation getDOMImplementation() {
        return this.domImpl;
    }

    public SGMLParser() {
        this.addErrorHandler(new DefaultErrorHandler());
        this.addTokenErrorHandler(new AttributeValueErrorHandler());
        this.setDOMImplementation(SGMLDOMImpl.getDOMImplementation());
        if (this.getDOMImplementation() == null) {
            this.setDocument(new SGMLDocument());
        }
        this.anonymousElementDef = new ElementDefinition("ANONYMOUS", any);
    }

    public void setErrorHandler(IErrorHandler errorHandler) {
        this.addErrorHandler(errorHandler);
    }

    @Override
    public void addErrorHandler(IErrorHandler errorHandler) {
        if (this.errorHandlerNum == this.errorHandlers.length) {
            IErrorHandler[] newErrorHandlers = new IErrorHandler[this.errorHandlers.length * 2];
            int i = 0;
            while (i < this.errorHandlerNum) {
                newErrorHandlers[i] = this.errorHandlers[i];
                ++i;
            }
            this.errorHandlers = newErrorHandlers;
        }
        this.errorHandlers[this.errorHandlerNum++] = errorHandler;
    }

    public void addTokenErrorHandler(ITokenErrorHandler errorHandler) {
        if (this.tokenErrorHandlerNum == this.tokenErrorHandlers.length) {
            ITokenErrorHandler[] newErrorHandlers = new ITokenErrorHandler[this.errorHandlers.length * 2];
            int i = 0;
            while (i < this.tokenErrorHandlerNum) {
                newErrorHandlers[i] = this.tokenErrorHandlers[i];
                ++i;
            }
            this.tokenErrorHandlers = newErrorHandlers;
        }
        this.tokenErrorHandlers[this.tokenErrorHandlerNum++] = errorHandler;
    }

    @Override
    public IErrorHandler[] getErrorHandlers() {
        IErrorHandler[] ret = new IErrorHandler[this.errorHandlerNum];
        int i = 0;
        while (i < this.errorHandlerNum) {
            ret[i] = this.errorHandlers[i];
            ++i;
        }
        return ret;
    }

    public ITokenErrorHandler[] getTokenErrorHandlers() {
        ITokenErrorHandler[] ret = new ITokenErrorHandler[this.errorHandlerNum];
        int i = 0;
        while (i < this.tokenErrorHandlerNum) {
            ret[i] = this.tokenErrorHandlers[i];
            ++i;
        }
        return ret;
    }

    public void removeErrorHandler(IErrorHandler errorHandler) {
        int i = 0;
        while (i < this.errorHandlerNum) {
            if (this.errorHandlers[i] == errorHandler) {
                this.errorHandlers[i] = null;
                ++i;
                while (i < this.errorHandlerNum) {
                    this.errorHandlers[i - 1] = this.errorHandlers[i];
                    ++i;
                }
                --this.errorHandlerNum;
                return;
            }
            ++i;
        }
    }

    public void removeTokenErrorHandler(ITokenErrorHandler errorHandler) {
        int i = 0;
        while (i < this.tokenErrorHandlerNum) {
            if (this.tokenErrorHandlers[i] == errorHandler) {
                this.tokenErrorHandlers[i] = null;
                ++i;
                while (i < this.tokenErrorHandlerNum) {
                    this.tokenErrorHandlers[i - 1] = this.tokenErrorHandlers[i];
                    ++i;
                }
                --this.errorHandlerNum;
                return;
            }
            ++i;
        }
    }

    public void extractEntity(boolean b) {
        this.extractChar = this.extractNum = b;
    }

    public void extractNumEntity(boolean b) {
        this.extractNum = b;
    }

    public boolean extractNumEntity() {
        return this.extractNum;
    }

    public void extractCharEntity(boolean b) {
        this.extractChar = b;
    }

    public boolean extractCharEntity() {
        return this.extractChar;
    }

    public static Hashtable<String, String> getPublicEntityMap() {
        return pubEntityMap;
    }

    public ElementDefinition getAnonymousElementDefinition() {
        return this.anonymousElementDef;
    }

    @Override
    public SGMLDocTypeDef getDTD() {
        return this.dtd;
    }

    public final void setDTD(SGMLDocTypeDef dtd) {
        this.dtd = dtd;
        if (this.doc instanceof SGMLDocument) {
            ((SGMLDocument)this.doc).setDTD(dtd);
        }
        this.isXHTML = dtd.toString().indexOf("XHTML") > -1;
    }

    @Override
    public Hashtable<Node, AndModelGroup.AndContext> getAndMap() {
        return this.andMap;
    }

    @Override
    public Hashtable<Node, Integer> getSeqMap() {
        return this.seqMap;
    }

    @Override
    public Hashtable<Node, Node> getPlusMap() {
        return this.plusMap;
    }

    @Override
    public void clearContextMap(Node parent) {
        this.andMap.remove(parent);
        this.seqMap.remove(parent);
        this.plusMap.remove(parent);
    }

    private Attr attribute(ElementDefinition ed, AttributeListImpl attrlist) throws IOException, ParseException, SAXException {
        Attr ret = null;
        if (this.tokenizer.nextToken() != 11) {
            if (this.handleError(13, this.tokenizer.sval)) {
                return this.attribute(ed, attrlist);
            }
        } else {
            String attName = this.changeAttrNameCase(this.tokenizer.sval);
            AttributeDefinition ad = ed != null ? ed.getAttributeDef(attName) : null;
            String attValue = attName;
            if (this.tokenizer.nextToken() == 61) {
                attValue = this.tokenizer.readAttributeValue(ad, ed);
                ret = this.doc.createAttribute(attName);
                ret.setValue(attValue);
            } else {
                this.tokenizer.pushBack();
                ret = this.doc.createAttribute(attName);
            }
            if (ad == null) {
                if (attrlist != null) {
                    attrlist.addAttribute(attName, "CDATA", attValue);
                }
                if (ed != null && ed != this.anonymousElementDef) {
                    if (this.handleError(4, ret)) {
                        ret = this.attribute(ed, attrlist);
                    } else {
                        this.error(4, "Illegal attribute '" + attName + "' for " + ed.getName());
                    }
                }
            } else if (attrlist != null) {
                attrlist.addAttribute(attName, ad.getDeclaredTypeStr(), attValue);
            }
        }
        return ret;
    }

    @Override
    public final void error(int code, String msg) {
        int i = 0;
        while (i < this.errorLogListenerNum) {
            if (this.tokenizer != null) {
                this.errorLogListeners[i].errorLog(code, String.valueOf(this.tokenizer.getCurrentLine()) + ": " + msg);
            } else {
                this.errorLogListeners[i].errorLog(code, msg);
            }
            ++i;
        }
    }

    @Override
    public void addErrorLogListener(IErrorLogListener listener) {
        if (this.errorLogListenerNum == this.errorLogListeners.length) {
            IErrorLogListener[] newListeners = new IErrorLogListener[this.errorLogListenerNum * 2];
            int i = 0;
            while (i < this.errorLogListenerNum) {
                newListeners[i] = this.errorLogListeners[i];
                ++i;
            }
            this.errorLogListeners = newListeners;
        }
        this.errorLogListeners[this.errorLogListenerNum++] = listener;
    }

    public void removeErrorLogListener(IErrorLogListener listener) {
        int i = 0;
        while (i < this.errorLogListenerNum) {
            if (this.errorLogListeners[i] == listener) {
                this.errorLogListeners[i] = null;
                ++i;
                while (i < this.errorLogListenerNum) {
                    this.errorLogListeners[i - 1] = this.errorLogListeners[i];
                    ++i;
                }
                --this.errorLogListenerNum;
                return;
            }
            ++i;
        }
    }

    private EndTag etag() throws IOException, ParseException, SAXException {
        if (this.tokenizer.nextToken() == 11) {
            ElementDefinition ed;
            String tagName = this.changeTagCase(this.tokenizer.sval);
            while (this.tokenizer.nextToken() != 62 && this.tokenizer.ttype != -1) {
            }
            EndTag et = new EndTag(tagName);
            this.currentNode = et;
            if (this.docHandler != null && !this.eHandleLogical) {
                this.docHandler.endElement(tagName);
            }
            if ((ed = this.dtd.getElementDefinition(tagName)) != null) {
                this.lastElementNumber = ed.number;
                return et;
            }
            if (this.keepUnknowns) {
                this.lastElementDef = this.anonymousElementDef;
                this.lastElementNumber = this.pcdataNumber + 1;
                return et;
            }
            if (this.handleError(8, et)) {
                return null;
            }
        }
        return null;
    }

    @Override
    public Document getDocument() {
        return this.doc;
    }

    @Override
    public Node getNode() throws ParseException, IOException, SAXException {
        if (this.bufCount == 0) {
            return this.node();
        }
        return this.buf[--this.bufCount];
    }

    @Override
    public void pushBackNode(Node node) {
        this.buf[this.bufCount++] = node;
        if (node instanceof Element) {
            this.lastElementDef = this.dtd.getElementDefinition(node.getNodeName());
            this.lastElementNumber = this.lastElementDef.number;
        }
    }

    protected Reader getResource(String resourceName) throws IOException {
        throw new IOException("cannot find " + resourceName);
    }

    public Node node() throws ParseException, IOException, SAXException {
        Node ret;
        if (this.isEndWithSlash && !this.isEmptyElement) {
            ElementDefinition ed;
            this.isEndWithSlash = false;
            EndTag et = new EndTag(this.currentTagName);
            this.currentNode = et;
            if (this.docHandler != null && !this.eHandleLogical) {
                this.docHandler.endElement(this.currentTagName);
            }
            if ((ed = this.dtd.getElementDefinition(this.currentTagName)) != null) {
                this.lastElementNumber = ed.number;
                return et;
            }
            if (this.keepUnknowns) {
                this.lastElementDef = this.anonymousElementDef;
                this.lastElementNumber = this.pcdataNumber + 1;
                return et;
            }
            if (this.handleError(8, et)) {
                return null;
            }
        }
        switch (this.tokenizer.nextToken()) {
            case 60: {
                ret = this.stag();
                if (ret != null) break;
                ret = this.getNode();
                break;
            }
            case 8: {
                ret = this.etag();
                if (ret != null) break;
                ret = this.node();
                break;
            }
            case 15: {
                this.currentNode = ret = this.doc.createTextNode(this.tokenizer.sval);
                if (ret instanceof SGMLText) {
                    ((SGMLText)ret).setIsWhitespaceInElementContent(true);
                }
                if (this.docHandler == null || this.saxch == null) break;
                this.docHandler.characters(this.saxch, this.begin, this.len);
                this.saxch = null;
                break;
            }
            case 14: {
                this.currentNode = ret = this.doc.createTextNode(this.tokenizer.sval);
                if (this.docHandler == null || this.saxch == null) break;
                this.docHandler.characters(this.saxch, this.begin, this.len);
                this.saxch = null;
                break;
            }
            case 13: {
                this.currentNode = ret = this.doc.createComment(this.tokenizer.sval);
                if (this.lexHandler == null) break;
                this.lexHandler.comment(this.saxch, this.begin, this.len);
                this.saxch = null;
                break;
            }
            case 17: {
                this.currentNode = ret = this.doc.createProcessingInstruction(null, this.tokenizer.sval);
                if (this.docHandler == null) break;
                this.docHandler.processingInstruction(null, this.tokenizer.sval);
                break;
            }
            case -1: {
                ret = null;
                break;
            }
            case 1: {
                this.error(2, "Illegal Declaration. Discarding to next '>'");
                if (this.tokenizer.nextToken() != 62) {
                    this.tokenizer.consumeUntil('>');
                    this.tokenizer.switchTo(0);
                }
                return this.node();
            }
            default: {
                this.error(10, "Internal Parser Error: character encoding may be wrong.");
                return this.node();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setupDTD(String publicID) throws ParseException, IOException {
        SGMLDocTypeDef ret = SGMLDocTypeDef.getPublic(publicID = this.makeUnique(publicID));
        if (ret != null) {
            this.setDTD(ret);
            this.lastDef = ret.getElementDefinition(this.getDefaultTopElement());
        } else {
            String string = publicID;
            synchronized (string) {
                ret = SGMLDocTypeDef.getPublic(publicID);
                if (ret == null) {
                    ret = SGMLDocTypeDef.createPublic(publicID, this);
                    this.setDTD(ret);
                    Reader dr = this.getResource(pubEntityMap.get(publicID));
                    DTDTokenizer tok = new DTDTokenizer(dr);
                    new DTDParser(tok, ret).readDTD();
                    dr.close();
                    SGMLDocTypeDef.putPublic(publicID, ret);
                    ret.rehash();
                } else {
                    this.setDTD(ret);
                }
            }
        }
        this.lastDef = this.dtd.getElementDefinition(this.getDefaultTopElement());
        this.pcdataNumber = this.dtd.getElementCount();
        int i = this.depth - 1;
        while (i >= 0) {
            this.ancesterElementDefs[i] = this.dtd.getElementDefinition(this.ancesterElementDefs[i].getName());
            if (this.ancesterElementDefs[i] == null) {
                this.error(8, String.valueOf(this.ancesters[i].getNodeName()) + " is not defined in " + publicID);
                this.ancesterElementDefs[i] = this.anonymousElementDef;
            }
            --i;
        }
        this.anonymousElementDef.rehash(this.pcdataNumber + 2);
        this.anonymousElementDef.number = this.pcdataNumber + 1;
    }

    public Node parse(Reader reader) throws ParseException, IOException, SAXException {
        if (this.domImpl == null && this.doc == null) {
            throw new ParseException("No factory instance.");
        }
        this.init();
        this.tokenizer = new InsTokenizer(reader, this);
        if (this.docHandler != null) {
            this.docHandler.setDocumentLocator(this.tokenizer);
            this.docHandler.startDocument();
        }
        this.setDTD(SGMLDocTypeDef.createAnonymous(this));
        DocumentType docType = this.readDocType();
        if (docType == null) {
            this.error(1, "<!DOCTYPE ...> is missing.  Try to use \"" + this.defaultDTD + "\" as document type");
            this.setupDTD(this.defaultDTD);
        }
        this.tokenizer.extractNumEntity(this.extractNum);
        this.tokenizer.extractCharEntity(this.extractChar);
        this.tokenizer.setPreserveWhitespace(this.preserveWhitespace);
        if (this.doc == null) {
            this.doc = this.createDocument(docType);
            if (this.doc instanceof SGMLDocument && ((SGMLDocument)this.doc).getDTD() == null) {
                ((SGMLDocument)this.doc).setDTD(this.dtd);
            }
            while (!this.commentsBeforeDoctype.isEmpty()) {
                CATB catb = this.commentsBeforeDoctype.lastElement();
                Node node = catb.comment ? this.doc.createComment(catb.str) : this.doc.createProcessingInstruction(null, catb.str);
                this.doc.insertBefore(node, this.doc.getFirstChild());
                this.commentsBeforeDoctype.removeElement(catb);
            }
        }
        this.context = this.doc.createElement("dummy0");
        this.seqArray = new IModelGroup[this.dtd.maxSeqLength];
        Node ret = this.readInstances();
        if (this.docHandler != null) {
            this.docHandler.endDocument();
        }
        return ret;
    }

    @Override
    public IModelGroup[] getSeqArray() {
        return this.seqArray;
    }

    protected Document createDocument(DocumentType docType) {
        Document ret = this.domImpl.createDocument("dummy1", "dummy1", docType);
        if (ret.getDocumentElement() != null) {
            ret.removeChild(ret.getDocumentElement());
        }
        return ret;
    }

    @Override
    public Element getContext() {
        return this.context;
    }

    private void setContextForward(Element element) throws SAXException {
        Node down;
        if (this.depth >= this.bufSize) {
            Element[] tmpAncesters = new Element[this.bufSize * 2];
            System.arraycopy(this.ancesters, 0, tmpAncesters, 0, this.bufSize);
            this.ancesters = tmpAncesters;
            ElementDefinition[] tmpAncesterElementDefs = new ElementDefinition[this.bufSize * 2];
            System.arraycopy(this.ancesterElementDefs, 0, tmpAncesterElementDefs, 0, this.bufSize);
            this.ancesterElementDefs = tmpAncesterElementDefs;
            this.bufSize *= 2;
        }
        if (this.eHandleLogical && this.docHandler != null) {
            down = this.context.getLastChild();
            while (down instanceof Element) {
                ElementDefinition ed;
                if (down == element) {
                    this.ancesters[this.depth] = element;
                    this.ancesterElementDefs[this.depth] = this.lastElementDef;
                    ++this.depth;
                    this.docHandler.startElement(element.getNodeName(), this.attrlist);
                    this.attrlist = null;
                    this.context = element;
                    return;
                }
                this.ancesters[this.depth] = (Element)down;
                this.ancesterElementDefs[this.depth] = ed = this.dtd.getElementDefinition(down.getNodeName());
                if (ed == null) {
                    this.ancesterElementDefs[this.depth] = this.anonymousElementDef;
                }
                this.docHandler.startElement(down.getNodeName(), this.nullAttributeList);
                ++this.depth;
                down = down.getLastChild();
            }
        } else {
            down = this.context.getLastChild();
            while (down instanceof Element) {
                ElementDefinition ed;
                if (down == element) {
                    this.ancesters[this.depth] = element;
                    this.ancesterElementDefs[this.depth] = this.lastElementDef;
                    ++this.depth;
                    this.attrlist = null;
                    this.context = element;
                    return;
                }
                this.ancesters[this.depth] = (Element)down;
                this.ancesterElementDefs[this.depth] = ed = this.dtd.getElementDefinition(down.getNodeName());
                if (ed == null) {
                    this.ancesterElementDefs[this.depth] = this.anonymousElementDef;
                }
                ++this.depth;
                down = down.getLastChild();
            }
        }
        throw new RuntimeException("Internal Parser Error.");
    }

    private void setContextBackward(int newDepth) throws SAXException {
        if (this.eHandleLogical && this.docHandler != null) {
            int i = this.depth - 1;
            while (i >= newDepth) {
                this.docHandler.endElement(this.ancesters[i].getNodeName());
                --i;
            }
        }
        this.depth = newDepth;
        this.context = this.ancesters[newDepth - 1];
    }

    @Override
    public final void setContext(Element element) throws SAXException {
        Node up;
        int i = this.depth - 1;
        while (i >= 0) {
            up = this.ancesters[i];
            if (up == element) {
                if (this.eHandleLogical && this.docHandler != null) {
                    int j = this.depth - 1;
                    while (j > i) {
                        this.docHandler.endElement(this.ancesters[j].getNodeName());
                        --j;
                    }
                }
                this.depth = i + 1;
                this.context = element;
                return;
            }
            int forwardPathLen = 0;
            Node down = up.getLastChild();
            while (down instanceof Element) {
                if (down == element) {
                    if (this.eHandleLogical && this.docHandler != null) {
                        int j = this.depth - 1;
                        while (j > i) {
                            this.docHandler.endElement(this.ancesters[j].getNodeName());
                            --j;
                        }
                        j = 0;
                        while (j < forwardPathLen) {
                            this.docHandler.startElement(this.forwardPath[j].getNodeName(), this.nullAttributeList);
                            this.ancesters[i + j + 1] = this.forwardPath[j];
                            this.ancesterElementDefs[i + j + 1] = this.dtd.getElementDefinition(this.forwardPath[j].getNodeName());
                            if (this.ancesterElementDefs[i + j + 1] == null) {
                                this.ancesterElementDefs[i + j + 1] = this.anonymousElementDef;
                            }
                            ++j;
                        }
                        this.docHandler.startElement(down.getNodeName(), this.attrlist);
                    } else {
                        int j = 0;
                        while (j < forwardPathLen) {
                            this.ancesters[i + j + 1] = this.forwardPath[j];
                            this.ancesterElementDefs[i + j + 1] = this.dtd.getElementDefinition(this.forwardPath[j].getNodeName());
                            if (this.ancesterElementDefs[i + j + 1] == null) {
                                this.ancesterElementDefs[i + j + 1] = this.anonymousElementDef;
                            }
                            ++j;
                        }
                    }
                    this.depth = i + forwardPathLen + 1;
                    this.ancesters[this.depth] = element;
                    this.ancesterElementDefs[this.depth] = this.lastElementDef;
                    ++this.depth;
                    this.attrlist = null;
                    this.context = element;
                    return;
                }
                this.forwardPath[forwardPathLen++] = (Element)down;
                down = down.getLastChild();
            }
            --i;
        }
        int newDepth = 0;
        up = element;
        while (up instanceof Element) {
            ++newDepth;
            up = up.getParentNode();
        }
        Element[] newAncesters = new Element[newDepth];
        int i2 = 1;
        Node up2 = element;
        while (up2 instanceof Element) {
            newAncesters[newDepth - i2] = up2;
            ++i2;
            up2 = up2.getParentNode();
        }
        i2 = 0;
        while (i2 < newDepth) {
            if (this.ancesters[i2] != newAncesters[i2]) {
                if (this.eHandleLogical && this.docHandler != null) {
                    int j = this.depth - 1;
                    while (j >= i2) {
                        this.docHandler.endElement(this.ancesters[j].getNodeName());
                        --j;
                    }
                    j = i2;
                    while (j < newDepth - 1) {
                        this.docHandler.startElement(newAncesters[j].getNodeName(), this.nullAttributeList);
                        ++j;
                    }
                    this.docHandler.startElement(element.getNodeName(), this.attrlist);
                }
                while (i2 < newDepth - 1) {
                    this.ancesters[i2] = newAncesters[i2];
                    this.ancesterElementDefs[i2] = this.dtd.getElementDefinition(newAncesters[i2].getNodeName());
                }
                this.ancesters[newDepth - 1] = element;
                this.ancesterElementDefs[newDepth - 1] = this.lastElementDef;
                this.depth = newDepth;
                this.attrlist = null;
                this.context = element;
                return;
            }
            ++i2;
        }
    }

    @Override
    public boolean hasEndTag(Element element) {
        return this.nodesWithEndtag.contains(element);
    }

    @Override
    public void setHasEndTag(Element element) {
        this.nodesWithEndtag.addElement(element);
    }

    private void setTopElement(Element element) throws SAXException {
        Element prev = this.doc.getDocumentElement();
        if (prev != null) {
            this.doc.replaceChild(element, prev);
        } else {
            this.doc.appendChild(element);
        }
        this.context = element;
        if (this.docHandler != null && this.eHandleLogical) {
            AttributeListImpl al = this.attrlist != null ? this.attrlist : this.nullAttributeList;
            this.docHandler.startElement(element.getNodeName(), al);
            this.attrlist = null;
        }
        this.ancesterElementDefs[0] = this.lastDef;
        this.ancesters[0] = element;
        ++this.depth;
    }

    /*
     * Unable to fully structure code
     */
    private Node readInstances() throws ParseException, IOException, SAXException {
        node = this.getNode();
        if (node != null) ** GOTO lbl8
        return this.doc;
lbl-1000:
        // 1 sources

        {
            if (this.keepComment) {
                this.doc.appendChild(node);
            }
            node = this.getNode();
lbl8:
            // 2 sources

            ** while (node.getNodeType() == 8 || node.getNodeType() == 7)
        }
lbl9:
        // 1 sources

        switch (node.getNodeType()) {
            case -1: {
                if (!this.handleError(5, node)) {
                    if (this.eHandleLogical && this.docHandler != null) {
                        this.docHandler.ignorableWhitespace(this.saxch, this.begin, this.len);
                    }
                    this.error(5, "Illegal end tag: " + node + ".  Ignore it.");
                }
                return this.readInstances();
            }
            case 1: {
                if (this.lastDef.instance(node)) {
                    this.setTopElement((Element)node);
                } else {
                    attrlisttmp = this.attrlist;
                    this.attrlist = null;
                    this.setTopElement(this.doc.createElement(this.changeDefaultTagCase(this.lastDef.getName())));
                    this.attrlist = attrlisttmp;
                    this.addAutoGenerated(this.context);
                    if (this.lastDef.getContentModel().match(this, this.context, node)) {
                        if (!this.lastDef.startTagOmittable()) {
                            this.error(3, node + " can't be a top element.");
                        }
                        this.setContextForward((Element)node);
                    } else if (!this.handleError(7, node)) {
                        this.addErrorNode(this.context);
                        this.error(7, node + " is not allowed as a child of " + this.context);
                        this.context.appendChild(node);
                        this.setContextForward((Element)node);
                    }
                }
                this.postElement((Element)node);
                break;
            }
            case 3: {
                if (this.preserveWhitespace && this.whitespaceText((Text)node)) {
                    return this.readInstances();
                }
                this.error(3, "#text can't be a top element");
                this.setTopElement(this.doc.createElement(this.changeDefaultTagCase(this.lastDef.getName())));
                this.addAutoGenerated(this.context);
                this.context.appendChild(node);
                break;
            }
            default: {
                throw new ParseException(String.valueOf(this.tokenizer.getCurrentLine()) + ": Internal Parser Error " + node);
            }
        }
        return this.readInstances2();
    }

    private Node readInstances2() throws ParseException, IOException, SAXException {
        Node node = this.getNode();
        block6: while (node != null) {
            block0 : switch (node.getNodeType()) {
                case 7: 
                case 8: {
                    if (!this.keepComment) break;
                    this.context.appendChild(node);
                    break;
                }
                case -1: {
                    this.missedEndtags.removeAllElements();
                    int i = this.depth - 1;
                    while (i >= 0) {
                        if (this.ancesterElementDefs[i].number == this.lastElementNumber && (this.lastElementNumber != this.pcdataNumber + 1 || this.ancesters[i].getNodeName().equalsIgnoreCase(node.getNodeName()))) {
                            if (!this.missedEndtags.isEmpty()) {
                                this.extraErrInfo = this.missedEndtags;
                                if (this.handleError(6, node)) {
                                    this.extraErrInfo = null;
                                    break block0;
                                }
                                this.extraErrInfo = null;
                                this.error(6, this.missedEndtags + " have been forced to be inserted by " + node);
                            }
                            ((EndTag)node).setElement(this.ancesters[i]);
                            this.nodesWithEndtag.addElement(this.ancesters[i]);
                            if (i <= 0) break block6;
                            this.setContextBackward(i);
                            break block0;
                        }
                        if (!this.ancesterElementDefs[i].endTagOmittable()) {
                            this.missedEndtags.insertElementAt(new EndTag(this.ancesters[i].getNodeName()), 0);
                        }
                        --i;
                    }
                    if (this.handleError(5, node)) break;
                    if (this.eHandleLogical && this.docHandler != null) {
                        this.docHandler.ignorableWhitespace(this.saxch, this.begin, this.len);
                    }
                    this.error(5, "Illegal end tag: " + node + ".  Ignore it");
                    break;
                }
                case 1: {
                    ElementDefinition ed;
                    Element element = (Element)node;
                    Element exParent = null;
                    int i = this.depth - 1;
                    while (i >= 0) {
                        ed = this.ancesterElementDefs[i];
                        if (!ed.endTagOmittable() && exParent == null) {
                            exParent = this.ancesters[i];
                        }
                        if (ed.exclusion(this.lastElementNumber)) {
                            if (exParent != null) {
                                if (!this.handleError(7, node)) {
                                    this.addErrorNode(this.context);
                                    this.error(7, node + " is an exception uner " + this.ancesters[i]);
                                    break;
                                }
                                if (this.context != node && this.eHandleLogical && this.docHandler != null) {
                                    this.docHandler.startElement(node.getNodeName(), this.attrlist);
                                }
                                this.postElement(element);
                                break block0;
                            }
                            if (this.ancesters[i - 1] == null) break;
                            this.setContextBackward(i);
                            break;
                        }
                        if (ed.inclusion(this.lastElementNumber)) {
                            this.context.appendChild(node);
                            this.setContextForward(element);
                            this.postElement(element);
                            break block0;
                        }
                        --i;
                    }
                    ed = this.ancesterElementDefs[this.depth - 1];
                    IModelGroup contentModel = ed.getContentModel();
                    if (contentModel.match(this.lastElementNumber) && contentModel.match(this, this.context, node)) {
                        this.setContextForward(element);
                    } else if (ed.endTagOmittable()) {
                        boolean found = false;
                        int i2 = this.depth - 2;
                        while (i2 >= 0) {
                            ed = this.ancesterElementDefs[i2];
                            contentModel = ed.getContentModel();
                            if (contentModel.match(this.lastElementNumber) && (found = contentModel.match(this, this.ancesters[i2], node)) || !ed.endTagOmittable()) break;
                            --i2;
                        }
                        if (found) {
                            this.setContext(element);
                        } else if (!this.handleError(7, node)) {
                            this.context.appendChild(element);
                            this.addErrorNode(this.context);
                            this.error(7, node + " is not allowed as a child of " + this.context);
                            this.setContextForward(element);
                        } else if (element.getParentNode() != null) {
                            this.postElement(element);
                            break;
                        }
                    } else if (!this.handleError(7, node)) {
                        this.context.appendChild(element);
                        this.addErrorNode(this.context);
                        this.error(7, node + " is not allowed as a child of " + this.context);
                        this.setContextForward(element);
                    }
                    if (this.context != node && this.eHandleLogical && this.docHandler != null) {
                        this.docHandler.startElement(node.getNodeName(), this.attrlist);
                    }
                    this.postElement(element);
                    break;
                }
                case 3: {
                    if (this.preserveWhitespace && this.whitespaceText((Text)node)) {
                        this.getContext().appendChild(node);
                        break;
                    }
                    ElementDefinition ed = this.ancesterElementDefs[this.depth - 1];
                    IModelGroup contentModel = ed.getContentModel();
                    if (contentModel.match(this.pcdataNumber) && contentModel.match(this, this.context, node)) break;
                    if (ed.endTagOmittable()) {
                        int i = this.depth - 2;
                        while (i >= 0) {
                            ed = this.ancesterElementDefs[i];
                            contentModel = ed.getContentModel();
                            if (contentModel.match(this.pcdataNumber) && contentModel.match(this, this.ancesters[i], node)) break block0;
                            if (!ed.endTagOmittable()) break;
                            --i;
                        }
                    }
                    if (this.handleError(7, node)) break;
                    this.addErrorNode(this.context);
                    this.error(7, "#text(" + node + ") is not allowed as a child of " + this.context);
                    this.context.appendChild(node);
                    break;
                }
                default: {
                    throw new ParseException(String.valueOf(this.tokenizer.getCurrentLine()) + ": Internal parser error " + node);
                }
            }
            node = this.getNode();
        }
        if (this.docHandler != null && this.eHandleLogical) {
            Element top = this.doc.getDocumentElement();
            if (this.getContext() != top) {
                this.setContext(top);
            }
            if (top != null) {
                this.docHandler.endElement(top.getNodeName());
            }
        }
        if ((node = this.getNode()) != null) {
            this.context = this.doc.getDocumentElement();
            if (this.docHandler != null && this.eHandleLogical) {
                this.docHandler.startElement(this.context.getNodeName(), this.nullAttributeList);
            }
            this.pushBackNode(node);
            this.readInstances2();
        }
        return this.doc;
    }

    private boolean whitespaceText(Text text) {
        if (text instanceof SGMLText) {
            return ((SGMLText)text).getIsWhitespaceInElementContent();
        }
        char[] str = text.getData().toCharArray();
        int i = str.length - 1;
        while (i >= 0) {
            if (!Character.isWhitespace(str[i])) {
                return false;
            }
            --i;
        }
        return true;
    }

    private void postElement(Element element) throws ParseException, IOException, SAXException {
        IModelGroup mg = this.lastElementDef.getContentModel();
        if (mg == cdata) {
            String tagName = element.getNodeName();
            CDATASection cdata = this.readCDATA(tagName);
            this.currentNode = new EndTag(tagName);
            ((EndTag)this.currentNode).setElement(element);
            this.nodesWithEndtag.addElement(element);
            if (this.docHandler != null && !this.eHandleLogical) {
                this.docHandler.endElement(tagName);
            }
            element.appendChild(cdata);
            if (this.context == element) {
                this.setContextBackward(this.depth - 1);
            }
        } else if (mg == empty && this.lastElementDef.endTagOmittable()) {
            if (this.context == element) {
                this.setContextBackward(this.depth - 1);
            } else if (this.eHandleLogical && this.docHandler != null) {
                this.docHandler.endElement(element.getNodeName());
            }
        } else if (this.isXHTML) {
            // empty if block
        }
    }

    private CDATASection readCDATA(String arg) throws ParseException, IOException, SAXException {
        if (this.lexHandler != null) {
            this.lexHandler.startCDATA();
        }
        String str = this.tokenizer.rawText(arg);
        CDATASection ret = this.doc.createCDATASection(str);
        this.currentNode = ret;
        if (this.lexHandler != null) {
            this.lexHandler.endCDATA();
        }
        this.tokenizer.eatCDATAEndTag();
        return ret;
    }

    private DocumentType readDocType() throws ParseException, IOException, SAXException {
        if (this.lastDef != null) {
            throw new ParseException("Already read DOCTYPE declaration");
        }
        block5: while (true) {
            switch (this.tokenizer.nextToken()) {
                case 13: {
                    CATB catb;
                    if (this.doc == null) {
                        catb = new CATB();
                        catb.str = this.tokenizer.sval;
                        this.commentsBeforeDoctype.addElement(catb);
                    } else {
                        this.currentNode = this.doc.createComment(this.tokenizer.sval);
                        this.doc.appendChild(this.currentNode);
                    }
                    if (this.lexHandler == null) continue block5;
                    this.lexHandler.comment(this.saxch, this.begin, this.len);
                    continue block5;
                }
                case 17: {
                    CATB catb;
                    if (this.doc == null) {
                        catb = new CATB();
                        catb.comment = false;
                        catb.str = this.tokenizer.sval;
                        this.commentsBeforeDoctype.addElement(catb);
                    } else {
                        this.currentNode = this.doc.createProcessingInstruction(null, this.tokenizer.sval);
                        this.doc.appendChild(this.currentNode);
                    }
                    if (this.docHandler == null) continue block5;
                    this.docHandler.processingInstruction(null, this.tokenizer.sval);
                    continue block5;
                }
                case 1: {
                    break block5;
                }
                default: {
                    this.tokenizer.pushBack();
                    return null;
                }
            }
            break;
        }
        if (this.tokenizer.nextToken() != 11 && !this.tokenizer.sval.equals("DOCTYPE")) {
            throw new ParseException("Unknown declaration at " + this.tokenizer.getCurrentLine());
        }
        if (this.tokenizer.nextToken() == 11) {
            String docTypeName;
            this.defaultTopElement = docTypeName = this.tokenizer.sval;
            if (this.tokenizer.nextToken() == 11 && this.tokenizer.sval.equalsIgnoreCase("PUBLIC") && this.tokenizer.nextToken() == 34) {
                String entityFileName;
                String publicID;
                String orgId = publicID = this.tokenizer.eatUntil('\"');
                if (this.enforcedDoctype != null) {
                    publicID = this.enforcedDoctype;
                }
                if (this.lexHandler != null) {
                    this.lexHandler.startDTD(docTypeName, publicID, null);
                }
                if ((entityFileName = pubEntityMap.get(publicID)) == null) {
                    if (this.defaultDTD != null) {
                        this.error(2, "Instead of \"" + publicID + "\" use \"" + this.defaultDTD + "\" as a DTD.");
                        entityFileName = pubEntityMap.get(this.defaultDTD);
                    }
                    if (entityFileName == null) {
                        throw new ParseException(String.valueOf(this.tokenizer.getCurrentLine()) + ": this parser does not support " + publicID);
                    }
                    publicID = this.defaultDTD;
                }
                this.setupDTD(publicID);
                if (this.domImpl == null) {
                    this.domImpl = this.doc.getImplementation();
                }
                DocumentType ret = null;
                if (this.domImpl != null) {
                    ret = this.createDocType(this.domImpl, docTypeName, publicID);
                    this.currentNode = ret;
                    if (!publicID.equals(orgId) && ret instanceof SGMLDocType) {
                        ((SGMLDocType)ret).setOrgId(orgId);
                    }
                }
                this.tokenizer.consumeUntil('>');
                this.tokenizer.switchTo(0);
                this.lastDef = this.dtd.getElementDefinition(docTypeName);
                if (this.lastDef == null) {
                    String topElementName = this.getDefaultTopElement();
                    this.error(2, String.valueOf(docTypeName) + " is not defined as a root element.  Use " + topElementName + '.');
                    this.lastDef = this.dtd.getElementDefinition(topElementName);
                }
                if (this.lexHandler != null) {
                    this.lexHandler.endDTD();
                }
                return ret;
            }
        }
        this.tokenizer.consumeUntil('>');
        this.error(2, "Invalid DOCTYPE declaration. Use " + this.defaultDTD);
        this.setupDTD(this.defaultDTD);
        this.lastDef = this.dtd.getElementDefinition(this.getDefaultTopElement());
        return null;
    }

    private DocumentType createDocType(DOMImplementation domImpl, String docTypeName, String publicID) {
        Method method;
        Class<?> domImplClass = domImpl.getClass();
        Class<?> stringClass = docTypeName.getClass();
        Class[] parameterTypes = new Class[]{stringClass, stringClass, stringClass};
        try {
            method = domImplClass.getMethod("createDocumentType", parameterTypes);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        Object[] args = new String[]{docTypeName, publicID, ""};
        try {
            return (DocumentType)method.invoke((Object)domImpl, args);
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
        catch (DOMException dOMException) {
            return null;
        }
    }

    private void expandNodesWithIllegalChildren() {
        Node[] newNodes = new Node[this.nodeWithIllegalChildNum * 2];
        System.arraycopy(this.nodesWithIllegalChildren, 0, newNodes, 0, this.nodeWithIllegalChildNum);
        this.nodesWithIllegalChildren = newNodes;
    }

    private void addErrorNode(Node node) {
        int i = this.nodeWithIllegalChildNum - 1;
        while (i >= 0) {
            if (this.nodesWithIllegalChildren[i] == node) {
                return;
            }
            --i;
        }
        if (this.nodesWithIllegalChildren.length == this.nodeWithIllegalChildNum) {
            this.expandNodesWithIllegalChildren();
        }
        this.nodesWithIllegalChildren[this.nodeWithIllegalChildNum++] = node;
    }

    public boolean isErrorNode(Node node) {
        int i = this.nodeWithIllegalChildNum - 1;
        while (i >= 0) {
            if (this.nodesWithIllegalChildren[i] == node) {
                return true;
            }
            --i;
        }
        return false;
    }

    protected void init() {
        this.lastDef = null;
        this.context = null;
        this.nodeWithIllegalChildNum = 0;
        this.depth = 0;
        this.andMap.clear();
        this.seqMap.clear();
        this.plusMap.clear();
        this.commentsBeforeDoctype.removeAllElements();
        if (this.getDOMImplementation() != null) {
            this.setDOMImplementation(this.getDOMImplementation());
        } else {
            Node child = this.doc.getFirstChild();
            while (child != null) {
                this.doc.removeChild(child);
                child = this.doc.getFirstChild();
            }
        }
    }

    int getCharEntity(String entity) throws IOException, ParseException, SAXException {
        SGMLEntityReference er = null;
        try {
            er = this.dtd.getEntityReference(entity);
        }
        catch (ParseException parseException) {
            return -1;
        }
        SGMLEntityDeclaration ed = er.getEntityDeclaration();
        int ch = ed.getReplacementChar();
        if (ch != -1) {
            return ch;
        }
        InsTokenizer tokenizer2 = new InsTokenizer(ed.getReplacementReader(), this);
        if (tokenizer2.nextToken() == 14 && tokenizer2.sval.length() == 1) {
            char ret = tokenizer2.sval.charAt(0);
            ed.setReplacementChar(ret);
            return ret;
        }
        throw new ParseException("Internal Parser Error: " + entity + " not defined.");
    }

    public void setDocument(Document doc) {
        this.doc = doc;
        this.domImpl = null;
    }

    private Node stag() throws IOException, ParseException, SAXException {
        ElementDefinition ed;
        this.isEmptyElement = true;
        this.isEndWithSlash = false;
        if (this.tokenizer.nextToken() != 11) {
            if (this.handleError(13, this.tokenizer.sval)) {
                return this.stag();
            }
            this.error(9, "Perhaps character encoding may not be correct.");
            while (this.tokenizer.nextToken() != 11) {
                if (this.tokenizer.ttype != -1 && this.tokenizer.ttype != 62) continue;
                return null;
            }
        }
        if ((ed = this.dtd.getElementDefinition(this.tokenizer.sval)) != null) {
            this.lastElementNumber = ed.number;
            this.lastElementDef = ed;
            this.isEmptyElement = ed.getContentModel().toString().equalsIgnoreCase("EMPTY");
        } else if (this.keepUnknowns) {
            this.lastElementNumber = this.pcdataNumber + 1;
            ed = this.lastElementDef = this.anonymousElementDef;
        }
        Element ret = this.doc.createElement(this.changeTagCase(this.tokenizer.sval));
        this.currentNode = ret;
        Attr attr = null;
        if (this.docHandler != null) {
            this.attrlist = this.createAttributeList();
        }
        this.isEndWithSlash = false;
        while (this.tokenizer.nextToken() != 62) {
            this.isEndWithSlash = this.tokenizer.ttype == 47;
            if (this.tokenizer.ttype == 60 || this.tokenizer.ttype == 8) {
                if (this.handleError(12, this.tokenizer.sval)) continue;
                this.error(9, "requires an attribute in " + ret);
                this.tokenizer.pushBack();
                break;
            }
            if (this.tokenizer.ttype == -1) break;
            this.tokenizer.pushBack();
            attr = this.attribute(ed, this.attrlist);
            if (attr == null) continue;
            ret.setAttributeNode(attr);
        }
        if (this.docHandler != null && !this.eHandleLogical) {
            this.docHandler.startElement(ret.getNodeName(), this.attrlist);
        }
        if (ed == null) {
            if (!this.handleError(8, ret)) {
                this.error(8, "Unknown Element: " + ret.getTagName() + ".  Ignore it.");
            }
            return null;
        }
        if (ed == this.anonymousElementDef) {
            if (this.handleError(8, ret)) {
                return null;
            }
            this.error(8, "Unknown Element: " + ret.getTagName() + ".  Define its definition as <!ELEMENT " + ret.getNodeName().toUpperCase() + " - - ANY>");
        }
        this.currentTagName = ret.getNodeName();
        return ret;
    }

    public String makeUnique(String id) {
        Enumeration<String> e = pubEntityMap.elements();
        while (e.hasMoreElements()) {
            String ret = e.nextElement();
            if (!id.equals(ret)) continue;
            return ret;
        }
        return id;
    }

    public void setDefaultDTD(String dtd) {
        this.defaultDTD = this.makeUnique(dtd);
    }

    protected String getDefaultTopElement() throws ParseException {
        if (this.defaultTopElement != null) {
            return this.defaultTopElement;
        }
        throw new ParseException("doesn't know which element must be at the top.");
    }

    @Override
    public void setDefaultTagCase(int tagCase) {
        if (tagCase == 0 || tagCase == 1) {
            this.defaultTagCase = tagCase;
        }
    }

    @Override
    public String changeDefaultTagCase(String tag) {
        switch (this.defaultTagCase) {
            case 0: {
                return tag.toUpperCase();
            }
            case 1: {
                return tag.toLowerCase();
            }
        }
        throw new RuntimeException("Internal Parser Error");
    }

    @Override
    public void setTagCase(int tagCase) {
        if (tagCase == 0 || tagCase == 1 || tagCase == 2) {
            this.tagCase = tagCase;
        }
    }

    final String changeTagCase(String tag) {
        switch (this.tagCase) {
            case 0: {
                return tag.toUpperCase();
            }
            case 1: {
                return tag.toLowerCase();
            }
            case 2: {
                return tag;
            }
        }
        throw new RuntimeException("Internal Parser Error");
    }

    @Override
    public void setAttrNameCase(int attrCase) {
        if (attrCase == 0 || attrCase == 1 || attrCase == 2) {
            this.attrCase = attrCase;
        }
    }

    final String changeAttrNameCase(String attr) {
        switch (this.attrCase) {
            case 0: {
                return attr.toUpperCase();
            }
            case 1: {
                return attr.toLowerCase();
            }
            case 2: {
                return attr;
            }
        }
        throw new RuntimeException("Internal Parser Error");
    }

    public void enforceDoctype(String publicId) {
        this.enforcedDoctype = this.makeUnique(publicId);
    }

    public void close() throws IOException {
        this.tokenizer.close();
        this.tokenizer = null;
    }

    @Override
    public Object getExtraErrInfo() {
        return this.extraErrInfo;
    }

    private boolean handleError(int code, Node node) throws ParseException, IOException, SAXException {
        int i = this.errorHandlerNum - 1;
        while (i >= 0) {
            if (this.errorHandlers[i].handleError(code, this, node)) {
                return true;
            }
            --i;
        }
        return false;
    }

    boolean handleError(int code, String errorStr) throws ParseException, IOException {
        int i = this.tokenErrorHandlerNum - 1;
        while (i >= 0) {
            if (this.tokenErrorHandlers[i].handleError(code, this, errorStr)) {
                return true;
            }
            --i;
        }
        return false;
    }

    void putCharNumEntity(Character C, String ent) {
        Document doc = this.getDocument();
        if (doc instanceof SGMLDocument) {
            ((SGMLDocument)doc).putCharNumEntity(C, ent);
        }
    }

    public DocumentHandler getDocumentHandler() {
        return this.docHandler;
    }

    @Override
    public void setDocumentHandler(DocumentHandler handler) {
        this.docHandler = handler;
    }

    @Override
    public boolean getPreserveWhitespace() {
        return this.preserveWhitespace;
    }

    @Override
    public void setPreserveWhitespace(boolean preserv) {
        if (this.tokenizer != null) {
            this.tokenizer.setPreserveWhitespace(preserv);
        }
        this.preserveWhitespace = preserv;
    }

    @Override
    public void elementHandle(boolean logical) {
        this.eHandleLogical = logical;
    }

    @Override
    public boolean autoGenerated(Element element) {
        return this.autoGenerated.contains(element);
    }

    @Override
    public final void addAutoGenerated(Element element) {
        this.autoGenerated.addElement(element);
    }

    @Override
    public void insert(String str) throws IOException {
        this.tokenizer.unread(str);
    }

    private AttributeListImpl createAttributeList() {
        return new AttributeListImpl();
    }

    @Override
    public void keepUnknownElements(boolean keep) {
        this.keepUnknowns = keep;
    }

    public int getCurrentLineNumber() {
        return this.tokenizer.getCurrentLine();
    }

    public int getCurrentColumnNumber() {
        return this.tokenizer.getCurrentCol();
    }

    public Node getCurrentNode() {
        return this.currentNode;
    }

    @Override
    public void setCurrentNode(Node node) {
        this.currentNode = node;
    }

    public void setKeepComment(boolean keep) {
        this.keepComment = keep;
    }

    void setCharacter(char[] ch, int begin, int len) {
        this.saxch = ch;
        this.begin = begin;
        this.len = len;
    }

    public void setLexicalHandler(LexicalHandler lexHandler) {
        this.lexHandler = lexHandler;
    }

    LexicalHandler getLexicalHandler() {
        return this.lexHandler;
    }

    void incrementDepth(int i) {
        this.depth += i;
    }

    @Override
    public void reopenContext(int i) throws SAXException {
        this.depth += i;
        this.context = this.ancesters[this.depth - 1];
        if (!this.eHandleLogical || this.docHandler == null) {
            return;
        }
        int j = this.depth;
        while (j < i) {
            this.docHandler.startElement(this.ancesters[j].getNodeName(), this.nullAttributeList);
            ++j;
        }
    }

    @Override
    public Element[] getContextElements() {
        Element[] ret = new Element[this.depth];
        System.arraycopy(this.ancesters, 0, ret, 0, this.depth);
        return ret;
    }

    public void parseFragment(Element parent, Reader reader) throws IOException, ParseException, SAXException {
        if (this.dtd == null) {
            throw new ParseException("Can't parse without DTD");
        }
        if (this.doc == null) {
            throw new ParseException("Can't parse without a Document");
        }
        this.ancesterElementDefs[0] = this.dtd.getElementDefinition(parent.getNodeName());
        if (this.ancesterElementDefs[0] == null) {
            this.ancesterElementDefs[0] = this.anonymousElementDef;
        }
        this.ancesters[0] = parent;
        this.context = parent;
        this.depth = 1;
        this.tokenizer = new InsTokenizer(reader, this);
        if (this.docHandler != null) {
            this.docHandler.setDocumentLocator(this.tokenizer);
        }
        this.tokenizer.extractNumEntity(this.extractNum);
        this.tokenizer.extractCharEntity(this.extractChar);
        this.tokenizer.setPreserveWhitespace(this.preserveWhitespace);
        this.readInstances2();
    }

    public DocumentFragment parseFragment(Reader reader) throws IOException, ParseException, SAXException {
        Element dummy = this.doc != null ? this.doc.createElement("dummy") : null;
        this.parseFragment(dummy, reader);
        DocumentFragment ret = this.doc.createDocumentFragment();
        Node child = dummy.getFirstChild();
        while (child != null) {
            dummy.removeChild(child);
            ret.appendChild(child);
            child = dummy.getFirstChild();
        }
        return ret;
    }

    @Override
    public int getPushbackBufferSize() {
        return 256;
    }

    class CATB {
        boolean comment = true;
        String str;

        CATB() {
        }
    }
}

