/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.dom.sgml.errorhandler;

import java.io.IOException;
import org.eclipse.actf.model.internal.dom.sgml.ISGMLConstants;
import org.eclipse.actf.model.internal.dom.sgml.ISGMLParser;
import org.eclipse.actf.model.internal.dom.sgml.errorhandler.ITokenErrorHandler;

public class AttributeValueErrorHandler
implements ITokenErrorHandler,
ISGMLConstants {
    public boolean handleError(int code, ISGMLParser parser, String errorStr) throws IOException {
        int ltIndex;
        if (code != 11) {
            return false;
        }
        int gtIndex = errorStr.indexOf(62);
        int errorStrLen = errorStr.length();
        if (errorStrLen == 0) {
            return false;
        }
        char closingChar = errorStr.charAt(0);
        if (closingChar != '\'' && closingChar != '\"') {
            return false;
        }
        if (gtIndex > 1 && (ltIndex = errorStr.indexOf(60)) > gtIndex) {
            char c0;
            int nextTagBegin = ltIndex + 1;
            if (errorStr.charAt(nextTagBegin) == '/') {
                ++nextTagBegin;
            }
            int nextTagEnd = nextTagBegin;
            while (Character.isLowerCase(c0 = errorStr.charAt(nextTagEnd)) || Character.isUpperCase(c0)) {
                ++nextTagEnd;
            }
            if (nextTagBegin == nextTagEnd) {
                return false;
            }
            String nextTag = errorStr.substring(nextTagBegin, nextTagEnd);
            if (parser.getDTD().getElementDefinition(nextTag) != null) {
                parser.error(9, " attribute value missed closing quotation.");
                parser.insert(String.valueOf(errorStr.substring(0, gtIndex)) + closingChar + errorStr.substring(gtIndex));
                return true;
            }
        } else if (errorStr.charAt(errorStrLen - 1) == closingChar && errorStr.length() > 1 && errorStr.charAt(errorStrLen - 2) == '=') {
            int i = 0;
            while (i < errorStrLen) {
                if (Character.isWhitespace(errorStr.charAt(i))) {
                    int errorPoint = i;
                    while (Character.isWhitespace(errorStr.charAt(++i))) {
                    }
                    char c0 = errorStr.charAt(i);
                    if (!Character.isLowerCase(c0) && !Character.isUpperCase(c0)) {
                        return false;
                    }
                    while (Character.isLowerCase(c0 = errorStr.charAt(++i)) || Character.isUpperCase(c0)) {
                    }
                    while (Character.isWhitespace(c0 = errorStr.charAt(i))) {
                        ++i;
                    }
                    if (c0 == '=') {
                        parser.insert(String.valueOf(errorStr.substring(0, errorPoint)) + closingChar + errorStr.substring(errorPoint));
                        parser.error(9, " attribute value missed closing quotation.");
                        return true;
                    }
                }
                ++i;
            }
        }
        return false;
    }
}

