/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.html.errorhandler;

import java.io.IOException;
import org.eclipse.actf.model.dom.html.IErrorHandler;
import org.eclipse.actf.model.dom.html.IParser;
import org.eclipse.actf.model.dom.html.ParseException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLAnchorElement;
import org.xml.sax.SAXException;

public class AnchorUnderAnchorHandler
implements IErrorHandler {
    private boolean isAnchor(Node node) {
        return node instanceof HTMLAnchorElement || node instanceof Element && node.getNodeName().equalsIgnoreCase("A");
    }

    public boolean handleError(int code, IParser parser, Node errorNode) throws ParseException, IOException, SAXException {
        if (code == 7 && this.isAnchor(errorNode)) {
            Node node = parser.getContext();
            while (node instanceof Element) {
                if (this.isAnchor(node)) {
                    Node parent = node.getParentNode();
                    parent.insertBefore(errorNode, null);
                    parser.setContext((Element)errorNode);
                    return true;
                }
                node = node.getParentNode();
            }
        }
        return false;
    }
}

