/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.scripteditor.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.eclipse.actf.ai.scripteditor.preferences.CapturePreferenceUtil;
import org.eclipse.actf.ai.ui.scripteditor.views.IUNIT;

public class SoundMixer
implements IUNIT {
    private static SoundMixer ownInst = null;
    private static int ownProcMode = 0;
    private Thread mainThreadCapture = null;
    protected boolean runningCapture = false;
    private DataLine.Info voiceInfo = null;
    private TargetDataLine voiceLine = null;
    private ByteArrayOutputStream voiceOutputStream = null;
    private byte[] voiceCaptureBuffer;
    private byte[] voiceStoreBuffer;
    private byte[] voiceClearData;
    private float voiceSampleRate = 22050.0f;
    private AudioInputStream voiceInputStream = null;
    private AudioFileFormat.Type voiceTargetType;
    private File saveFH;
    private String currentWavFormatID;
    private int currentWavCh;
    private float currentWavFrameRate;
    private int currentWavFrameSize;
    private float currentWavSampRate;
    private int currentWavSampBit;
    private boolean currentWavBigEndian;
    private String currentWavFormat;
    private int currentWavBytePerSec;
    private int currentWavDurationTime;
    private int currentWavDataLength;
    private Thread mainThreadPlayer = null;
    private boolean runningPlayer = false;
    private AudioInputStream audioInputStreamWavPlayer;
    private SourceDataLine lineWavPlayer;

    private SoundMixer() {
        this.setSampleRateCaptureAudio(CapturePreferenceUtil.getPreferenceSampleRate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SoundMixer getInstance() {
        if (ownInst != null) return ownInst;
        Class<SoundMixer> clazz = SoundMixer.class;
        synchronized (SoundMixer.class) {
            if (ownInst != null) return ownInst;
            ownInst = new SoundMixer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return ownInst;
        }
    }

    public void dispose() {
        try {
            if (this.voiceOutputStream != null) {
                this.voiceOutputStream.close();
            }
            if (ownInst != null) {
                ownInst = null;
            }
        }
        catch (Exception e) {
            System.out.println("SoundMixer.dispose() : " + e);
        }
    }

    public void startCaptureSound(int procMode) {
        ownProcMode = procMode;
        if (ownProcMode == 0) {
            this.startCaptureAudio();
        } else if (ownProcMode == 1) {
            this.startSaveFileCaptureAudio();
        }
    }

    private void startCaptureAudio() {
        try {
            AudioFormat format = this.getFormat();
            this.voiceInfo = new DataLine.Info(TargetDataLine.class, format);
            this.voiceLine = (TargetDataLine)AudioSystem.getLine(this.voiceInfo);
            int bufferSize = format.getFrameSize();
            this.voiceCaptureBuffer = new byte[bufferSize];
            this.voiceStoreBuffer = new byte[bufferSize];
            this.voiceClearData = new byte[bufferSize];
            int i = 0;
            while (i < this.voiceClearData.length) {
                this.voiceClearData[i] = 0;
                ++i;
            }
            if (this.voiceOutputStream == null) {
                this.voiceOutputStream = new ByteArrayOutputStream();
            } else if (this.voiceOutputStream.size() > 0) {
                this.voiceOutputStream.reset();
            }
            this.mainThreadCapture = new CaptureVoiceThread();
            this.runningCapture = true;
            this.voiceLine.open(format);
            this.voiceLine.start();
            this.mainThreadCapture.start();
        }
        catch (LineUnavailableException e) {
            System.err.println("Line unavailable: " + e);
        }
    }

    public void startSaveFileCaptureAudio() {
        try {
            AudioFormat format = this.getFormat();
            this.voiceInfo = new DataLine.Info(TargetDataLine.class, format);
            this.voiceLine = (TargetDataLine)AudioSystem.getLine(this.voiceInfo);
            this.saveFH = new File("c:\\temp\\dummy.wav");
            this.saveFH.createNewFile();
            this.voiceTargetType = AudioFileFormat.Type.WAVE;
            this.voiceInputStream = new AudioInputStream(this.voiceLine);
            this.mainThreadCapture = new SaveFileCaptureAudioThread();
            this.runningCapture = true;
            this.voiceLine.open(format);
            this.voiceLine.start();
            this.mainThreadCapture.start();
        }
        catch (LineUnavailableException e) {
            System.err.println("Line unavailable: " + e);
        }
        catch (IOException ee) {
            System.err.println("File IO : " + ee);
        }
    }

    public void updateCaptureSound() {
        try {
            int count;
            if (this.runningCapture && (count = this.voiceLine.read(this.voiceCaptureBuffer, 0, this.voiceCaptureBuffer.length)) > 0) {
                System.arraycopy(this.voiceCaptureBuffer, 0, this.voiceStoreBuffer, 0, count);
            }
        }
        catch (Exception e) {
            System.err.println("I/O problems: " + e);
        }
    }

    public void updateSaveFileCaptureSound() {
        try {
            if (this.runningCapture) {
                AudioSystem.write(this.voiceInputStream, this.voiceTargetType, this.saveFH);
            }
        }
        catch (Exception e) {
            System.err.println("I/O problems: " + e);
        }
    }

    public void stopCaptureSound() {
        try {
            if (this.runningCapture) {
                this.runningCapture = false;
                this.mainThreadCapture = null;
                if (this.voiceInputStream != null) {
                    this.voiceInputStream.close();
                }
                if (this.voiceLine != null) {
                    this.voiceLine.stop();
                    this.voiceLine.close();
                }
            }
        }
        catch (Exception e) {
            System.out.println("stopSoundMixer() : " + e);
        }
    }

    public float getSampleRateCaptureAudio() {
        return this.voiceSampleRate;
    }

    public void setSampleRateCaptureAudio(float newSampleRate) {
        this.voiceSampleRate = newSampleRate;
    }

    public int getSizeCaptureData(int scaleTime) {
        byte[] audio = this.voiceOutputStream.toByteArray();
        AudioFormat format = this.getFormat();
        int len = audio.length / format.getFrameSize();
        return len;
    }

    public int pickupCaptureAudioLevel() {
        int rawData = -1;
        if (this.runningCapture && ownProcMode == 0) {
            rawData = (this.voiceStoreBuffer[1] << 8) + this.voiceStoreBuffer[0];
            if (rawData < 0) {
                rawData *= -1;
            }
            System.arraycopy(this.voiceClearData, 0, this.voiceStoreBuffer, 0, this.voiceClearData.length);
        }
        return rawData;
    }

    private AudioFormat getFormat() {
        AudioFormat.Encoding encoding = AudioFormat.Encoding.PCM_SIGNED;
        float sampleRate = this.voiceSampleRate;
        int sampleSizeInBits = 16;
        int channels = 2;
        int frameSize = 4;
        float frameRate = this.voiceSampleRate;
        boolean bigEndian = false;
        return new AudioFormat(encoding, sampleRate, sampleSizeInBits, channels, frameSize, frameRate, bigEndian);
    }

    private AudioFormat adjustSampleRateWav(AudioFormat orgForm, float newSampleRate) {
        float sampleRate = newSampleRate;
        AudioFormat.Encoding encoding = orgForm.getEncoding();
        int sampleSizeInBits = orgForm.getSampleSizeInBits();
        int channels = orgForm.getChannels();
        int frameSize = orgForm.getFrameSize();
        float frameRate = orgForm.getFrameRate();
        boolean bigEndian = orgForm.isBigEndian();
        return new AudioFormat(encoding, sampleRate, sampleSizeInBits, channels, frameSize, frameRate, bigEndian);
    }

    public void startPlaySound(URI uriWavFileName, float competitiveRatioWav) {
        if (uriWavFileName != null) {
            try {
                if (this.runningPlayer) {
                    this.stopPlaySound();
                }
                File soundFile = new File(uriWavFileName);
                this.audioInputStreamWavPlayer = AudioSystem.getAudioInputStream(soundFile);
                AudioFormat audioFormat = this.audioInputStreamWavPlayer.getFormat();
                float samplerate = audioFormat.getSampleRate();
                audioFormat = this.adjustSampleRateWav(audioFormat, samplerate *= competitiveRatioWav);
                DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
                this.lineWavPlayer = (SourceDataLine)AudioSystem.getLine(info);
                this.lineWavPlayer.open(audioFormat);
                this.lineWavPlayer.start();
                this.mainThreadPlayer = new PlaySoundThread();
                this.runningPlayer = true;
                this.mainThreadPlayer.start();
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            }
            catch (IOException iOException) {
            }
            catch (LineUnavailableException lineUnavailableException) {}
        }
    }

    public void stopPlaySound() {
        try {
            if (this.runningPlayer) {
                this.runningPlayer = false;
                this.mainThreadPlayer = null;
                if (this.audioInputStreamWavPlayer != null) {
                    this.audioInputStreamWavPlayer.close();
                }
                if (this.lineWavPlayer != null) {
                    this.lineWavPlayer.drain();
                    this.lineWavPlayer.close();
                }
            }
        }
        catch (Exception e) {
            System.out.println("stopPlaySound() : " + e);
        }
    }

    public boolean isRunningPlaySound() {
        return this.runningPlayer;
    }

    public boolean isWavFormat(String fname) throws FileNotFoundException {
        boolean result = false;
        try {
            File fh = new File(fname);
            AudioFileFormat aff = AudioSystem.getAudioFileFormat(fh);
            if (AudioFileFormat.Type.WAVE == aff.getType()) {
                result = true;
            }
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
        }
        catch (IOException iOException) {}
        return result;
    }

    public String makeFormatWavInfo(String wfname) {
        String strWavInfo = "";
        String strSeparator = "\n\r";
        String strFileName = "WAV file name : ";
        String strFormatID = "Format ID : ";
        String strSampRate = "Sampling rate : ";
        String strSampBit = "Sampling bit : ";
        String strChNum = "Channel : ";
        String strFrameRate = "Frame rate : ";
        String strEndian = "Endian : ";
        strWavInfo = String.valueOf(strFileName) + wfname + strSeparator + strFormatID + this.currentWavFormatID + strSeparator + strSampRate + Integer.toString((int)this.currentWavSampRate) + " Hz" + strSeparator + strSampBit + Integer.toString(this.currentWavSampBit) + " bit" + strSeparator + strChNum + (this.currentWavCh == 2 ? "Stereo" : "Mono") + strSeparator + strFrameRate + Integer.toString((int)this.currentWavFrameRate) + " bytes/frame" + strSeparator + strEndian + (this.currentWavBigEndian ? "Big Endian" : "Littele Endian") + strSeparator;
        return strWavInfo;
    }

    public int getDurationTimeWav() {
        return this.currentWavDurationTime;
    }

    public void storeWavHeader(URI fname) throws Exception {
        File fh = new File(fname);
        AudioFileFormat aff = AudioSystem.getAudioFileFormat(fh);
        if (AudioFileFormat.Type.WAVE == aff.getType()) {
            AudioFormat af = aff.getFormat();
            this.currentWavFormatID = af.getEncoding().toString();
            this.currentWavCh = af.getChannels();
            this.currentWavFrameRate = af.getFrameRate();
            this.currentWavFrameSize = af.getFrameSize();
            this.currentWavSampRate = af.getSampleRate();
            this.currentWavSampBit = af.getSampleSizeInBits();
            this.currentWavBigEndian = af.isBigEndian();
            this.currentWavFormat = af.toString();
            this.currentWavBytePerSec = (int)(this.currentWavSampRate * (float)this.currentWavCh * (float)(this.currentWavSampBit / 8));
            this.currentWavDataLength = aff.getFrameLength() * this.currentWavFrameSize;
            this.currentWavDurationTime = (int)((float)this.currentWavDataLength / (float)this.currentWavBytePerSec * 1000.0f);
        }
    }

    class CaptureVoiceThread
    extends Thread {
        CaptureVoiceThread() {
        }

        @Override
        public void run() {
            while (SoundMixer.this.runningCapture) {
                SoundMixer.this.updateCaptureSound();
                Thread.yield();
            }
        }
    }

    class PlaySoundThread
    extends Thread {
        PlaySoundThread() {
        }

        @Override
        public void run() {
            try {
                int size = 0;
                float frameRate = SoundMixer.this.audioInputStreamWavPlayer.getFormat().getFrameRate();
                int frameSize = SoundMixer.this.audioInputStreamWavPlayer.getFormat().getFrameSize();
                byte[] inStream = new byte[(int)(frameRate * (float)frameSize)];
                while (SoundMixer.this.runningPlayer) {
                    size = SoundMixer.this.audioInputStreamWavPlayer.read(inStream, 0, inStream.length);
                    if (size < 0) {
                        SoundMixer.this.stopPlaySound();
                        break;
                    }
                    SoundMixer.this.lineWavPlayer.write(inStream, 0, size);
                    Thread.yield();
                }
            }
            catch (IOException iOException) {
                SoundMixer.this.stopPlaySound();
            }
        }
    }

    class SaveFileCaptureAudioThread
    extends Thread {
        SaveFileCaptureAudioThread() {
        }

        @Override
        public void run() {
            while (SoundMixer.this.runningCapture) {
                SoundMixer.this.updateSaveFileCaptureSound();
                Thread.yield();
            }
        }
    }
}

