/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.internal.ui.scripteditor;

import org.eclipse.actf.ai.internal.ui.scripteditor.event.EventManager;
import org.eclipse.actf.ai.internal.ui.scripteditor.event.MouseDragEvent;
import org.eclipse.actf.ai.internal.ui.scripteditor.event.SyncTimeEvent;
import org.eclipse.actf.ai.internal.ui.scripteditor.event.SyncTimeEventListener;
import org.eclipse.actf.ai.scripteditor.util.WebBrowserFactory;
import org.eclipse.actf.ai.ui.scripteditor.views.IUNIT;
import org.eclipse.actf.ai.ui.scripteditor.views.TimeLineView;
import org.eclipse.actf.examples.scripteditor.Activator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class TimeLineCanvas
extends Canvas
implements IUNIT,
SyncTimeEventListener {
    private static TimeLineCanvas ownInst = null;
    private TimeLineView instParentView;
    private int currentProcStatus = 0;
    private Image offImage = null;
    private int currentTime = 0;
    private int maxTime = 0;
    private int currentTimeLineLocation = 0;
    private static final Image imgMarkerTimeLine = Activator.getImageDescriptor("/icons/marker.gif").createImage();
    private Image imgMarkerAlpha = null;
    private int markerWidth = 0;
    private boolean statusMouseDragged = false;
    private long timePushMouseLButton = 0L;
    private boolean currentDragStatus = false;
    private static EventManager eventManager = null;

    public TimeLineCanvas(Composite parent) {
        super(parent, 0);
        ownInst = this;
        this.initializeCanvas(parent);
        this.instParentView = TimeLineView.getInstance();
        eventManager = EventManager.getInstance();
        eventManager.addSyncTimeEventListener(this);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                eventManager.removeSyncTimeEventListener(ownInst);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TimeLineCanvas getInstance(Composite parent) {
        if (ownInst != null) return ownInst;
        Class<TimeLineCanvas> clazz = TimeLineCanvas.class;
        synchronized (TimeLineCanvas.class) {
            if (ownInst != null) return ownInst;
            ownInst = new TimeLineCanvas(parent);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ownInst;
        }
    }

    public static TimeLineCanvas getInstance() {
        return ownInst;
    }

    private void initializeCanvas(Composite parent) {
        try {
            this.currentProcStatus = 0;
            Image temp = Activator.getImageDescriptor("/icons/marker.bmp").createImage();
            ImageData imgData = temp.getImageData();
            imgData.alpha = 70;
            this.imgMarkerAlpha = new Image((Device)this.getDisplay(), imgData);
            Rectangle rect = imgMarkerTimeLine.getBounds();
            this.markerWidth = rect.width - 1;
            this.addPaintListener(new CanvasPaintListener());
            this.addMouseListener((MouseListener)new TimeLineMouseDragAdapter());
            this.addMouseTrackListener((MouseTrackListener)new TimeLineMouseTrackAdapter());
            this.addMouseMoveListener(new TimeLineMouseMoveListener());
            this.displayTimeLineToolTip(0);
        }
        catch (Exception ef) {
            System.out.println("initializeCanvas() : Exception = " + ef);
        }
    }

    public void synchronizeTimeLine(int nowTime) {
        this.updatePositionMarkerTimeLine(nowTime);
    }

    public void refreshTimeLine(int nowCnt) {
        this.currentTimeLineLocation = nowCnt;
        this.setStatusCanvasTimeLine(1);
        this.redraw();
    }

    private void displayTimeLineToolTip(int nowPosition) {
        int nowTime = nowPosition * 20 + this.currentTimeLineLocation * 300000;
        if (nowTime < 0) {
            nowTime = 0;
        }
        String strToolTip = "TimeLine : " + this.makeFormatMMSSMS(nowTime) + " ";
        ownInst.setToolTipText(strToolTip);
    }

    private String makeFormatMMSSMS(int totalSec) {
        String formTime = new String();
        if (totalSec <= 0) {
            formTime = "00:00.00";
        } else {
            Integer mm = totalSec / 1000 / 60;
            Integer ss = totalSec / 1000 % 60;
            Integer ms = totalSec % 1000;
            formTime = "";
            if (mm < 10) {
                formTime = String.valueOf(formTime) + "0";
            }
            formTime = String.valueOf(formTime) + mm.toString();
            formTime = String.valueOf(formTime) + ":";
            if (ss < 10) {
                formTime = String.valueOf(formTime) + "0";
            }
            formTime = String.valueOf(formTime) + ss.toString();
            formTime = String.valueOf(formTime) + ".";
            Integer ms100 = ms / 10;
            formTime = ms < 10 ? String.valueOf(formTime) + "00" : (ms < 100 && ms >= 10 ? String.valueOf(formTime) + "0" + ms.toString() : String.valueOf(formTime) + ms100.toString());
        }
        return formTime;
    }

    private void updatePositionMarkerTimeLine(int currentTime) {
        this.currentTime = currentTime - this.currentTimeLineLocation * 300000;
        if (this.currentTime < 0) {
            this.currentTime = 0;
        }
        this.redraw();
    }

    public int getCurrentPositionMarkerTimeLine() {
        return this.currentTime + this.currentTimeLineLocation * 300000;
    }

    public void initPositionMarkerTimeLine() {
        this.currentTime = 0;
        this.setStatusCanvasTimeLine(1);
        this.redraw();
    }

    public void adjustMaxSizeTimeLine(int maxTime) {
        this.maxTime = maxTime;
        this.setStatusCanvasTimeLine(3);
        this.redraw();
    }

    public void setStatusCanvasTimeLine(int nextStatus) {
        this.currentProcStatus = nextStatus;
    }

    private void drawMarkerTimeLine(PaintEvent e) {
        int newX = this.currentTime / 20;
        e.gc.drawImage(this.imgMarkerAlpha, newX - (this.markerWidth >> 1), 1);
        e.gc.drawImage(imgMarkerTimeLine, newX - (this.markerWidth >> 1), 1);
    }

    private void initCanvasTimeLine(PaintEvent e) {
        Point nowCanvas = this.instParentView.getSizeParentSC();
        int startTimeLine = this.currentTimeLineLocation * 300000;
        if (startTimeLine < 0) {
            startTimeLine = 0;
        }
        Point newCanvas = new Point(30000, nowCanvas.y);
        if (this.offImage != null) {
            this.offImage.dispose();
            this.offImage = null;
        }
        this.offImage = new Image((Device)this.getDisplay(), newCanvas.x, newCanvas.y);
        GC wgc = new GC((Drawable)this.offImage);
        wgc.setBackground(this.getDisplay().getSystemColor(1));
        wgc.setForeground(this.getDisplay().getSystemColor(2));
        wgc.drawRectangle(0, 0, newCanvas.x, newCanvas.y);
        int nextTimeCount = 0;
        int timeWidth = 18;
        wgc.drawString(this.makeFormatMMSSMS(startTimeLine), -timeWidth, 5);
        int i = 0;
        while (i <= newCanvas.x) {
            int j = 0;
            while (j < 50) {
                wgc.drawLine(i + j, 0, i + j, 2);
                j += 5;
            }
            wgc.drawLine(i + 50, 0, i + 50, 5);
            if (++nextTimeCount % 2 == 0) {
                int nowTime = startTimeLine + nextTimeCount * 1000;
                wgc.drawString(this.makeFormatMMSSMS(nowTime), i + 50 - timeWidth, 5);
            }
            i += 50;
        }
        e.gc.drawImage(this.offImage, e.x, e.y, e.width, e.height, e.x, e.y, e.width, e.height);
        wgc.dispose();
        this.drawMarkerTimeLine(e);
    }

    private void adjustSizeCanvasTimeLine(PaintEvent e) {
        int startTimeLine = this.instParentView.getStartTimeLine();
        int endTimeLine = this.instParentView.getMaxTimeLine();
        if (this.maxTime > endTimeLine) {
            endTimeLine = this.maxTime;
        }
        Canvas src = (Canvas)e.getSource();
        Point nowCanvas = new Point(endTimeLine / 20, src.getSize().y);
        if (e.width > nowCanvas.x) {
            nowCanvas = null;
            nowCanvas = src.getSize();
        }
        if (this.offImage != null) {
            this.offImage.dispose();
        }
        this.offImage = new Image((Device)this.getDisplay(), nowCanvas.x, nowCanvas.y);
        GC wgc = new GC((Drawable)this.offImage);
        wgc.setBackground(this.getDisplay().getSystemColor(1));
        wgc.setForeground(this.getDisplay().getSystemColor(2));
        wgc.drawRectangle(0, 0, nowCanvas.x, nowCanvas.y);
        int nextTimeCount = 0;
        int timeWidth = 18;
        wgc.drawString(this.makeFormatMMSSMS(startTimeLine), -timeWidth, 5);
        int i = 0;
        while (i <= nowCanvas.x) {
            int j = 0;
            while (j < 50) {
                wgc.drawLine(i + j, 0, i + j, 2);
                j += 5;
            }
            wgc.drawLine(i + 50, 0, i + 50, 5);
            if (++nextTimeCount % 2 == 0) {
                int nowTime = (i + 50) * 20;
                wgc.drawString(this.makeFormatMMSSMS(nowTime), i + 50 - timeWidth, 5);
            }
            i += 50;
        }
        e.gc.drawImage(this.offImage, e.x, e.y, e.width, e.height, e.x, e.y, e.width, e.height);
        wgc.dispose();
        this.drawMarkerTimeLine(e);
    }

    private void redrawCanvasTimeLine(PaintEvent e) {
        if (this.offImage != null) {
            e.gc.drawImage(this.offImage, e.x, e.y, e.width, e.height, e.x, e.y, e.width, e.height);
            this.drawMarkerTimeLine(e);
        }
    }

    private void precheckMouseDraggedEvent(MouseEvent e) {
        this.timePushMouseLButton = e.time;
        this.currentDragStatus = true;
    }

    private void moveMouseDraggedEvent(MouseEvent e) {
        int nowTime = e.x * 20 + this.currentTimeLineLocation * 300000;
        int maxTime = this.instParentView.getMaxTimeLine();
        if (nowTime < 0) {
            nowTime = 0;
        } else if (nowTime > maxTime) {
            nowTime = this.instParentView.getMaxTimeLine();
        }
        this.instParentView.reqSetTrackCurrentTimeLine(nowTime);
        eventManager.fireSyncTimeEvent(new SyncTimeEvent(nowTime, this));
        WebBrowserFactory.getInstance().setCurrentPosition(nowTime);
    }

    @Override
    public void handleSyncTimeEvent(SyncTimeEvent e) {
        if (e.getEventType() == 0) {
            this.synchronizeTimeLine(e.getCurrentTime());
        } else if (e.getEventType() == 1) {
            this.refreshTimeLine(e.getCurrentTime());
        }
    }

    class CanvasPaintListener
    implements PaintListener {
        CanvasPaintListener() {
        }

        public void paintControl(PaintEvent e) {
            if (TimeLineCanvas.this.offImage == null) {
                TimeLineCanvas.this.currentProcStatus = 1;
            }
            if (TimeLineCanvas.this.currentProcStatus == 1) {
                TimeLineCanvas.this.initCanvasTimeLine(e);
                TimeLineCanvas.this.currentProcStatus = 2;
            } else if (TimeLineCanvas.this.currentProcStatus == 2) {
                TimeLineCanvas.this.redrawCanvasTimeLine(e);
            } else if (TimeLineCanvas.this.currentProcStatus == 3) {
                TimeLineCanvas.this.adjustSizeCanvasTimeLine(e);
                TimeLineCanvas.this.currentProcStatus = 2;
            }
            e.gc.dispose();
        }
    }

    class TimeLineMouseDragAdapter
    extends MouseAdapter {
        TimeLineMouseDragAdapter() {
        }

        public void mouseDown(MouseEvent e) {
            if (!TimeLineCanvas.this.statusMouseDragged && e.button == 1) {
                TimeLineCanvas.this.precheckMouseDraggedEvent(e);
                eventManager.fireMouseDragEvent(new MouseDragEvent(0, (Object)this));
            }
        }

        public void mouseUp(MouseEvent e) {
            if (!TimeLineCanvas.this.statusMouseDragged && e.button == 1 && TimeLineCanvas.this.currentDragStatus) {
                long timeReleaseMouseLButton = e.time;
                if (timeReleaseMouseLButton - TimeLineCanvas.this.timePushMouseLButton < 500L) {
                    TimeLineCanvas.this.moveMouseDraggedEvent(e);
                }
                TimeLineCanvas.this.currentDragStatus = false;
                eventManager.fireMouseDragEvent(new MouseDragEvent(3, TimeLineCanvas.this.currentDragStatus, (Object)this));
            } else if (TimeLineCanvas.this.statusMouseDragged && e.button == 1) {
                TimeLineCanvas.this.statusMouseDragged = false;
                eventManager.fireMouseDragEvent(new MouseDragEvent(2, (Object)this));
            }
            WebBrowserFactory.getInstance().showCurrentImage();
        }
    }

    class TimeLineMouseMoveListener
    implements MouseMoveListener {
        TimeLineMouseMoveListener() {
        }

        public void mouseMove(MouseEvent e) {
            if (TimeLineCanvas.this.statusMouseDragged) {
                TimeLineCanvas.this.moveMouseDraggedEvent(e);
            } else if (!TimeLineCanvas.this.statusMouseDragged && TimeLineCanvas.this.currentDragStatus) {
                TimeLineCanvas.this.statusMouseDragged = true;
                TimeLineCanvas.this.currentDragStatus = false;
            }
            TimeLineCanvas.this.displayTimeLineToolTip(e.x);
        }
    }

    class TimeLineMouseTrackAdapter
    extends MouseTrackAdapter {
        TimeLineMouseTrackAdapter() {
        }

        public void mouseEnter(MouseEvent e) {
            Canvas parentCanvas = (Canvas)e.getSource();
            parentCanvas.setCursor(new Cursor(null, 21));
        }

        public void mouseExit(MouseEvent e) {
            Canvas parentCanvas = (Canvas)e.getSource();
            parentCanvas.setCursor(new Cursor(null, 0));
        }
    }
}

