/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.gui.msaa.checker;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.actf.accservice.swtbridge.AccessibleObject;
import org.eclipse.actf.model.flash.util.FlashMSAAUtil;
import org.eclipse.actf.visualization.gui.msaa.checker.MSAAProblem;
import org.eclipse.actf.visualization.gui.msaa.checker.MSAAProblemConst;
import org.eclipse.actf.visualization.gui.ui.views.MSAATreeContentProvider;

public class MSAAProblemChecker
implements MSAAProblemConst {
    private AccessibleObject rootObject;
    private static final MSAATreeContentProvider provider = new MSAATreeContentProvider();

    public MSAAProblemChecker(AccessibleObject accessibleObject) {
        this.rootObject = accessibleObject;
    }

    public MSAAProblem[] getProblems() {
        provider.setShowOffscreen(true);
        provider.setHideHtml(MSAATreeContentProvider.getDefault().isHideHtml());
        return this.getProblem(provider.getElements(this.rootObject), false);
    }

    public MSAAProblem[] getProblem(Object[] objectArray, boolean bl) {
        ArrayList<MSAAProblem> arrayList = new ArrayList<MSAAProblem>();
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                AccessibleObject accessibleObject = (AccessibleObject)objectArray[n];
                if (accessibleObject != null && ((accessibleObject.getAccState() & 0x8000) == 0 || (accessibleObject.getAccState() & 0x10000) != 0)) {
                    String string = accessibleObject.getAccName();
                    int n2 = accessibleObject.getAccRole();
                    switch (n2) {
                        case 9: {
                            if (!FlashMSAAUtil.isFlash((int)accessibleObject.getPtr())) break;
                            bl = true;
                            break;
                        }
                        case 1: 
                        case 4: 
                        case 21: 
                        case 22: 
                        case 23: 
                        case 29: 
                        case 33: 
                        case 35: 
                        case 41: 
                        case 42: 
                        case 60: 
                        case 1054: {
                            break;
                        }
                        case 10: {
                            if (!FlashMSAAUtil.isInvisibleFlash((int)accessibleObject.getPtr())) break;
                            arrayList.add(new MSAAProblem(1, 8, accessibleObject));
                            bl = true;
                            break;
                        }
                        default: {
                            String string2;
                            if (string != null && string.length() != 0) break;
                            if (n2 == 43) {
                                arrayList.add(new MSAAProblem(1, 0, accessibleObject));
                                break;
                            }
                            if (n2 == 40) {
                                if (bl) {
                                    arrayList.add(new MSAAProblem(1, 9, accessibleObject));
                                    break;
                                }
                                arrayList.add(new MSAAProblem(2, 1, accessibleObject));
                                break;
                            }
                            if (n2 == 46) {
                                arrayList.add(new MSAAProblem(1, 4, accessibleObject));
                                break;
                            }
                            if (n2 == 24) {
                                arrayList.add(new MSAAProblem(3, 5, accessibleObject));
                                break;
                            }
                            if (n2 == 30) {
                                string2 = accessibleObject.getAccValue();
                                if (string2 == null || string2.length() <= 0) break;
                                if (accessibleObject.getChildCount() == 0) {
                                    arrayList.add(new MSAAProblem(1, 6, accessibleObject));
                                    break;
                                }
                                AccessibleObject accessibleObject2 = accessibleObject.getChildren()[0];
                                if (accessibleObject2.getAccRole() != 40 || accessibleObject2.getAccName() != null && accessibleObject2.getAccName().length() != 0) break;
                                arrayList.add(new MSAAProblem(1, 6, accessibleObject));
                                break;
                            }
                            string2 = accessibleObject.getAccDefaultAction();
                            if (string2 == null || string2.length() == 0) {
                                if (n2 == 16) {
                                    arrayList.add(new MSAAProblem(2, 7, accessibleObject));
                                    break;
                                }
                                arrayList.add(new MSAAProblem(2, 3, accessibleObject));
                                break;
                            }
                            arrayList.add(new MSAAProblem(1, 2, accessibleObject));
                        }
                    }
                    arrayList.addAll(Arrays.asList(this.getProblem(provider.getChildren(accessibleObject), bl)));
                }
                ++n;
            }
        }
        return arrayList.toArray(new MSAAProblem[arrayList.size()]);
    }
}

