/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.dom.sgml.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.eclipse.actf.model.internal.dom.sgml.util.IMutableTreeNodeFactory;
import org.eclipse.actf.model.internal.dom.sgml.util.MutableTreeNodeFactoryImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutableTreeNodeImpl
implements MutableTreeNode {
    private Node domNode;
    private IMutableTreeNodeFactory factory;
    private static IMutableTreeNodeFactory sfactory;

    public Node getDomNode() {
        return this.domNode;
    }

    public static MutableTreeNodeImpl createNode(Node node) {
        if (sfactory == null) {
            sfactory = new MutableTreeNodeFactoryImpl();
        }
        return (MutableTreeNodeImpl)sfactory.createNode(node);
    }

    protected MutableTreeNodeImpl(Node node, IMutableTreeNodeFactory iMutableTreeNodeFactory) {
        this.domNode = node;
        this.factory = iMutableTreeNodeFactory;
    }

    public String toString() {
        return this.domNode.toString();
    }

    @Override
    public TreeNode getChildAt(int n) {
        Node node = this.domNode.getFirstChild();
        while (n > 0 && node != null) {
            node = node.getNextSibling();
            --n;
        }
        return node != null ? this.factory.createNode(node) : null;
    }

    @Override
    public int getChildCount() {
        int n = 0;
        Node node = this.domNode.getFirstChild();
        while (node != null) {
            ++n;
            node = node.getNextSibling();
        }
        return n;
    }

    @Override
    public TreeNode getParent() {
        Node node = this.domNode.getParentNode();
        return node == null ? null : this.factory.createNode(node);
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        Node node = ((MutableTreeNodeImpl)treeNode).domNode;
        int n = 0;
        Node node2 = this.domNode.getFirstChild();
        while (node2 != null) {
            if (node2 == node) {
                return n;
            }
            ++n;
            node2 = node2.getNextSibling();
        }
        return -1;
    }

    @Override
    public boolean getAllowsChildren() {
        return this.domNode instanceof Element || this.domNode instanceof Document;
    }

    @Override
    public boolean isLeaf() {
        return !(this.domNode instanceof Element) && !this.domNode.hasChildNodes() && !(this.domNode instanceof Document);
    }

    public Enumeration<MutableTreeNode> children() {
        return new Enumeration<MutableTreeNode>(){
            private Node nextChild;
            {
                this.nextChild = MutableTreeNodeImpl.this.domNode.getFirstChild();
            }

            @Override
            public boolean hasMoreElements() {
                return this.nextChild != null;
            }

            @Override
            public MutableTreeNode nextElement() {
                if (this.nextChild == null) {
                    throw new NoSuchElementException();
                }
                MutableTreeNode mutableTreeNode = MutableTreeNodeImpl.this.factory.createNode(this.nextChild);
                this.nextChild = this.nextChild.getNextSibling();
                return mutableTreeNode;
            }
        };
    }

    @Override
    public void insert(MutableTreeNode mutableTreeNode, int n) {
        Node node = this.domNode.getFirstChild();
        while (node != null && n > 0) {
            node = node.getNextSibling();
            --n;
        }
        this.domNode.insertBefore(((MutableTreeNodeImpl)mutableTreeNode).domNode, node);
    }

    @Override
    public void remove(int n) {
        Node node = this.domNode.getFirstChild();
        while (n > 0 && node != null) {
            node = node.getNextSibling();
            --n;
        }
        if (node != null) {
            this.domNode.removeChild(node);
        }
    }

    @Override
    public void remove(MutableTreeNode mutableTreeNode) {
        this.domNode.removeChild(((MutableTreeNodeImpl)mutableTreeNode).domNode);
    }

    @Override
    public void setUserObject(Object object) {
        if (object instanceof Node) {
            this.domNode = (Node)object;
        }
    }

    @Override
    public void removeFromParent() {
        this.domNode.getParentNode().removeChild(this.domNode);
    }

    @Override
    public void setParent(MutableTreeNode mutableTreeNode) {
    }
}

