/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.model;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.tea.library.build.model.BundleData;
import org.eclipse.tea.library.build.model.ManifestHolder;
import org.eclipse.tea.library.build.model.ParameterValue;
import org.eclipse.tea.library.build.model.WorkspaceData;
import org.eclipse.tea.library.build.util.StringHelper;
import org.osgi.framework.Version;

public class PluginData
extends BundleData {
    protected final IProject project;
    protected final ParameterValue[] dependencies;
    protected final ParameterValue[] mavenDependencies;
    protected final ParameterValue[] imports;
    protected ParameterValue[] exports;
    protected final String platformFilter;
    protected String[] classPath;
    protected final String[] requiredExecutionEnvironment;
    protected final ParameterValue fragmentHost;
    protected final Properties buildProperties;
    protected final Map<String, List<String>> sourceFolders;
    protected final Map<String, List<String>> binaryFolders;
    protected final String[] binaryIncludes;
    protected final String description;

    public PluginData(IProject project) {
        this(project.getName(), project.getLocation().toFile(), true, null, project);
    }

    public static PluginData createFromBinaryDistribution(File binaryDistribution) {
        if (binaryDistribution.isFile()) {
            String jarName = binaryDistribution.getName().toLowerCase();
            if (jarName.endsWith(".jar")) {
                return new PluginData(null, null, false, binaryDistribution, null);
            }
            throw new IllegalArgumentException("illegal JAR name: " + jarName);
        }
        if (binaryDistribution.isDirectory()) {
            return new PluginData(null, binaryDistribution, false, null, null);
        }
        throw new IllegalArgumentException(binaryDistribution.getPath());
    }

    protected PluginData(String projectName, File bundleDir, boolean hasSource, File jarFile, IProject project) {
        super(projectName, bundleDir, hasSource, jarFile);
        String[] binInc2;
        String[] binInc1;
        this.project = project;
        this.buildProperties = jarFile != null ? PluginData.readBuildPropertiesFromJar(jarFile) : PluginData.readBuildPropertiesFromDirectory(bundleDir);
        if (this.manifest != null) {
            this.dependencies = this.manifest.getDependencies();
            this.mavenDependencies = this.manifest.getMavenDependencies();
            this.imports = this.manifest.getImportPackages();
            this.exports = this.manifest.getExportPackages();
            this.classPath = this.manifest.getClassPath();
            this.requiredExecutionEnvironment = this.manifest.getRequiredExecutionEnvironment();
            this.fragmentHost = this.manifest.getFragmentHost();
            this.platformFilter = this.manifest.getPlatformFilter();
            this.description = this.manifest.getDescription();
            binInc1 = this.manifest.getBinaryInclude();
        } else {
            this.dependencies = null;
            this.mavenDependencies = null;
            this.imports = null;
            this.exports = null;
            this.classPath = null;
            this.requiredExecutionEnvironment = null;
            this.fragmentHost = null;
            this.platformFilter = null;
            this.description = null;
            binInc1 = EMPTY_STRINGS;
        }
        if (this.buildProperties != null) {
            this.sourceFolders = PluginData.splitMap(this.buildProperties, "source.");
            this.binaryFolders = PluginData.splitMap(this.buildProperties, "output.");
            binInc2 = PluginData.splitList(this.buildProperties, "bin.includes");
        } else {
            this.sourceFolders = Collections.emptyMap();
            this.binaryFolders = Collections.emptyMap();
            binInc2 = EMPTY_STRINGS;
        }
        this.binaryIncludes = PluginData.mergeLists(binInc1, binInc2);
    }

    @Override
    public final IProject getProject() {
        return this.project;
    }

    public boolean isBinary() {
        return WorkspaceData.isBinaryProject(this.project);
    }

    public final ParameterValue[] getDependencies() {
        return this.dependencies;
    }

    public final ParameterValue[] getMavenDependencies() {
        return this.mavenDependencies;
    }

    public final ParameterValue[] getPackageImports() {
        if (this.imports == null) {
            return new ParameterValue[0];
        }
        return this.imports;
    }

    public final ParameterValue[] getPackageExports() {
        if (this.exports == null) {
            return new ParameterValue[0];
        }
        return this.exports;
    }

    public final void setPackageExports(ParameterValue[] v) {
        this.exports = v;
        this.manifest.setExportPackages(v);
    }

    public final String[] getClassPath() {
        return this.classPath;
    }

    public final void setClassPath(String[] cp) {
        this.manifest.setClassPath(cp);
    }

    public final String[] getRequiredExecutionEnvironment() {
        return this.requiredExecutionEnvironment;
    }

    public final void setRequiredExecutionEnvironment(String[] values) {
        this.manifest.setRequiredExecutionEnvironment(values);
    }

    public final void setAutomaticModuleName(String value) {
        this.manifest.setAutomaticModuleName(value);
    }

    public final String getAutomaticModuleName() {
        return this.manifest.getAutomaticModuleName();
    }

    @Override
    public final String getBundleVersion() {
        if (this.manifest == null) {
            return null;
        }
        return this.manifest.getBundleVersion();
    }

    @Override
    public final void setBundleVersion(String value) {
        this.manifest.setBundleVersion(value);
    }

    public final String getBundleVendor() {
        return this.manifest.getBundleVendor();
    }

    public final void setBundleVendor(String value) {
        this.manifest.setBundleVendor(value);
    }

    public final String getBuddyPolicy() {
        ParameterValue buddyPolicy = this.manifest.getBuddyPolicy();
        return buddyPolicy == null ? null : buddyPolicy.getValue();
    }

    public final ParameterValue[] getBuddyRegistrations() {
        return this.manifest.getBuddyRegistrations();
    }

    public final boolean isLazyActivationPolicy() {
        return StringHelper.compare("lazy", this.manifest.getActivationPolicy()) == 0;
    }

    public final void setLazyActivationPolicy() {
        this.manifest.setLazyActivationPolicy();
    }

    public final ParameterValue getFragmentHost() {
        return this.fragmentHost;
    }

    public final String[] getSourceFolders() {
        return (String[])this.sourceFolders.values().stream().flatMap(Collection::stream).toArray(String[]::new);
    }

    public final Map<String, List<String>> getBinaryFolders() {
        return this.binaryFolders;
    }

    public final String[] getBinaryIncludes() {
        return this.binaryIncludes;
    }

    public final String getPlatformFilter() {
        return this.platformFilter;
    }

    public String getBundleActivator() {
        if (this.manifest == null) {
            return null;
        }
        return this.manifest.getActivator();
    }

    public void setBundleActivator(String activator) {
        this.manifest.setActivator(activator);
    }

    public List<String> getBinaryClassPath() {
        if (this.jarFile != null) {
            return Collections.singletonList(this.jarFile.getAbsolutePath());
        }
        ArrayList<String> result = new ArrayList<String>();
        String[] stringArray = this.classPath;
        int n = this.classPath.length;
        int n2 = 0;
        while (n2 < n) {
            String cp = stringArray[n2];
            if (!".".equals(cp)) {
                File f = new File(this.bundleDir, cp);
                result.add(f.getAbsolutePath());
            }
            ++n2;
        }
        return result;
    }

    void writeHtmlListelement(Writer w) throws IOException {
        ParameterValue dep;
        int n;
        int n2;
        ParameterValue[] parameterValueArray;
        w.write("<li>");
        w.write(this.getBundleName());
        if (this.dependencies != null) {
            w.write("<br>Dependencies:\n<ul>\n");
            parameterValueArray = this.dependencies;
            n2 = this.dependencies.length;
            n = 0;
            while (n < n2) {
                dep = parameterValueArray[n];
                dep.writeHtmlListelement(w);
                ++n;
            }
            w.write("</ul>\n");
        }
        if (this.mavenDependencies != null) {
            w.write("<br>Maven JAR Dependencies:\n<ul>\n");
            parameterValueArray = this.mavenDependencies;
            n2 = this.mavenDependencies.length;
            n = 0;
            while (n < n2) {
                dep = parameterValueArray[n];
                dep.writeHtmlListelement(w);
                ++n;
            }
            w.write("</ul>\n");
        }
        w.write("</li>\n");
    }

    public boolean exportsPackage(String id, VersionRange range) {
        if (this.exports == null) {
            return false;
        }
        ParameterValue[] parameterValueArray = this.exports;
        int n = this.exports.length;
        int n2 = 0;
        while (n2 < n) {
            ParameterValue val = parameterValueArray[n2];
            if (val.getValue().equals(id)) {
                String exportVersion = val.getStringParameter("version");
                Version v = exportVersion != null && !exportVersion.isEmpty() ? Version.parseVersion((String)exportVersion) : Version.emptyVersion;
                if (range == null || range.isIncluded(v)) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    public final ParameterValue[] getImportPackages() {
        return this.imports;
    }

    public final String getDescription() {
        return this.description;
    }

    public boolean migrateUnpackInformation() {
        return this.manifest.migrateUnpackInformation();
    }

    private Map<String, String> getExternalizeClasspath() {
        TreeMap<String, String> result = new TreeMap<String, String>();
        ParameterValue[] parameterValueArray = this.getManifestHeaderList("Externalize-ClassPath");
        int n = parameterValueArray.length;
        int n2 = 0;
        while (n2 < n) {
            ParameterValue v = parameterValueArray[n2];
            String from = v.getValue();
            String to = v.getStringParameter("map");
            result.put(from, to);
            ++n2;
        }
        return result;
    }

    @Deprecated
    private Map<String, String> getWamasExternalizeClasspath() {
        TreeMap<String, String> result = new TreeMap<String, String>();
        ParameterValue[] parameterValueArray = this.getManifestHeaderList("WAMAS-Externalize-ClassPath");
        int n = parameterValueArray.length;
        int n2 = 0;
        while (n2 < n) {
            ParameterValue v = parameterValueArray[n2];
            String from = v.getValue();
            String to = v.getStringParameter("map");
            result.put(from, to);
            ++n2;
        }
        return result;
    }

    @Deprecated
    String getWamasPrefixNativeCode() {
        return this.getSimpleManifestValue("WAMAS-Prefix-NativeCode");
    }

    String getPrefixNativeCode() {
        return this.getSimpleManifestValue("Prefix-NativeCode");
    }

    @Override
    public boolean isJarBundleShape() {
        String x = this.getSimpleManifestValue("Eclipse-BundleShape");
        return !"dir".equals(x);
    }

    public void updateManifestForBinaryDeployment() {
        String prefix;
        if (this.getManifestFile() == null || this.manifest == null) {
            return;
        }
        long timeStamp = this.getManifestFile().lastModified();
        ManifestHolder temp = PluginData.readManifestFromDirectory(this.bundleDir);
        Map<String, String> updates = this.getExternalizeClasspath();
        updates.putAll(this.getWamasExternalizeClasspath());
        if (temp == null) {
            return;
        }
        String[] cp = this.manifest.getClassPath();
        if (!updates.isEmpty() && cp.length > 0) {
            String[] target = new String[cp.length];
            System.arraycopy(cp, 0, target, 0, cp.length);
            int i = 0;
            while (i < cp.length) {
                String replacement = updates.get(cp[i]);
                if (replacement != null) {
                    target[i] = replacement;
                }
                ++i;
            }
            temp.setClassPath(target);
        }
        if ((prefix = this.getWamasPrefixNativeCode()) == null) {
            prefix = this.getPrefixNativeCode();
        }
        ParameterValue[] nc = temp.getNativeCode();
        if (prefix != null && nc.length > 0) {
            int i = 0;
            while (i < nc.length) {
                nc[i].setValue(prefix + nc[i].getValue());
                ++i;
            }
        }
        try {
            temp.write(this.getManifestFile());
            this.getManifestFile().setLastModified(timeStamp);
        }
        catch (Exception e) {
            throw new RuntimeException("cannot update manifest for binary deployment", e);
        }
    }
}

