/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.core.ui.internal.listeners;

import javax.inject.Named;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.tea.core.annotations.lifecycle.BeginTask;
import org.eclipse.tea.core.annotations.lifecycle.BeginTaskChain;
import org.eclipse.tea.core.annotations.lifecycle.CreateContext;
import org.eclipse.tea.core.annotations.lifecycle.DisposeContext;
import org.eclipse.tea.core.annotations.lifecycle.FinishTask;
import org.eclipse.tea.core.annotations.lifecycle.FinishTaskChain;
import org.eclipse.tea.core.services.TaskingLifeCycleListener;
import org.osgi.service.component.annotations.Component;

@Component
public class EventBrokerBridge
implements TaskingLifeCycleListener {
    public static final String EVENT_TOPIC_BASE = "org/eclipse/tea/";
    public static final String EVENT_CTX_CREATE = "org/eclipse/tea/CreateContext";
    public static final String EVENT_CTX_DISPOSE = "org/eclipse/tea/DisposeContext";
    public static final String EVENT_CHAIN_BEGIN = "org/eclipse/tea/BeginTaskChain";
    public static final String EVENT_CHAIN_FINISH = "org/eclipse/tea/FinishTaskChain";
    public static final String EVENT_TASK_BEGIN = "org/eclipse/tea/BeginTask";
    public static final String EVENT_TASK_FINISH = "org/eclipse/tea/FinishTask";

    @CreateContext
    public void ctxCreate(@Optional @Named(value="E4Context") IEclipseContext ctx, IEclipseContext context) {
        this.broadcast(ctx, EVENT_CTX_CREATE, context);
    }

    @DisposeContext
    public void ctxDispose(@Optional @Named(value="E4Context") IEclipseContext ctx, IEclipseContext context) {
        this.broadcast(ctx, EVENT_CTX_DISPOSE, context);
    }

    @BeginTaskChain
    public void chainBegin(@Optional @Named(value="E4Context") IEclipseContext ctx, IEclipseContext context) {
        this.broadcast(ctx, EVENT_CHAIN_BEGIN, context);
    }

    @FinishTaskChain
    public void chainFinish(@Optional @Named(value="E4Context") IEclipseContext ctx, IEclipseContext context) {
        this.broadcast(ctx, EVENT_CHAIN_FINISH, context);
    }

    @BeginTask
    public void taskBegin(@Optional @Named(value="E4Context") IEclipseContext ctx, IEclipseContext context) {
        this.broadcast(ctx, EVENT_TASK_BEGIN, context);
    }

    @FinishTask
    public void taskFinish(@Optional @Named(value="E4Context") IEclipseContext ctx, IEclipseContext context) {
        this.broadcast(ctx, EVENT_TASK_FINISH, context);
    }

    private void broadcast(IEclipseContext e4ctx, String event, Object data) {
        IEventBroker eventBroker = (IEventBroker)e4ctx.get(IEventBroker.class);
        if (eventBroker != null) {
            eventBroker.send(event, data);
        }
    }
}

