/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.ease.internal;

import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.ease.ui.scripts.repository.IRepositoryService;
import org.eclipse.ease.ui.scripts.repository.IScript;
import org.eclipse.tea.core.TaskExecutionContext;
import org.eclipse.tea.core.annotations.TaskChainContextInit;
import org.eclipse.tea.core.annotations.TaskChainMenuEntry;
import org.eclipse.tea.core.services.TaskChain;
import org.eclipse.tea.core.services.TaskingLog;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.component.annotations.Component;

@TaskChain.TaskChainId(description="List available EASE Scripts")
@TaskChainMenuEntry(path={"Development"}, development=true, icon="platform:/plugin/org.eclipse.ease.ui/icons/eobj16/script.png", groupingId="tea.core.dev.lists")
@Component
public class ListEaseScripts
implements TaskChain {
    @TaskChainContextInit
    public void init(TaskExecutionContext c) {
        c.addTask(ListScripts.class);
    }

    public static final class ListScripts {
        @Execute
        public void list(TaskingLog log) throws Exception {
            IRepositoryService repo = (IRepositoryService)PlatformUI.getWorkbench().getService(IRepositoryService.class);
            log.info("Waiting for script locations to load");
            repo.update(true);
            while (repo.getScripts().isEmpty()) {
                Thread.sleep(100L);
            }
            Thread.sleep(500L);
            log.info("...loaded");
            for (IScript script : repo.getScripts()) {
                log.info(script.getPath().toString());
            }
        }
    }
}

