/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.core.internal;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.extensions.Service;
import org.eclipse.tea.core.internal.TaskingConfigurationStore;
import org.eclipse.tea.core.services.TaskingConfigurationExtension;
import org.eclipse.tea.core.services.TaskingLog;

public class TaskingConfigurationInitializer {
    @Execute
    protected void initConfiguration(IEclipseContext context, TaskingConfigurationStore store, @Service List<TaskingConfigurationExtension> configurations) throws Exception {
        ArrayList<String> warnings = new ArrayList<String>();
        TreeMap<String, TaskingConfigurationExtension.TaskingConfig> keys = new TreeMap<String, TaskingConfigurationExtension.TaskingConfig>();
        for (TaskingConfigurationExtension config : configurations) {
            config = (TaskingConfigurationExtension)config.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            context.set(config.getClass().getName(), (Object)config);
            TaskingConfigurationExtension.TaskingConfig cfg = config.getClass().getAnnotation(TaskingConfigurationExtension.TaskingConfig.class);
            if (cfg == null) {
                warnings.add("Configuration without @TeaConfig annotation: " + config);
            }
            Field[] fieldArray = config.getClass().getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (field.getAnnotation(TaskingConfigurationExtension.TaskingConfigProperty.class) != null) {
                    String key = TaskingConfigurationStore.getPropertyName(field);
                    TaskingConfigurationExtension.TaskingConfig old = keys.put(key, cfg);
                    if (old != null) {
                        warnings.add("duplicate configuration key '" + key + "' defined in " + old.description() + " and in " + cfg.description());
                    }
                    try {
                        store.loadValue(field, config);
                    }
                    catch (Exception e) {
                        warnings.add("cannot load configuration value for " + field + " in " + config);
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
        }
        TaskingLog log = (TaskingLog)context.get(TaskingLog.class);
        for (String w : warnings) {
            log.warn(w);
        }
    }
}

