/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.core.ui;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.tea.core.internal.model.TaskingModel;
import org.eclipse.tea.core.internal.model.iface.TaskingElement;
import org.eclipse.tea.core.ui.internal.TaskingModelContentProvider;
import org.eclipse.tea.core.ui.internal.TaskingModelLabelProvider;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class TaskingModelTreePanel
extends Composite {
    private FilteredTree tree;

    public TaskingModelTreePanel(Composite parent, TaskingModel model) {
        super(parent, 0);
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo((Composite)this);
        this.tree = new FilteredTree((Composite)this, 2816, new PatternFilter(){

            protected boolean isLeafMatch(Viewer viewer, Object element) {
                String labelText = ((TaskingElement)element).getLabel();
                if (labelText == null) {
                    return false;
                }
                return this.wordMatches(labelText);
            }
        }, true);
        this.tree.getViewer().setContentProvider((IContentProvider)new TaskingModelContentProvider());
        this.tree.getViewer().setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new TaskingModelLabelProvider()));
        this.tree.getViewer().setInput((Object)model);
        this.tree.getViewer().setExpandedState((Object)model.getRootGroup(), true);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.tree);
    }

    public void addSelectionListener(ISelectionChangedListener listener) {
        this.tree.getViewer().addSelectionChangedListener(listener);
    }

    public TaskingElement getSelection() {
        Object o = this.tree.getViewer().getStructuredSelection().getFirstElement();
        if (o instanceof TaskingElement) {
            return (TaskingElement)o;
        }
        return null;
    }
}

