/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.core.internal.tasks;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.extensions.Service;
import org.eclipse.tea.core.services.TaskChain;
import org.eclipse.tea.core.services.TaskingLog;

public class BuiltinTaskListChains {
    @Execute
    public void listChains(@Service List<TaskChain> allChains, TaskingLog log) {
        log.info(String.format("%1$40s | %2$s", "Task Chain Name", "Known Aliases"));
        log.info("-----------------------------------------|----------------------------------------------------------");
        for (TaskChain c : allChains) {
            TaskChain.TaskChainId annotation = c.getClass().getAnnotation(TaskChain.TaskChainId.class);
            if (annotation != null) {
                log.info(String.format("%1$40s | %2$s", annotation.description(), Joiner.on((String)", ").join((Iterable)Lists.asList((Object)c.getClass().getName(), (Object[])annotation.alias()))));
                continue;
            }
            log.info(String.format("%1$40s | %2$s", "<no name>", c.getClass().getName()));
        }
    }
}

