/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.ui.editor;

import java.util.EventObject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.events.ChangeEvent;
import org.eclipse.tcf.te.runtime.events.EventManager;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.events.IEventListener;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.processes.core.model.ModelManager;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.IProcessContextNode;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.runtime.IRuntimeModel;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.runtime.IRuntimeModelRefreshService;
import org.eclipse.tcf.te.ui.events.AbstractEventListener;
import org.eclipse.tcf.te.ui.swt.DisplayUtil;
import org.eclipse.tcf.te.ui.trees.TreeControl;
import org.eclipse.ui.views.properties.PropertySheet;

public class ProcessMonitorEventListener
extends AbstractEventListener {
    final TreeControl treeControl;

    public ProcessMonitorEventListener(TreeControl treeControl) {
        Assert.isNotNull((Object)treeControl);
        this.treeControl = treeControl;
    }

    public void eventFired(EventObject event) {
        if (event instanceof ChangeEvent) {
            ChangeEvent changeEvent = (ChangeEvent)event;
            Object source = changeEvent.getSource();
            if (this.treeControl.getViewer() != null) {
                if (this.treeControl.getViewer().getControl() == null || this.treeControl.getViewer().getControl().isDisposed()) {
                    EventManager.getInstance().removeEventListener((IEventListener)this);
                    return;
                }
                if (source instanceof IRuntimeModel) {
                    this.treeControl.getViewer().refresh();
                } else if (source instanceof IProcessContextNode) {
                    if ("expanded".equals(changeEvent.getEventId())) {
                        boolean expanded = (Boolean)changeEvent.getNewValue();
                        ((TreeViewer)this.treeControl.getViewer()).setExpandedState(source, expanded);
                    } else {
                        ((TreeViewer)this.treeControl.getViewer()).refresh(source, true);
                    }
                } else if (source instanceof IPeerNode && source == this.getPeerNode()) {
                    if ("ConnectState".equals(changeEvent.getEventId())) {
                        if (changeEvent.getNewValue().equals(11)) {
                            final IRuntimeModel model = ModelManager.getRuntimeModel((IPeerNode)this.getPeerNode());
                            if (this.treeControl.getViewer().getInput() != model) {
                                this.treeControl.getViewer().setInput((Object)model);
                            }
                            Protocol.invokeLater((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    ((IRuntimeModelRefreshService)model.getService(IRuntimeModelRefreshService.class)).refresh((ICallback)new Callback(){

                                        protected void internalDone(Object caller, IStatus status) {
                                            final TreeViewer treeViewer = (TreeViewer)(this).ProcessMonitorEventListener.this.treeControl.getViewer();
                                            DisplayUtil.safeAsyncExec((Runnable)new Runnable(){

                                                @Override
                                                public void run() {
                                                    treeViewer.expandToLevel(treeViewer.getAutoExpandLevel());
                                                }
                                            });
                                        }
                                    });
                                }
                            });
                        } else {
                            this.treeControl.getViewer().refresh();
                        }
                    }
                } else if (source instanceof PropertySheet) {
                    this.treeControl.getParentPart().setFocus();
                }
            }
        }
    }

    protected IPeerNode getPeerNode() {
        IPeerNode peerNode;
        Object element = this.treeControl.getViewer().getInput();
        IPeerNode iPeerNode = peerNode = element instanceof IPeerNode ? (IPeerNode)element : null;
        if (peerNode == null && element instanceof IAdaptable) {
            peerNode = (IPeerNode)((IAdaptable)element).getAdapter(IPeerNode.class);
        }
        return peerNode;
    }
}

