/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.launch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.tcf.internal.debug.launch.TCFUserDefPeer;
import org.eclipse.tcf.internal.debug.ui.Activator;
import org.eclipse.tcf.internal.debug.ui.ImageCache;
import org.eclipse.tcf.internal.debug.ui.launch.PeerPropsDialog;
import org.eclipse.tcf.internal.debug.ui.model.TCFModel;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.ILocator;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class PeerListControl
implements ISelectionProvider {
    private static final int[] COL_WIDTH = new int[]{160, 100, 100, 60, 100, 40};
    private static final String[] COL_TEXT = new String[]{"Name", "OS", "User", "Transport", "Host", "Port"};
    private final Preferences prefs;
    private Tree peer_tree;
    private final PeerInfo peer_info = new PeerInfo();
    private Display display;
    private final ListenerList selection_listeners = new ListenerList(1);
    private String initial_peer_id;

    public PeerListControl(Composite parent, Preferences prefs) {
        this.prefs = prefs;
        this.display = parent.getDisplay();
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                PeerListControl.this.handleDispose();
            }
        });
        this.loadChildren(this.peer_info);
        this.createPeerListArea(parent);
    }

    public PeerListControl(Composite parent) {
        this(parent, null);
    }

    public void setInitialSelection(String id) {
        if (id == null) {
            return;
        }
        if (id.length() == 0) {
            return;
        }
        PeerInfo info = this.findPeerInfo(id);
        if (info != null) {
            this.setSelection((ISelection)new StructuredSelection((Object)info));
            this.fireSelectionChangedEvent();
            this.onPeerSelected(info);
        } else {
            int i;
            String p = id;
            while ((i = p.lastIndexOf(47)) >= 0) {
                TreeItem item = this.findItem(p = p.substring(0, i));
                if (item == null) continue;
                item.setExpanded(true);
            }
            this.initial_peer_id = id;
        }
    }

    public Tree getTree() {
        return this.peer_tree;
    }

    private void createPeerListArea(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setFont(font);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.peer_tree = new Tree(composite, 268437508);
        GridData gd = new GridData(1808);
        gd.minimumHeight = 150;
        gd.minimumWidth = 470;
        this.peer_tree.setLayoutData((Object)gd);
        int i = 0;
        while (i < COL_WIDTH.length) {
            final TreeColumn column = new TreeColumn(this.peer_tree, 16384, i);
            column.setMoveable(true);
            column.setText(COL_TEXT[i]);
            final String id = "w" + i;
            column.setWidth(this.prefs.getInt(id, COL_WIDTH[i]));
            column.addListener(11, new Listener(){

                public void handleEvent(Event event) {
                    PeerListControl.this.prefs.putInt(id, column.getWidth());
                }
            });
            ++i;
        }
        this.peer_tree.setHeaderVisible(true);
        this.peer_tree.setFont(font);
        this.peer_tree.addListener(36, new Listener(){

            public void handleEvent(Event event) {
                TreeItem item = (TreeItem)event.item;
                PeerInfo info = PeerListControl.this.findPeerInfo(item);
                if (info == null) {
                    PeerListControl.this.updateItems(item.getParentItem(), false);
                } else {
                    PeerListControl.this.fillItem(item, info);
                    PeerListControl.this.onPeerListChanged();
                }
            }
        });
        this.peer_tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                TreeItem[] selections = PeerListControl.this.peer_tree.getSelection();
                if (selections.length == 0) {
                    return;
                }
                final PeerInfo info = PeerListControl.this.findPeerInfo(selections[0]);
                if (info == null) {
                    return;
                }
                new PeerPropsDialog(PeerListControl.this.peer_tree.getShell(), PeerListControl.this.getImage(info), info.attrs, info.peer instanceof TCFUserDefPeer).open();
                if (!(info.peer instanceof TCFUserDefPeer)) {
                    return;
                }
                Protocol.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ((TCFUserDefPeer)info.peer).updateAttributes(info.attrs);
                        TCFUserDefPeer.savePeers();
                    }
                });
            }

            public void widgetSelected(SelectionEvent e) {
                PeerListControl.this.fireSelectionChangedEvent();
                TreeItem[] selections = PeerListControl.this.peer_tree.getSelection();
                if (selections.length > 0) {
                    if (!$assertionsDisabled && selections.length != 1) {
                        throw new AssertionError();
                    }
                    PeerInfo info = PeerListControl.this.findPeerInfo(selections[0]);
                    if (info != null) {
                        PeerListControl.this.initial_peer_id = null;
                        PeerListControl.this.onPeerSelected(info);
                    }
                }
                PeerListControl.this.onPeerListChanged();
            }
        });
        this.peer_tree.addTreeListener(new TreeListener(){

            public void treeCollapsed(TreeEvent e) {
                PeerListControl.this.updateItems((TreeItem)e.item, false);
            }

            public void treeExpanded(TreeEvent e) {
                PeerListControl.this.updateItems((TreeItem)e.item, true);
            }
        });
    }

    private void handleDispose() {
        if (this.prefs != null) {
            try {
                this.prefs.flush();
            }
            catch (BackingStoreException x) {
                Activator.log(x);
            }
        }
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                PeerListControl.this.disconnectPeer(PeerListControl.this.peer_info);
                PeerListControl.this.display = null;
            }
        });
    }

    private void disconnectPeer(PeerInfo info) {
        assert (Protocol.isDispatchThread());
        if (info.children != null) {
            PeerInfo[] peerInfoArray = info.children;
            int n = info.children.length;
            int n2 = 0;
            while (n2 < n) {
                PeerInfo p = peerInfoArray[n2];
                this.disconnectPeer(p);
                ++n2;
            }
        }
        if (info.listener != null) {
            info.locator.removeListener((ILocator.LocatorListener)info.listener);
            info.listener = null;
            info.locator = null;
        }
        if (info.channel != null) {
            info.channel.close();
        }
    }

    private boolean canHaveChildren(PeerInfo parent) {
        return parent == this.peer_info || parent.attrs.get("Proxy") != null;
    }

    private void loadChildren(final PeerInfo parent) {
        assert (Thread.currentThread() == this.display.getThread());
        if (parent.children_pending) {
            return;
        }
        assert (parent.children == null);
        parent.children_pending = true;
        parent.children_error = null;
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!$assertionsDisabled && parent.listener != null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && parent.channel != null) {
                    throw new AssertionError();
                }
                if (!PeerListControl.this.canHaveChildren(parent)) {
                    PeerListControl.this.doneLoadChildren(parent, null, new PeerInfo[0]);
                } else if (parent == PeerListControl.this.peer_info) {
                    ((PeerListControl)PeerListControl.this).peer_info.locator = Protocol.getLocator();
                    PeerListControl.this.doneLoadChildren(parent, null, PeerListControl.this.createLocatorListener(PeerListControl.this.peer_info));
                } else {
                    IChannel channel;
                    parent.channel = channel = parent.peer.openChannel();
                    parent.channel.addChannelListener(new IChannel.IChannelListener(){
                        boolean opened = false;
                        boolean closed = false;

                        public void congestionLevel(int level) {
                        }

                        public void onChannelClosed(final Throwable error) {
                            if (!$assertionsDisabled && this.closed) {
                                throw new AssertionError();
                            }
                            if (parent.channel != channel) {
                                return;
                            }
                            if (!this.opened) {
                                PeerListControl.this.doneLoadChildren(parent, error, null);
                            } else if (PeerListControl.this.display != null) {
                                PeerListControl.this.display.asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (parent.children_pending) {
                                            return;
                                        }
                                        parent.children = null;
                                        parent.children_error = error;
                                        PeerListControl.this.updateItems(parent);
                                    }
                                });
                            }
                            this.closed = true;
                            parent.channel = null;
                            parent.locator = null;
                            parent.listener = null;
                        }

                        public void onChannelOpened() {
                            if (!$assertionsDisabled && this.opened) {
                                throw new AssertionError();
                            }
                            if (!$assertionsDisabled && this.closed) {
                                throw new AssertionError();
                            }
                            if (parent.channel != channel) {
                                return;
                            }
                            this.opened = true;
                            parent.locator = (ILocator)parent.channel.getRemoteService(ILocator.class);
                            if (parent.locator == null) {
                                parent.channel.terminate((Throwable)new Exception("Service not supported: Locator"));
                            } else {
                                PeerListControl.this.doneLoadChildren(parent, null, PeerListControl.this.createLocatorListener(parent));
                            }
                        }
                    });
                }
            }
        });
    }

    private PeerInfo[] createLocatorListener(PeerInfo peer) {
        assert (Protocol.isDispatchThread());
        Map map = peer.locator.getPeers();
        PeerInfo[] buf = new PeerInfo[map.size()];
        int n = 0;
        for (IPeer p : map.values()) {
            PeerInfo info = new PeerInfo();
            info.parent = peer;
            info.id = p.getID();
            info.attrs = new HashMap<String, String>(p.getAttributes());
            info.peer = p;
            buf[n++] = info;
        }
        peer.listener = new LocatorListener(peer);
        peer.locator.addListener((ILocator.LocatorListener)peer.listener);
        return buf;
    }

    private void doneLoadChildren(final PeerInfo parent, final Throwable error, final PeerInfo[] children) {
        assert (Protocol.isDispatchThread());
        assert (error == null || children == null);
        if (this.display == null) {
            return;
        }
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!$assertionsDisabled && !parent.children_pending) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && parent.children != null) {
                    throw new AssertionError();
                }
                parent.children_pending = false;
                parent.children = children;
                parent.children_error = error;
                PeerListControl.this.updateItems(parent);
            }
        });
    }

    private ArrayList<PeerInfo> filterPeerList(PeerInfo parent, boolean expanded) {
        PeerInfo p;
        ArrayList<PeerInfo> lst = new ArrayList<PeerInfo>();
        HashMap<String, PeerInfo> local_agents = new HashMap<String, PeerInfo>();
        HashSet<String> ids = new HashSet<String>();
        PeerInfo[] peerInfoArray = parent.children;
        int n = parent.children.length;
        int n2 = 0;
        while (n2 < n) {
            p = peerInfoArray[n2];
            String id = p.attrs.get("AgentID");
            if (id != null && "TCP".equals(p.attrs.get("TransportName")) && "127.0.0.1".equals(p.attrs.get("Host")) && !this.isFiltered(p)) {
                local_agents.put(id, p);
                ids.add(p.id);
            }
            ++n2;
        }
        peerInfoArray = parent.children;
        n = parent.children.length;
        n2 = 0;
        while (n2 < n) {
            p = peerInfoArray[n2];
            PeerInfo i = (PeerInfo)local_agents.get(p.attrs.get("AgentID"));
            if (!(i != null && i != p || this.isFiltered(p))) {
                lst.add(p);
            }
            ++n2;
        }
        if (parent != this.peer_info && expanded) {
            peerInfoArray = this.peer_info.children;
            n = this.peer_info.children.length;
            n2 = 0;
            while (n2 < n) {
                p = peerInfoArray[n2];
                if (p.peer instanceof TCFUserDefPeer && !ids.contains(p.id)) {
                    PeerInfo x = new PeerInfo();
                    x.parent = parent;
                    x.id = p.id;
                    x.attrs = p.attrs;
                    x.peer = p.peer;
                    ids.add(x.id);
                    lst.add(x);
                }
                ++n2;
            }
        }
        return lst;
    }

    private boolean isFiltered(PeerInfo p) {
        boolean filtered = false;
        if (p != null && p.attrs != null) {
            filtered |= p.attrs.get("ValueAdd") != null && ("1".equals(p.attrs.get("ValueAdd").trim()) || Boolean.parseBoolean(p.attrs.get("ValueAdd").trim()));
            filtered |= p.attrs.get("Name") != null && p.attrs.get("Name").endsWith("Command Server");
        }
        return filtered;
    }

    private void updateItems(TreeItem parent_item, boolean reload) {
        final PeerInfo parent_info = this.findPeerInfo(parent_item);
        if (parent_info == null) {
            parent_item.setText("Invalid");
        } else {
            if (reload && parent_info.children_error != null) {
                this.loadChildren(parent_info);
            }
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    PeerListControl.this.updateItems(parent_info);
                }
            });
        }
    }

    private void updateItems(final PeerInfo parent) {
        if (this.display == null) {
            return;
        }
        assert (Thread.currentThread() == this.display.getThread());
        parent.item_update = new Runnable(){

            @Override
            public void run() {
                if (PeerListControl.this.display == null) {
                    return;
                }
                if (parent.item_update != this) {
                    return;
                }
                if (Thread.currentThread() != PeerListControl.this.display.getThread()) {
                    PeerListControl.this.display.asyncExec((Runnable)this);
                    return;
                }
                parent.item_update = null;
                TreeItem[] items = null;
                boolean expanded = true;
                if (parent.children == null || parent.children_error != null) {
                    if (parent == PeerListControl.this.peer_info) {
                        PeerListControl.this.peer_tree.setItemCount(1);
                        items = PeerListControl.this.peer_tree.getItems();
                    } else {
                        TreeItem item = PeerListControl.this.findItem(parent);
                        if (item == null) {
                            return;
                        }
                        expanded = item.getExpanded();
                        item.setItemCount(1);
                        items = item.getItems();
                    }
                    if (!$assertionsDisabled && items.length != 1) {
                        throw new AssertionError();
                    }
                    if (parent.children_pending) {
                        items[0].setForeground(PeerListControl.this.display.getSystemColor(24));
                        PeerListControl.this.fillItem(items[0], "Connecting...");
                    } else if (parent.children_error != null) {
                        String msg = TCFModel.getErrorMessage(parent.children_error, false);
                        items[0].setForeground(PeerListControl.this.display.getSystemColor(3));
                        PeerListControl.this.fillItem(items[0], msg);
                    } else if (expanded) {
                        PeerListControl.this.loadChildren(parent);
                        items[0].setForeground(PeerListControl.this.display.getSystemColor(24));
                        PeerListControl.this.fillItem(items[0], "Connecting...");
                    } else {
                        Protocol.invokeAndWait((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                PeerListControl.this.disconnectPeer(parent);
                            }
                        });
                        PeerListControl.this.fillItem(items[0], "");
                    }
                } else {
                    ArrayList lst = null;
                    if (parent == PeerListControl.this.peer_info) {
                        lst = PeerListControl.this.filterPeerList(parent, expanded);
                        PeerListControl.this.peer_tree.setItemCount(lst.size() > 0 ? lst.size() : 1);
                        items = PeerListControl.this.peer_tree.getItems();
                    } else {
                        TreeItem item = PeerListControl.this.findItem(parent);
                        if (item == null) {
                            return;
                        }
                        expanded = item.getExpanded();
                        lst = PeerListControl.this.filterPeerList(parent, expanded);
                        item.setItemCount(expanded && lst.size() > 0 ? lst.size() : 1);
                        items = item.getItems();
                    }
                    if (expanded && lst.size() > 0) {
                        if (!$assertionsDisabled && items.length != lst.size()) {
                            throw new AssertionError();
                        }
                        int i = 0;
                        while (i < items.length) {
                            PeerListControl.this.fillItem(items[i], (PeerInfo)lst.get(i));
                            ++i;
                        }
                    } else if (expanded) {
                        PeerListControl.this.fillItem(items[0], "No peers");
                    } else {
                        Protocol.invokeAndWait((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                PeerListControl.this.disconnectPeer(parent);
                            }
                        });
                        PeerListControl.this.fillItem(items[0], "");
                    }
                }
                PeerListControl.this.onPeerListChanged();
                if (PeerListControl.this.initial_peer_id != null) {
                    PeerListControl.this.setInitialSelection(PeerListControl.this.initial_peer_id);
                }
            }
        };
        if (parent.children_pending) {
            parent.item_update.run();
        } else {
            Protocol.invokeLater((long)200L, (Runnable)parent.item_update);
        }
    }

    public TreeItem findItem(String path) {
        assert (Thread.currentThread() == this.display.getThread());
        if (path == null) {
            return null;
        }
        int z = path.lastIndexOf(47);
        if (z < 0) {
            int n = this.peer_tree.getItemCount();
            int i = 0;
            while (i < n) {
                TreeItem x = this.peer_tree.getItem(i);
                PeerInfo p = (PeerInfo)x.getData("TCFPeerInfo");
                if (p != null && p.id.equals(path)) {
                    return x;
                }
                ++i;
            }
        } else {
            TreeItem y = this.findItem(path.substring(0, z));
            if (y == null) {
                return null;
            }
            String id = path.substring(z + 1);
            int n = y.getItemCount();
            int i = 0;
            while (i < n) {
                TreeItem x = y.getItem(i);
                PeerInfo p = (PeerInfo)x.getData("TCFPeerInfo");
                if (p != null && p.id.equals(id)) {
                    return x;
                }
                ++i;
            }
        }
        return null;
    }

    public TreeItem findItem(PeerInfo info) {
        if (info == null) {
            return null;
        }
        assert (info.parent != null);
        if (info.parent == this.peer_info) {
            int n = this.peer_tree.getItemCount();
            int i = 0;
            while (i < n) {
                TreeItem x = this.peer_tree.getItem(i);
                if (x.getData("TCFPeerInfo") == info) {
                    return x;
                }
                ++i;
            }
        } else {
            TreeItem y = this.findItem(info.parent);
            if (y == null) {
                return null;
            }
            int n = y.getItemCount();
            int i = 0;
            while (i < n) {
                TreeItem x = y.getItem(i);
                if (x.getData("TCFPeerInfo") == info) {
                    return x;
                }
                ++i;
            }
        }
        return null;
    }

    public String getPath(PeerInfo info) {
        if (info == this.peer_info) {
            return "";
        }
        if (info.parent == this.peer_info) {
            return info.id;
        }
        return String.valueOf(this.getPath(info.parent)) + "/" + info.id;
    }

    public PeerInfo findPeerInfo(String path) {
        TreeItem i = this.findItem(path);
        if (i == null) {
            return null;
        }
        return (PeerInfo)i.getData("TCFPeerInfo");
    }

    private PeerInfo findPeerInfo(TreeItem item) {
        assert (Thread.currentThread() == this.display.getThread());
        if (item == null) {
            return this.peer_info;
        }
        return (PeerInfo)item.getData("TCFPeerInfo");
    }

    private void fillItem(TreeItem item, PeerInfo info) {
        assert (Thread.currentThread() == this.display.getThread());
        Object data = item.getData("TCFPeerInfo");
        if (data != null && data != info) {
            item.removeAll();
        }
        item.setData("TCFPeerInfo", (Object)info);
        String[] text = new String[]{info.attrs.get("Name"), info.attrs.get("OSName"), info.attrs.get("UserName"), info.attrs.get("TransportName"), info.attrs.get("Host"), info.attrs.get("Port")};
        int i = 0;
        while (i < text.length) {
            if (text[i] == null) {
                text[i] = "";
            }
            ++i;
        }
        item.setText(text);
        item.setForeground(this.display.getSystemColor(24));
        item.setImage(this.getImage(info));
        if (!this.canHaveChildren(info)) {
            item.setItemCount(0);
        } else if (info.children == null || info.children_error != null) {
            item.setItemCount(1);
        } else {
            item.setItemCount(info.children.length);
        }
    }

    private void fillItem(TreeItem item, String text) {
        item.setText(text);
        item.setData("TCFPeerInfo", null);
        int n = this.peer_tree.getColumnCount();
        int i = 1;
        while (i < n) {
            item.setText(i, "");
            ++i;
        }
        item.setImage(null);
        item.removeAll();
    }

    private Image getImage(PeerInfo info) {
        return ImageCache.getImage("icons/target_tab");
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selection_listeners.add((Object)listener);
    }

    public ISelection getSelection() {
        TreeItem[] items = this.peer_tree.getSelection();
        Object[] peers = new PeerInfo[items.length];
        int i = 0;
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            peers[i++] = this.findPeerInfo(item);
            ++n2;
        }
        return new StructuredSelection(peers);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selection_listeners.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
        this.peer_tree.deselectAll();
        if (selection instanceof IStructuredSelection) {
            Object[] elements;
            Object[] objectArray = elements = ((IStructuredSelection)selection).toArray();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item;
                Object object = objectArray[n2];
                if (object instanceof PeerInfo && (item = this.findItem((PeerInfo)object)) != null) {
                    this.peer_tree.select(item);
                }
                ++n2;
            }
        }
    }

    private void fireSelectionChangedEvent() {
        Object[] listeners;
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        Object[] objectArray = listeners = this.selection_listeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            try {
                ((ISelectionChangedListener)listener).selectionChanged(event);
            }
            catch (Exception e) {
                Activator.log(e);
            }
            ++n2;
        }
    }

    protected void onPeerListChanged() {
    }

    protected void onPeerSelected(PeerInfo info) {
    }

    private class LocatorListener
    implements ILocator.LocatorListener {
        private final PeerInfo parent;

        LocatorListener(PeerInfo parent) {
            this.parent = parent;
        }

        public void peerAdded(final IPeer peer) {
            if (PeerListControl.this.display == null) {
                return;
            }
            final String id = peer.getID();
            final HashMap attrs = new HashMap(peer.getAttributes());
            PeerListControl.this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    PeerInfo[] arr;
                    if (((LocatorListener)LocatorListener.this).parent.children_error != null) {
                        return;
                    }
                    PeerInfo[] peerInfoArray = arr = ((LocatorListener)LocatorListener.this).parent.children;
                    int n = arr.length;
                    int n2 = 0;
                    while (n2 < n) {
                        PeerInfo p = peerInfoArray[n2];
                        if (!$assertionsDisabled && p.id.equals(id)) {
                            throw new AssertionError();
                        }
                        ++n2;
                    }
                    PeerInfo[] buf = new PeerInfo[arr.length + 1];
                    System.arraycopy(arr, 0, buf, 0, arr.length);
                    PeerInfo info = new PeerInfo();
                    info.parent = LocatorListener.this.parent;
                    info.id = id;
                    info.attrs = attrs;
                    info.peer = peer;
                    buf[arr.length] = info;
                    ((LocatorListener)LocatorListener.this).parent.children = buf;
                    PeerListControl.this.updateItems(LocatorListener.this.parent);
                }
            });
        }

        public void peerChanged(final IPeer peer) {
            if (PeerListControl.this.display == null) {
                return;
            }
            final String id = peer.getID();
            final HashMap attrs = new HashMap(peer.getAttributes());
            PeerListControl.this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (((LocatorListener)LocatorListener.this).parent.children_error != null) {
                        return;
                    }
                    PeerInfo[] arr = ((LocatorListener)LocatorListener.this).parent.children;
                    int i = 0;
                    while (i < arr.length) {
                        if (arr[i].id.equals(id)) {
                            arr[i].attrs = attrs;
                            arr[i].peer = peer;
                            PeerListControl.this.updateItems(LocatorListener.this.parent);
                        }
                        ++i;
                    }
                }
            });
        }

        public void peerRemoved(final String id) {
            if (PeerListControl.this.display == null) {
                return;
            }
            PeerListControl.this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (((LocatorListener)LocatorListener.this).parent.children_error != null) {
                        return;
                    }
                    PeerInfo[] arr = ((LocatorListener)LocatorListener.this).parent.children;
                    PeerInfo[] buf = new PeerInfo[arr.length - 1];
                    int j = 0;
                    int i = 0;
                    while (i < arr.length) {
                        if (arr[i].id.equals(id)) {
                            final PeerInfo info = arr[i];
                            Protocol.invokeLater((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    PeerListControl.this.disconnectPeer(info);
                                }
                            });
                        } else {
                            buf[j++] = arr[i];
                        }
                        ++i;
                    }
                    ((LocatorListener)LocatorListener.this).parent.children = buf;
                    PeerListControl.this.updateItems(LocatorListener.this.parent);
                }
            });
        }

        public void peerHeartBeat(final String id) {
            if (PeerListControl.this.display == null) {
                return;
            }
            PeerListControl.this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (((LocatorListener)LocatorListener.this).parent.children_error != null) {
                        return;
                    }
                    PeerInfo[] arr = ((LocatorListener)LocatorListener.this).parent.children;
                    int i = 0;
                    while (i < arr.length) {
                        if (arr[i].id.equals(id)) {
                            if (arr[i].children_error == null) break;
                            TreeItem item = PeerListControl.this.findItem(arr[i]);
                            boolean visible = item != null;
                            while (visible && item != null) {
                                if (!item.getExpanded()) {
                                    visible = false;
                                }
                                item = item.getParentItem();
                            }
                            if (!visible) break;
                            PeerListControl.this.loadChildren(arr[i]);
                            break;
                        }
                        ++i;
                    }
                }
            });
        }
    }

    public static class PeerInfo {
        public String id;
        public IPeer peer;
        public Map<String, String> attrs;
        PeerInfo parent;
        PeerInfo[] children;
        boolean children_pending;
        Throwable children_error;
        IChannel channel;
        ILocator locator;
        LocatorListener listener;
        Runnable item_update;
    }
}

