/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.dialogs;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.tcf.te.runtime.concurrent.util.ExecutorsUtil;
import org.eclipse.tcf.te.ui.jface.dialogs.CustomTitleAreaDialog;
import org.eclipse.tcf.te.ui.swt.SWTControlUtil;
import org.eclipse.tcf.te.ui.trees.TreeArrayContentProvider;
import org.eclipse.tcf.te.ui.views.navigator.DelegatingLabelProvider;

public abstract class AbstractTreeSelectionDialog
extends CustomTitleAreaDialog {
    TreeViewer viewer;
    private ISelection selection;

    public AbstractTreeSelectionDialog(Shell shell, String contextHelpId) {
        super(shell, contextHelpId);
    }

    protected boolean isResizable() {
        return true;
    }

    protected boolean supportsMultiSelection() {
        return false;
    }

    protected final TreeViewer getViewer() {
        return this.viewer;
    }

    protected void createDialogAreaContent(Composite parent) {
        super.createDialogAreaContent(parent);
        this.setDialogTitle(this.getDialogTitle());
        this.setTitle(this.getTitle());
        this.setDefaultMessage(this.getDefaultMessage(), 0);
        Composite comp = new Composite(parent, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        comp.setLayout((Layout)gl);
        GridData layoutData = new GridData(4, 4, true, true);
        comp.setLayoutData((Object)layoutData);
        this.createTreeAreaContent(comp);
        this.createButtonAreaContent(comp);
    }

    protected int getTreeViewerStyle() {
        return (this.supportsMultiSelection() ? 2 : 4) | 0x800;
    }

    protected TreeViewer createTreeAreaContent(Composite parent) {
        this.viewer = new TreeViewer(parent, this.getTreeViewerStyle());
        Tree tree = this.viewer.getTree();
        TreeColumn column = new TreeColumn(tree, 16384);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
        TableLayout treeLayout = new TableLayout();
        treeLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        tree.setLayout((Layout)treeLayout);
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.minimumHeight = 150;
        layoutData.minimumWidth = 200;
        tree.setLayoutData((Object)layoutData);
        this.viewer.setContentProvider(this.getContentProvider());
        this.viewer.setLabelProvider(this.getLabelProvider());
        this.configureTreeViewer(this.viewer);
        this.viewer.setInput(this.getInput());
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                AbstractTreeSelectionDialog.this.onDoubleClick();
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AbstractTreeSelectionDialog.this.updateEnablement(AbstractTreeSelectionDialog.this.viewer);
            }
        });
        this.viewer.refresh();
        this.updateSelection(this.getSelection());
        return this.viewer;
    }

    protected void onDoubleClick() {
        if (!this.viewer.getSelection().isEmpty()) {
            this.okPressed();
        }
    }

    protected abstract void updateSelection(ISelection var1);

    protected abstract void createButtonAreaContent(Composite var1);

    protected IContentProvider getContentProvider() {
        return new TreeArrayContentProvider();
    }

    protected IBaseLabelProvider getLabelProvider() {
        DelegatingLabelProvider labelProvider = new DelegatingLabelProvider();
        return new DecoratingLabelProvider((ILabelProvider)labelProvider, (ILabelDecorator)labelProvider);
    }

    protected void refresh() {
        ExecutorsUtil.executeInUI((Runnable)new Runnable(){

            @Override
            public void run() {
                AbstractTreeSelectionDialog.this.viewer.refresh();
                AbstractTreeSelectionDialog.this.updateEnablement(AbstractTreeSelectionDialog.this.viewer);
            }
        });
    }

    protected abstract Object getInput();

    protected Control createButtonBar(Composite parent) {
        Control buttonBar = super.createButtonBar(parent);
        this.updateEnablement(this.viewer);
        return buttonBar;
    }

    protected void updateEnablement(TreeViewer viewer) {
        Assert.isNotNull((Object)viewer);
        Button okButton = this.getButton(0);
        SWTControlUtil.setEnabled((Control)okButton, (boolean)this.isValidSelection());
    }

    protected boolean isValidSelection() {
        int selCount = this.viewer.getTree().getSelectionCount();
        return this.supportsMultiSelection() ? selCount > 0 : selCount == 1;
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        Assert.isNotNull((Object)viewer);
        viewer.setSorter((ViewerSorter)new org.eclipse.tcf.te.tcf.ui.navigator.ViewerSorter());
    }

    protected abstract String getDialogTitle();

    protected abstract String getTitle();

    protected abstract String getDefaultMessage();

    public ISelection getSelection() {
        return this.selection;
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
    }

    protected void okPressed() {
        this.selection = this.viewer.getSelection();
        super.okPressed();
    }

    protected void cancelPressed() {
        this.selection = null;
        super.cancelPressed();
    }
}

