/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.launch;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.tcf.internal.debug.ui.ImageCache;
import org.eclipse.tcf.internal.debug.ui.model.TCFModel;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IProcesses;
import org.eclipse.tcf.services.IRunControl;
import org.eclipse.tcf.services.ISysMonitor;
import org.eclipse.tcf.util.TCFTask;

public class ContextListControl {
    private Composite composite;
    private Tree ctx_tree;
    private Display display;
    private IChannel channel;
    private String channel_state;
    private final ContextInfo root_info = new ContextInfo();
    private final ProcessListener prs_listener = new ProcessListener();
    private final ContextListener ctx_listener = new ContextListener();
    private final boolean processes;
    private String initial_selection;

    public ContextListControl(Composite parent, boolean processes) {
        this.processes = processes;
        this.display = parent.getDisplay();
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Protocol.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ContextListControl.this.disconnectPeer();
                        ContextListControl.this.display = null;
                    }
                });
            }
        });
        this.createContextListArea(parent);
    }

    public void setInput(final IPeer peer) {
        assert (Thread.currentThread() == this.display.getThread());
        this.channel = (IChannel)new TCFTask<IChannel>(){

            public void run() {
                ContextListControl.this.disconnectPeer();
                this.done(ContextListControl.this.connectPeer(peer));
            }
        }.getE();
        this.root_info.children = null;
        this.root_info.children_error = null;
        this.root_info.children_pending = false;
        this.root_info.children_reload = false;
        this.loadChildren(this.root_info);
    }

    public Control getControl() {
        return this.composite;
    }

    public Tree getTree() {
        return this.ctx_tree;
    }

    public ContextInfo getSelection() {
        if (this.ctx_tree != null) {
            this.initial_selection = null;
            TreeItem[] items = this.ctx_tree.getSelection();
            if (items.length > 0) {
                ContextInfo info = this.findInfo(items[0]);
                return info;
            }
        }
        return null;
    }

    private void createContextListArea(Composite parent) {
        Font font = parent.getFont();
        this.composite = new Composite(parent, 0);
        this.composite.setFont(font);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.composite.setLayout((Layout)layout);
        this.composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.ctx_tree = new Tree(this.composite, 268437508);
        GridData gd = new GridData(1808);
        gd.minimumHeight = 150;
        gd.minimumWidth = 470;
        this.ctx_tree.setLayoutData((Object)gd);
        this.ctx_tree.setFont(font);
        this.ctx_tree.addListener(36, new Listener(){

            public void handleEvent(Event event) {
                TreeItem item = (TreeItem)event.item;
                ContextInfo info = ContextListControl.this.findInfo(item);
                if (info == null) {
                    ContextListControl.this.updateItems(item.getParentItem(), false);
                } else {
                    ContextListControl.this.fillItem(item, info);
                }
            }
        });
    }

    protected void disconnectPeer() {
        if (this.channel != null && this.channel.getState() != 2) {
            this.channel.close();
        }
    }

    protected IChannel connectPeer(IPeer peer) {
        if (peer == null) {
            return null;
        }
        final IChannel channel = peer.openChannel();
        channel.addChannelListener(new IChannel.IChannelListener(){

            public void congestionLevel(int level) {
            }

            public void onChannelClosed(final Throwable error) {
                if (ContextListControl.this.display != null) {
                    ContextListControl.this.display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (ContextListControl.this.channel != channel) {
                                return;
                            }
                            ((ContextListControl)(this).ContextListControl.this).root_info.children_error = error;
                            ContextListControl.this.loadChildren(ContextListControl.this.root_info);
                        }
                    });
                }
            }

            public void onChannelOpened() {
                if (ContextListControl.this.processes) {
                    IProcesses service = (IProcesses)channel.getRemoteService(IProcesses.class);
                    if (service != null) {
                        service.addListener((IProcesses.ProcessesListener)ContextListControl.this.prs_listener);
                    }
                } else {
                    IRunControl service = (IRunControl)channel.getRemoteService(IRunControl.class);
                    if (service != null) {
                        service.addListener((IRunControl.RunControlListener)ContextListControl.this.ctx_listener);
                    }
                }
                if (ContextListControl.this.display != null) {
                    ContextListControl.this.display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (ContextListControl.this.channel != channel) {
                                return;
                            }
                            ContextListControl.this.loadChildren(ContextListControl.this.root_info);
                            ContextListControl.this.updateItems(ContextListControl.this.root_info);
                        }
                    });
                }
            }
        });
        return channel;
    }

    private void updateItems(TreeItem parent_item, boolean reload) {
        final ContextInfo parent_info = this.findInfo(parent_item);
        if (parent_info == null) {
            parent_item.setText("Invalid");
        } else {
            if (reload && parent_info.children_error != null) {
                this.loadChildren(parent_info);
            }
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    ContextListControl.this.updateItems(parent_info);
                }
            });
        }
    }

    private void updateItems(ContextInfo parent) {
        if (this.display == null) {
            return;
        }
        assert (Thread.currentThread() == this.display.getThread());
        TreeItem[] items = null;
        boolean expanded = true;
        if (parent.children == null || parent.children_error != null) {
            if (parent == this.root_info) {
                this.ctx_tree.deselectAll();
                this.ctx_tree.setItemCount(1);
                items = this.ctx_tree.getItems();
            } else {
                TreeItem item = this.findItem(parent);
                if (item == null) {
                    return;
                }
                expanded = item.getExpanded();
                item.setItemCount(1);
                items = item.getItems();
            }
            assert (items.length == 1);
            items[0].removeAll();
            items[0].setImage(null);
            items[0].setForeground(this.display.getSystemColor(24));
            if (parent.children_pending) {
                items[0].setText("Pending...");
            } else if (parent.children_error != null) {
                String msg = TCFModel.getErrorMessage(parent.children_error, false);
                items[0].setForeground(this.display.getSystemColor(3));
                items[0].setText(msg);
            } else if (this.channel_state != null) {
                items[0].setText(this.channel_state);
            } else if (expanded) {
                this.loadChildren(parent);
                items[0].setText("Pending...");
            } else {
                items[0].setText("");
            }
        } else {
            ContextInfo[] arr = parent.children;
            if (parent == this.root_info) {
                this.ctx_tree.setItemCount(arr.length);
                items = this.ctx_tree.getItems();
            } else {
                TreeItem item = this.findItem(parent);
                if (item == null) {
                    return;
                }
                expanded = item.getExpanded();
                item.setItemCount(expanded ? arr.length : 1);
                items = item.getItems();
            }
            if (expanded) {
                assert (items.length == arr.length);
                int i = 0;
                while (i < items.length) {
                    this.fillItem(items[i], arr[i]);
                    ++i;
                }
                if (items.length == 1 && !items[0].getExpanded()) {
                    items[0].setExpanded(true);
                }
            } else {
                items[0].setText("");
            }
        }
        if (this.initial_selection != null) {
            this.setInitialSelection(this.initial_selection);
        }
    }

    private void loadChildren(final ContextInfo parent) {
        assert (Thread.currentThread() == this.display.getThread());
        final IChannel channel = this.channel;
        parent.children_reload = true;
        if (parent.children_pending) {
            return;
        }
        parent.children_reload = false;
        parent.children_pending = true;
        Protocol.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (channel == null || channel.getState() != 1) {
                    ContextListControl.this.doneLoadChildren(channel, parent, null, new ContextInfo[0]);
                } else if (ContextListControl.this.processes) {
                    ContextListControl.this.loadProcessChildren(channel, parent);
                } else {
                    ContextListControl.this.loadContextChildren(channel, parent);
                }
            }
        });
    }

    private void loadProcessChildren(final IChannel channel, final ContextInfo parent) {
        final IProcesses service = (IProcesses)channel.getRemoteService(IProcesses.class);
        final ISysMonitor sysmon = (ISysMonitor)channel.getRemoteService(ISysMonitor.class);
        if (service == null) {
            this.doneLoadChildren(channel, parent, new Exception("Peer does not support Processes service"), null);
        } else if (!this.canHaveChildren(parent)) {
            this.doneLoadChildren(channel, parent, null, new ContextInfo[0]);
        } else {
            service.getChildren(parent.id, false, new IProcesses.DoneGetChildren(){

                public void doneGetChildren(IToken token, Exception error, String[] context_ids) {
                    if (error != null) {
                        ContextListControl.this.doneLoadChildren(channel, parent, error, null);
                    } else if (context_ids == null || context_ids.length == 0) {
                        ContextListControl.this.doneLoadChildren(channel, parent, null, new ContextInfo[0]);
                    } else {
                        final ArrayList infos = new ArrayList(context_ids.length);
                        final HashSet<IToken> pending = new HashSet<IToken>();
                        String[] stringArray = context_ids;
                        int n = context_ids.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String id = stringArray[n2];
                            final ContextInfo info = new ContextInfo();
                            info.parent = parent;
                            info.id = id;
                            pending.add(service.getContext(id, new IProcesses.DoneGetContext(){

                                public void doneGetContext(IToken token, Exception error, IProcesses.ProcessContext context) {
                                    if (context != null) {
                                        info.name = context.getName();
                                        info.is_attached = context.isAttached();
                                        infos.add(info);
                                    }
                                    pending.remove(token);
                                    if (!pending.isEmpty()) {
                                        return;
                                    }
                                    ContextListControl.this.doneLoadChildren(channel, parent, null, infos.toArray(new ContextInfo[infos.size()]));
                                }
                            }));
                            if (sysmon != null) {
                                pending.add(sysmon.getContext(id, new ISysMonitor.DoneGetContext(){

                                    public void doneGetContext(IToken token, Exception error, ISysMonitor.SysMonitorContext context) {
                                        if (context != null) {
                                            info.pid = context.getPID();
                                        }
                                        pending.remove(token);
                                        if (!pending.isEmpty()) {
                                            return;
                                        }
                                        ContextListControl.this.doneLoadChildren(channel, parent, null, infos.toArray(new ContextInfo[infos.size()]));
                                    }
                                }));
                                pending.add(sysmon.getCommandLine(id, new ISysMonitor.DoneGetCommandLine(){

                                    public void doneGetCommandLine(IToken token, Exception error, String[] cmd_line) {
                                        if (cmd_line != null) {
                                            info.cmd_line = cmd_line;
                                        }
                                        pending.remove(token);
                                        if (!pending.isEmpty()) {
                                            return;
                                        }
                                        ContextListControl.this.doneLoadChildren(channel, parent, null, infos.toArray(new ContextInfo[infos.size()]));
                                    }
                                }));
                            }
                            ++n2;
                        }
                    }
                }
            });
        }
    }

    private void loadContextChildren(final IChannel channel, final ContextInfo parent) {
        final IRunControl service = (IRunControl)channel.getRemoteService(IRunControl.class);
        if (service == null) {
            this.doneLoadChildren(channel, parent, new Exception("Peer does not support Run Control service"), null);
        } else if (!this.canHaveChildren(parent)) {
            this.doneLoadChildren(channel, parent, null, new ContextInfo[0]);
        } else {
            service.getChildren(parent.id, new IRunControl.DoneGetChildren(){

                public void doneGetChildren(IToken token, Exception error, String[] context_ids) {
                    if (error != null) {
                        ContextListControl.this.doneLoadChildren(channel, parent, error, null);
                    } else if (context_ids != null && context_ids.length > 0) {
                        final ArrayList infos = new ArrayList(context_ids.length);
                        final HashSet<IToken> pending = new HashSet<IToken>();
                        String[] stringArray = context_ids;
                        int n = context_ids.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String id = stringArray[n2];
                            pending.add(service.getContext(id, new IRunControl.DoneGetContext(){

                                public void doneGetContext(IToken token, Exception error, IRunControl.RunControlContext context) {
                                    if (context != null) {
                                        ContextInfo info = new ContextInfo();
                                        info.parent = parent;
                                        info.id = context.getID();
                                        info.name = context.getName();
                                        info.additional_info = context.getProperties().get("AdditionalInfo");
                                        info.is_container = context.isContainer();
                                        info.has_state = context.hasState();
                                        info.is_attached = true;
                                        infos.add(info);
                                    }
                                    pending.remove(token);
                                    if (!pending.isEmpty()) {
                                        return;
                                    }
                                    ContextListControl.this.doneLoadChildren(channel, parent, null, infos.toArray(new ContextInfo[infos.size()]));
                                }
                            }));
                            ++n2;
                        }
                    } else {
                        ContextListControl.this.doneLoadChildren(channel, parent, null, new ContextInfo[0]);
                    }
                }
            });
        }
    }

    private void doneLoadChildren(final IChannel channel, final ContextInfo parent, final Throwable error, final ContextInfo[] children) {
        assert (Protocol.isDispatchThread());
        assert (error == null || children == null);
        if (this.display == null) {
            return;
        }
        final String state = this.getChannelState(channel);
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (ContextListControl.this.channel != channel) {
                    return;
                }
                if (!$assertionsDisabled && !parent.children_pending) {
                    throw new AssertionError();
                }
                parent.children_pending = false;
                if (state == null) {
                    parent.children = children;
                    parent.children_error = error;
                    if (parent.children_reload) {
                        ContextListControl.this.loadChildren(parent);
                    }
                } else {
                    parent.children = null;
                    parent.children_reload = false;
                }
                ContextListControl.this.channel_state = state;
                ContextListControl.this.updateItems(parent);
            }
        });
    }

    private String getChannelState(IChannel channel) {
        if (channel == null) {
            return "Not connected";
        }
        switch (channel.getState()) {
            case 0: {
                return "Connecting...";
            }
            case 2: {
                return "Disconnected";
            }
        }
        return null;
    }

    private void onContextRemoved(final String id) {
        if (this.display == null) {
            return;
        }
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                ContextInfo info = ContextListControl.this.findInfo(ContextListControl.this.root_info, id);
                if (info != null && info.parent != null) {
                    ContextListControl.this.loadChildren(info.parent);
                }
            }
        });
    }

    private void onContextAdded(final String parent_id) {
        if (this.display == null) {
            return;
        }
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                ContextInfo info = ContextListControl.this.findInfo(ContextListControl.this.root_info, parent_id);
                if (info != null) {
                    ContextListControl.this.loadChildren(info);
                }
            }
        });
    }

    public String getFullName(ContextInfo info) {
        if (info == null) {
            return null;
        }
        String name = info.name;
        if (name == null) {
            name = info.id;
        }
        if (info.parent == this.root_info) {
            return "/" + name;
        }
        if (info.parent == null) {
            return null;
        }
        String path = this.getFullName(info.parent);
        if (path == null) {
            return null;
        }
        return String.valueOf(path) + '/' + name;
    }

    private ContextInfo findInfoByFullName(ContextInfo parent, String name, boolean expand) {
        ContextInfo[] children;
        if (name == null) {
            return null;
        }
        if (name.startsWith("/")) {
            return this.findInfoByFullName(this.root_info, name.substring(1), expand);
        }
        if (parent.children_pending) {
            return null;
        }
        String head = name;
        String tail = null;
        int i = name.indexOf(47);
        if (i >= 0) {
            head = name.substring(0, i);
            tail = name.substring(i + 1);
        }
        if ((children = parent.children) != null) {
            ContextInfo[] contextInfoArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                ContextInfo info = contextInfoArray[n2];
                if (head.equals(info.name)) {
                    TreeItem item;
                    if (tail == null) {
                        return info;
                    }
                    if (expand && (item = this.findItem(info)) != null) {
                        item.setExpanded(true);
                    }
                    return this.findInfoByFullName(info, tail, expand);
                }
                ++n2;
            }
        } else if (expand) {
            this.loadChildren(parent);
        }
        return null;
    }

    public ContextInfo findInfo(TreeItem item) {
        assert (Thread.currentThread() == this.display.getThread());
        if (item == null) {
            return this.root_info;
        }
        return (ContextInfo)item.getData("TCFContextInfo");
    }

    public ContextInfo findInfo(ContextInfo parent, String id) {
        assert (Thread.currentThread() == this.display.getThread());
        if (id == null) {
            return this.root_info;
        }
        if (id.equals(parent.id)) {
            return parent;
        }
        ContextInfo[] children = parent.children;
        if (children != null) {
            ContextInfo[] contextInfoArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                ContextInfo info = contextInfoArray[n2];
                ContextInfo found = this.findInfo(info, id);
                if (found != null) {
                    return found;
                }
                ++n2;
            }
        }
        return null;
    }

    private TreeItem findItem(ContextInfo info) {
        TreeItem[] items;
        assert (Thread.currentThread() == this.display.getThread());
        if (info == null) {
            return null;
        }
        assert (info.parent != null);
        if (info.parent == this.root_info) {
            TreeItem[] items2;
            TreeItem[] treeItemArray = items2 = this.ctx_tree.getItems();
            int n = items2.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                if (item.getData("TCFContextInfo") == info) {
                    return item;
                }
                ++n2;
            }
            return null;
        }
        TreeItem parent = this.findItem(info.parent);
        if (parent == null) {
            return null;
        }
        TreeItem[] treeItemArray = items = parent.getItems();
        int n = items.length;
        int n3 = 0;
        while (n3 < n) {
            TreeItem item = treeItemArray[n3];
            if (item.getData("TCFContextInfo") == info) {
                return item;
            }
            ++n3;
        }
        return null;
    }

    private void fillItem(TreeItem item, ContextInfo info) {
        assert (Thread.currentThread() == this.display.getThread());
        Object data = item.getData("TCFContextInfo");
        if (data != null && data != info) {
            item.removeAll();
        }
        item.setData("TCFContextInfo", (Object)info);
        StringBuffer bf = new StringBuffer();
        if (info.pid > 0L) {
            bf.append(info.pid);
            bf.append(": ");
        }
        if (info.cmd_line != null && info.cmd_line.length > 0) {
            String[] stringArray = info.cmd_line;
            int n = info.cmd_line.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                bf.append(' ');
                bf.append(s);
                ++n2;
            }
        } else {
            if (info.name != null) {
                bf.append(info.name);
            } else {
                bf.append(info.id);
            }
            if (info.additional_info != null) {
                bf.append(info.additional_info.toString());
            }
        }
        item.setText(bf.toString());
        item.setForeground(this.display.getSystemColor(24));
        item.setImage(this.getImage(info));
        if (!this.canHaveChildren(info)) {
            item.setItemCount(0);
        } else if (info.children == null || info.children_error != null) {
            item.setItemCount(1);
        } else {
            item.setItemCount(info.children.length);
        }
    }

    private boolean canHaveChildren(ContextInfo info) {
        return !info.has_state && (info.is_container || info == this.root_info);
    }

    private Image getImage(ContextInfo info) {
        return ImageCache.getImage(info.has_state ? "icons/thread_not_active" : "icons/full/obj16/debugt_obj");
    }

    public void setInitialSelection(String full_name) {
        TreeItem item;
        if (full_name == null) {
            return;
        }
        if (full_name.length() == 0) {
            return;
        }
        this.initial_selection = full_name;
        ContextInfo info = this.findInfoByFullName(null, full_name, true);
        if (info != null && (item = this.findItem(info)) != null) {
            this.ctx_tree.setSelection(item);
            this.initial_selection = null;
        }
    }

    static class ContextInfo {
        String name;
        String id;
        Object additional_info;
        boolean is_attached;
        boolean is_container;
        boolean has_state;
        long pid;
        String[] cmd_line;
        ContextInfo[] children;
        Throwable children_error;
        boolean children_pending;
        boolean children_reload;
        ContextInfo parent;

        ContextInfo() {
        }
    }

    private final class ContextListener
    implements IRunControl.RunControlListener {
        private ContextListener() {
        }

        public void contextAdded(IRunControl.RunControlContext[] contexts) {
            IRunControl.RunControlContext[] runControlContextArray = contexts;
            int n = contexts.length;
            int n2 = 0;
            while (n2 < n) {
                IRunControl.RunControlContext ctx = runControlContextArray[n2];
                ContextListControl.this.onContextAdded(ctx.getParentID());
                ++n2;
            }
        }

        public void contextChanged(IRunControl.RunControlContext[] contexts) {
        }

        public void contextRemoved(String[] context_ids) {
            String[] stringArray = context_ids;
            int n = context_ids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                ContextListControl.this.onContextRemoved(id);
                ++n2;
            }
        }

        public void contextSuspended(String context, String pc, String reason, Map<String, Object> params) {
        }

        public void contextResumed(String context) {
        }

        public void containerSuspended(String context, String pc, String reason, Map<String, Object> params, String[] suspended_ids) {
        }

        public void containerResumed(String[] context_ids) {
        }

        public void contextException(String context, String msg) {
        }
    }

    private final class ProcessListener
    implements IProcesses.ProcessesListener {
        private ProcessListener() {
        }

        public void exited(String process_id, int exit_code) {
            ContextListControl.this.onContextRemoved(process_id);
        }
    }
}

