/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.views.editor;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tcf.te.ui.views.editor.EditorEventListener;
import org.eclipse.tcf.te.ui.views.editor.EditorInput;
import org.eclipse.tcf.te.ui.views.editor.pages.AbstractCustomFormToolkitEditorPage;
import org.eclipse.tcf.te.ui.views.editor.pages.AbstractEditorPage;
import org.eclipse.tcf.te.ui.views.extensions.EditorPageBinding;
import org.eclipse.tcf.te.ui.views.extensions.EditorPageBindingExtensionPointManager;
import org.eclipse.tcf.te.ui.views.extensions.EditorPageExtensionPointManager;
import org.eclipse.tcf.te.ui.views.interfaces.IEditorPage;
import org.eclipse.tcf.te.ui.views.interfaces.IEditorSaveAsAdapter;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistable;
import org.eclipse.ui.IPersistableEditor;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.internal.part.NullEditorInput;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public final class Editor
extends FormEditor
implements IPersistableEditor,
ITabbedPropertySheetPageContributor {
    private IMemento mementoToRestore;
    private EditorEventListener listener;

    protected void addPages() {
        EditorPageBinding[] bindings;
        IEditorInput input = this.getEditorInput();
        EditorPageBinding[] editorPageBindingArray = bindings = EditorPageBindingExtensionPointManager.getInstance().getApplicableEditorPageBindings(input);
        int n = bindings.length;
        int n2 = 0;
        while (n2 < n) {
            EditorPageBinding binding = editorPageBindingArray[n2];
            this.processPageBinding(binding);
            ++n2;
        }
        if (this.mementoToRestore != null) {
            for (Object page : this.pages) {
                if (!(page instanceof IPersistableEditor)) continue;
                ((IPersistableEditor)page).restoreState(this.mementoToRestore);
            }
            this.mementoToRestore = null;
        }
    }

    public void setFocus() {
        IFormPage fpage = this.getActivePageInstance();
        if (fpage != null) {
            fpage.setFocus();
        } else {
            super.setFocus();
        }
    }

    public void setTitleImage(Image titleImage) {
        super.setTitleImage(titleImage);
    }

    public String getTitleToolTip() {
        String titleStateDecoration;
        String fullToolTip = super.getTitleToolTip();
        IFormPage page = this.getActivePageInstance();
        if (page instanceof AbstractCustomFormToolkitEditorPage && (titleStateDecoration = ((AbstractCustomFormToolkitEditorPage)page).getFormTitleStateDecoration()) != null) {
            fullToolTip = String.valueOf(fullToolTip) + " " + titleStateDecoration;
        }
        return fullToolTip;
    }

    public IFormPage getActivePageInstance() {
        int index = this.getActivePage();
        if (index != -1) {
            return this.getPage(index);
        }
        return super.getActivePageInstance();
    }

    private IFormPage getPage(int index) {
        int i = 0;
        while (i < this.pages.size()) {
            IFormPage fpage;
            Object page = this.pages.get(i);
            if (page instanceof IFormPage && (fpage = (IFormPage)page).getIndex() == index) {
                return fpage;
            }
            ++i;
        }
        return null;
    }

    public void setActivePage(int pageIndex) {
        if (this.getPage(pageIndex) != null) {
            super.setActivePage(pageIndex);
        }
    }

    protected IEditorPart getEditor(int pageIndex) {
        return this.getPage(pageIndex) != null ? super.getEditor(pageIndex) : null;
    }

    protected Composite createPageContainer(Composite parent) {
        if (this.getEditorInput() instanceof NullEditorInput) {
            this.close(false);
        }
        return super.createPageContainer(parent);
    }

    public void updatePageList() {
        String activePageId = this.getActivePageInstance() != null ? this.getActivePageInstance().getId() : null;
        String activePageTitle = this.getActivePageInstance() != null ? this.getActivePageInstance().getTitle() : null;
        IEditorInput input = this.getEditorInput();
        ArrayList<EditorPageBinding> bindings = new ArrayList<EditorPageBinding>(Arrays.asList(EditorPageBindingExtensionPointManager.getInstance().getApplicableEditorPageBindings(input)));
        ArrayList<Object> oldPages = this.pages != null ? new ArrayList<Object>(Arrays.asList(this.pages.toArray())) : new ArrayList();
        for (Object e : oldPages) {
            if (!(e instanceof IFormPage)) continue;
            IFormPage page = (IFormPage)e;
            EditorPageBinding binding = null;
            for (EditorPageBinding candidate : bindings) {
                if (!candidate.getPageId().equals(page.getId())) continue;
                binding = candidate;
                break;
            }
            if (binding != null) {
                bindings.remove((Object)binding);
                continue;
            }
            this.removePage(this.pages.indexOf(page));
        }
        for (EditorPageBinding editorPageBinding : bindings) {
            this.processPageBinding(editorPageBinding);
        }
        if (activePageId != null) {
            int n;
            int n2 = this.getIndexOf(activePageId);
            if (n2 == -1 && activePageTitle != null) {
                n = this.getIndexOfByTitle(activePageTitle);
            }
            if (n != -1) {
                this.setActivePage(n);
            }
        }
    }

    protected void processPageBinding(EditorPageBinding binding) {
        IEditorPage page;
        Assert.isNotNull((Object)((Object)binding));
        String pageId = binding.getPageId();
        if (pageId != null && (page = EditorPageExtensionPointManager.getInstance().getEditorPage(pageId, true)) != null) {
            try {
                int index;
                int n;
                int n2;
                String[] stringArray;
                String[] pageIds;
                page.initialize(this);
                String insertBefore = binding.getInsertBefore().trim();
                String insertAfter = binding.getInsertAfter().trim();
                boolean pageAdded = false;
                if (!"".equals(insertBefore)) {
                    stringArray = pageIds = insertBefore.split(",");
                    n2 = pageIds.length;
                    n = 0;
                    while (n < n2) {
                        String insertBeforePageId = stringArray[n];
                        if ("first".equalsIgnoreCase(insertBeforePageId)) {
                            if (this.getIndexOf(page.getId()) == -1) {
                                this.addPage(0, page);
                            }
                            pageAdded = true;
                            break;
                        }
                        index = this.getIndexOf(insertBeforePageId);
                        if (index != -1) {
                            if (this.getIndexOf(page.getId()) == -1) {
                                this.addPage(index, page);
                            }
                            pageAdded = true;
                            break;
                        }
                        ++n;
                    }
                }
                if (!pageAdded && !"".equals(insertAfter)) {
                    stringArray = pageIds = insertAfter.split(",");
                    n2 = pageIds.length;
                    n = 0;
                    while (n < n2) {
                        String insertAfterPageId = stringArray[n];
                        if ("last".equalsIgnoreCase(insertAfterPageId)) {
                            if (this.getIndexOf(page.getId()) == -1) {
                                this.addPage(page);
                            }
                            pageAdded = true;
                            break;
                        }
                        index = this.getIndexOf(insertAfterPageId);
                        if (index != -1 && index + 1 < this.pages.size()) {
                            if (this.getIndexOf(page.getId()) == -1) {
                                this.addPage(index + 1, page);
                            }
                            pageAdded = true;
                            break;
                        }
                        ++n;
                    }
                }
                if (!pageAdded && this.getIndexOf(page.getId()) == -1) {
                    this.addPage(page);
                }
            }
            catch (PartInitException partInitException) {
                // empty catch block
            }
        }
    }

    protected void configurePage(int index, IFormPage page) throws PartInitException {
        super.configurePage(index, page);
        this.setPageText(index, page.getTitle());
    }

    private int getIndexOf(String pageId) {
        Assert.isNotNull((Object)pageId);
        int i = 0;
        while (i < this.pages.size()) {
            IFormPage fpage;
            Object page = this.pages.get(i);
            if (page instanceof IFormPage && (fpage = (IFormPage)page).getId().equals(pageId)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int getIndexOfByTitle(String pageTitle) {
        Assert.isNotNull((Object)pageTitle);
        int i = 0;
        while (i < this.pages.size()) {
            IFormPage fpage;
            Object page = this.pages.get(i);
            if (page instanceof IFormPage && (fpage = (IFormPage)page).getTitle().equals(pageTitle)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        if (!"".equals(input.getName())) {
            this.setPartName(input.getName());
        }
        if (this.listener != null) {
            this.listener.dispose();
            this.listener = null;
        }
        this.listener = new EditorEventListener(this);
    }

    public void updatePartName() {
        IEditorInput input = this.getEditorInput();
        String oldPartName = this.getPartName();
        if (input instanceof EditorInput) {
            ((EditorInput)input).name = null;
            if (!oldPartName.equals(input.getName())) {
                this.setPartName(input.getName());
            }
        }
    }

    public void dispose() {
        if (this.listener != null) {
            this.listener.dispose();
            this.listener = null;
        }
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        for (Object page : this.pages) {
            if (!(page instanceof AbstractEditorPage)) continue;
            ((AbstractEditorPage)page).preDoSave(monitor);
        }
        this.commitPages(true);
        for (Object page : this.pages) {
            if (!(page instanceof AbstractEditorPage)) continue;
            ((AbstractEditorPage)page).postDoSave(monitor);
        }
        this.editorDirtyStateChanged();
    }

    public void revert() {
        if (this.pages != null) {
            int i = 0;
            while (i < this.pages.size()) {
                IFormPage fpage;
                IManagedForm mform;
                Object page = this.pages.get(i);
                if (page instanceof IFormPage && (mform = (fpage = (IFormPage)page).getManagedForm()) != null && mform.isDirty()) {
                    int j = 0;
                    while (j < mform.getParts().length) {
                        IFormPart part = mform.getParts()[j];
                        part.refresh();
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    public void doSaveAs() {
        Object newNode;
        IEditorSaveAsAdapter adapter;
        IEditorSaveAsAdapter iEditorSaveAsAdapter = adapter = this.getEditorInput() != null ? (IEditorSaveAsAdapter)Platform.getAdapterManager().getAdapter((Object)this.getEditorInput(), IEditorSaveAsAdapter.class) : null;
        if (adapter != null && (newNode = adapter.doSaveAs(this.getEditorInput())) != null) {
            this.setInput(new EditorInput(newNode));
            this.updatePartName();
            this.updatePageList();
            for (Object page : this.pages) {
                if (!(page instanceof AbstractEditorPage)) continue;
                ((AbstractEditorPage)page).init(this.getEditorSite(), this.getEditorInput());
            }
        }
    }

    public boolean isSaveAsAllowed() {
        IEditorSaveAsAdapter adapter;
        IEditorSaveAsAdapter iEditorSaveAsAdapter = adapter = this.getEditorInput() != null ? (IEditorSaveAsAdapter)Platform.getAdapterManager().getAdapter((Object)this.getEditorInput(), IEditorSaveAsAdapter.class) : null;
        if (adapter != null) {
            return adapter.isSaveAsAllowed(this.getEditorInput());
        }
        return false;
    }

    public void restoreState(IMemento memento) {
        this.mementoToRestore = this.internalGetMemento(memento);
    }

    public void saveState(IMemento memento) {
        memento = this.internalGetMemento(memento);
        for (Object page : this.pages) {
            if (!(page instanceof IPersistable)) continue;
            ((IPersistable)page).saveState(memento);
        }
    }

    private IMemento internalGetMemento(IMemento memento) {
        IMemento editorMemento = memento;
        if (memento != null) {
            editorMemento = memento.getChild(Editor.class.getName());
            if (editorMemento == null) {
                editorMemento = memento.createChild(Editor.class.getName());
            }
        } else {
            editorMemento = XMLMemento.createWriteRoot((String)Editor.class.getName());
        }
        return editorMemento;
    }

    public Object getAdapter(Class adapter) {
        Object adapterInstance;
        if (adapter == IPropertySheetPage.class) {
            return new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
        }
        Object object = adapterInstance = this.getActivePageInstance() != null ? this.getActivePageInstance().getAdapter(adapter) : null;
        if (adapterInstance == null) {
            adapterInstance = super.getAdapter(adapter);
        }
        return adapterInstance;
    }

    public String getContributorId() {
        return "org.eclipse.tcf.te.ui";
    }

    public final void firePropertyChange(int propertyId) {
        super.firePropertyChange(propertyId);
    }
}

