/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.dialogs;

import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IRuntimeModel;
import org.eclipse.tcf.te.tcf.filesystem.core.model.ModelManager;
import org.eclipse.tcf.te.tcf.filesystem.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.filesystem.ui.controls.FSTreeContentProvider;
import org.eclipse.tcf.te.tcf.filesystem.ui.controls.FSTreeViewerSorter;
import org.eclipse.tcf.te.tcf.filesystem.ui.dialogs.FSFolderSelectionDialog;
import org.eclipse.tcf.te.tcf.filesystem.ui.interfaces.IFSConstants;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.columns.FSTreeElementLabelProvider;
import org.eclipse.tcf.te.tcf.filesystem.ui.nls.Messages;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.ui.trees.FilterDescriptor;
import org.eclipse.tcf.te.ui.trees.Pending;
import org.eclipse.tcf.te.ui.trees.ViewerStateManager;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class FSOpenFileDialog
extends ElementTreeSelectionDialog {
    private String filterPath = null;
    TreeViewer viewer = null;

    public FSOpenFileDialog(Shell parentShell) {
        this(parentShell, (ILabelProvider)new FSTreeElementLabelProvider(), new FSTreeContentProvider());
    }

    private FSOpenFileDialog(Shell parentShell, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        super(parentShell, FSOpenFileDialog.createDecoratingLabelProvider(labelProvider), contentProvider);
        this.setTitle(Messages.FSOpenFileDialog_title);
        this.setMessage(Messages.FSOpenFileDialog_message);
        this.setAllowMultiple(false);
        this.setStatusLineAboveButtons(false);
        this.setComparator((ViewerComparator)new FSTreeViewerSorter());
        this.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                return FSOpenFileDialog.this.isValidSelection(selection);
            }
        });
    }

    public void setFilterPath(String filterPath) {
        this.filterPath = filterPath;
    }

    public void setInput(Object input) {
        super.setInput(input);
        FilterDescriptor[] filterDescriptors = ViewerStateManager.getInstance().getFilterDescriptors(IFSConstants.ID_TREE_VIEWER_FS, input);
        Assert.isNotNull((Object)filterDescriptors);
        FilterDescriptor[] filterDescriptorArray = filterDescriptors;
        int n = filterDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            FilterDescriptor descriptor = filterDescriptorArray[n2];
            if (descriptor.isEnabled()) {
                this.addFilter(descriptor.getFilter());
            }
            ++n2;
        }
    }

    public void create() {
        super.create();
        if (this.filterPath != null && !"".equals(this.filterPath.trim())) {
            Path path = new Path(this.filterPath);
            if (this.viewer.getInput() instanceof IPeerNode) {
                IFSTreeNode element = null;
                IRuntimeModel model = ModelManager.getRuntimeModel((IPeerNode)((IPeerNode)this.viewer.getInput()));
                if (model != null) {
                    String segment;
                    IFSTreeNode root = model.getRoot();
                    ITreeContentProvider contentProvider = (ITreeContentProvider)this.viewer.getContentProvider();
                    Object[] elements = contentProvider.getElements((Object)root);
                    String string = path.getDevice() != null ? path.getDevice() : (segment = path.segmentCount() > 0 ? path.segment(0) : null);
                    if (segment != null) {
                        Object[] objectArray = elements;
                        int n = elements.length;
                        int n2 = 0;
                        while (n2 < n) {
                            boolean matches;
                            Object elem = objectArray[n2];
                            if (!(elem instanceof IFSTreeNode)) break;
                            IFSTreeNode child = (IFSTreeNode)elem;
                            String name = child.getName();
                            if (name.endsWith("\\") || name.endsWith("/")) {
                                name = name.substring(0, name.length() - 1);
                            }
                            boolean bl = matches = child.isWindowsNode() ? name.equalsIgnoreCase(segment) : name.equals(segment);
                            if (matches) {
                                if (path.segmentCount() > (path.getDevice() != null ? 0 : 1)) {
                                    element = this.findRecursive(child, (IPath)path, path.getDevice() != null ? 0 : 1);
                                    if (element != null) {
                                        break;
                                    }
                                } else {
                                    element = child;
                                    break;
                                }
                            }
                            ++n2;
                        }
                    }
                }
                if (element != null) {
                    StructuredSelection selection = new StructuredSelection(element);
                    AtomicInteger counter = new AtomicInteger();
                    Runnable runnable = new Runnable((ISelection)selection, counter){
                        private final /* synthetic */ ISelection val$selection;
                        private final /* synthetic */ AtomicInteger val$counter;
                        {
                            this.val$selection = iSelection;
                            this.val$counter = atomicInteger;
                        }

                        @Override
                        public void run() {
                            FSOpenFileDialog.this.viewer.setSelection(this.val$selection, true);
                            if (!this.val$selection.equals(FSOpenFileDialog.this.viewer.getSelection()) && this.val$counter.incrementAndGet() <= 10) {
                                FSOpenFileDialog.this.viewer.getControl().getDisplay().asyncExec((Runnable)this);
                            }
                        }
                    };
                    this.viewer.getControl().getDisplay().asyncExec(runnable);
                }
            }
        }
    }

    private IFSTreeNode findRecursive(IFSTreeNode parent, IPath path, int index) {
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)path);
        IFSTreeNode node = null;
        ITreeContentProvider contentProvider = (ITreeContentProvider)this.viewer.getContentProvider();
        Object[] elements = contentProvider.getElements((Object)parent);
        while (elements.length == 1 && elements[0] instanceof Pending) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
            elements = contentProvider.getElements((Object)parent);
        }
        String segment = path.segment(index);
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            boolean matches;
            Object element = objectArray[n2];
            if (!(element instanceof IFSTreeNode)) break;
            IFSTreeNode child = (IFSTreeNode)element;
            String name = child.getName();
            if (name.endsWith("\\") || name.endsWith("/")) {
                name = name.substring(0, name.length() - 1);
            }
            boolean bl = matches = child.isWindowsNode() ? name.equalsIgnoreCase(segment) : name.equals(segment);
            if (matches) {
                if (path.segmentCount() > index + 1) {
                    node = this.findRecursive(child, path, index + 1);
                    if (node != null) {
                        break;
                    }
                } else {
                    node = child;
                    break;
                }
            }
            ++n2;
        }
        return node;
    }

    private static ILabelProvider createDecoratingLabelProvider(ILabelProvider labelProvider) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IDecoratorManager manager = workbench.getDecoratorManager();
        ILabelDecorator decorator = manager.getLabelDecorator();
        return new DecoratingLabelProvider(labelProvider, decorator);
    }

    protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
        this.viewer = super.doCreateTreeViewer(parent, style);
        this.viewer.getTree().setLinesVisible(false);
        FSFolderSelectionDialog.createContextMenuRefresh(this.viewer);
        return this.viewer;
    }

    IStatus isValidSelection(Object[] selection) {
        String pluginId = UIPlugin.getUniqueIdentifier();
        Status error = new Status(4, pluginId, null);
        if (selection == null || selection.length == 0) {
            return error;
        }
        if (!(selection[0] instanceof IFSTreeNode)) {
            return error;
        }
        IFSTreeNode target = (IFSTreeNode)selection[0];
        if (!target.isFile()) {
            return error;
        }
        return new Status(0, pluginId, null);
    }
}

