/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.model;

import java.util.HashMap;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.tcf.protocol.Protocol;

public class TCFModelFonts {
    private static IPropertyChangeListener listener;
    private static final HashMap<String, FontData> fd_normal;
    private static final HashMap<String, FontData> fd_italic;
    private static final HashMap<String, FontData> fd_monospaced;

    static {
        fd_normal = new HashMap();
        fd_italic = new HashMap();
        fd_monospaced = new HashMap();
    }

    public static FontData getNormalFontData(String view_id) {
        FontData fd = fd_normal.get(view_id);
        if (fd == null) {
            if (listener == null) {
                listener = new IPropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent event) {
                        Protocol.invokeLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                fd_normal.clear();
                                fd_italic.clear();
                                fd_monospaced.clear();
                            }
                        });
                    }
                };
                JFaceResources.getFontRegistry().addListener(listener);
            }
            if ("org.eclipse.debug.ui.DebugView".equals(view_id)) {
                fd = JFaceResources.getFontDescriptor((String)"org.eclipse.jface.defaultfont").getFontData()[0];
            } else if ("org.eclipse.tcf.debug.DetailPaneFactory".equals(view_id)) {
                FontData ff = JFaceResources.getFontDescriptor((String)"org.eclipse.jface.defaultfont").getFontData()[0];
                FontData fp = JFaceResources.getFontDescriptor((String)"org.eclipse.debug.ui.DetailPaneFont").getFontData()[0];
                fd = new FontData(fp.getName(), ff.getHeight(), 0);
            } else {
                fd = JFaceResources.getFontDescriptor((String)"org.eclipse.debug.ui.VariableTextFont").getFontData()[0];
            }
            fd_normal.put(view_id, fd);
        }
        return fd;
    }

    public static FontData getItalicFontData(String view_id) {
        FontData fd = fd_italic.get(view_id);
        if (fd == null) {
            FontData fn = TCFModelFonts.getNormalFontData(view_id);
            fd = new FontData(fn.getName(), fn.getHeight(), 2);
            fd_italic.put(view_id, fd);
        }
        return fd;
    }

    public static FontData getMonospacedFontData(String view_id) {
        FontData fd = fd_monospaced.get(view_id);
        if (fd == null) {
            FontData fn = TCFModelFonts.getNormalFontData(view_id);
            FontData fm = JFaceResources.getFontDescriptor((String)"org.eclipse.jface.textfont").getFontData()[0];
            fd = new FontData(fm.getName(), fn.getHeight(), fn.getStyle());
            fd_monospaced.put(view_id, fd);
        }
        return fd;
    }
}

