/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.locator.services;

import java.io.File;
import java.io.FileFilter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.persistence.interfaces.IURIPersistenceService;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.services.ServiceUtils;
import org.eclipse.tcf.te.tcf.core.Tcf;
import org.eclipse.tcf.te.tcf.core.peers.Peer;
import org.eclipse.tcf.te.tcf.locator.interfaces.IPeerModelMigrationDelegate;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.IPeerModelLookupService;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.IPeerModelRefreshService;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.IPeerModelUpdateService;
import org.eclipse.tcf.te.tcf.locator.model.ModelLocationUtil;
import org.eclipse.tcf.te.tcf.locator.nodes.PeerNode;
import org.eclipse.tcf.te.tcf.locator.services.AbstractPeerModelService;
import org.osgi.framework.Version;

public class PeerModelRefreshService
extends AbstractPeerModelService
implements IPeerModelRefreshService {
    public PeerModelRefreshService(IPeerModel parentModel) {
        super(parentModel);
    }

    protected final void invokeCallback(final ICallback callback) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        if (callback != null) {
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    callback.done((Object)PeerModelRefreshService.this, Status.OK_STATUS);
                }
            });
        }
    }

    @Override
    public void refresh(ICallback callback) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        IPeerModel model = this.getPeerModel();
        if (model.isDisposed()) {
            this.invokeCallback(callback);
            return;
        }
        if (!Tcf.isRunning()) {
            this.invokeCallback(callback);
            return;
        }
        ArrayList<IPeerNode> oldChildren = new ArrayList<IPeerNode>(Arrays.asList(model.getPeerNodes()));
        this.refreshStaticPeers(oldChildren, model);
        this.invokeCallback(callback);
    }

    protected void processPeers(Map<String, IPeer> peers, List<IPeerNode> oldChildren, IPeerModel model) {
        Assert.isNotNull(peers);
        Assert.isNotNull(oldChildren);
        Assert.isNotNull((Object)model);
        for (Map.Entry<String, IPeer> entry : peers.entrySet()) {
            IPeer peer = entry.getValue();
            IPeerNode peerNode = model.getService(IPeerModelLookupService.class).lkupPeerModelById(entry.getKey());
            if (peerNode == null) {
                peerNode = new PeerNode(model, peer);
                model.getService(IPeerModelUpdateService.class).add(peerNode);
            } else {
                oldChildren.remove(peerNode);
            }
            if (peerNode.getPeer() == peer) continue;
            peerNode.setProperty("PeerInstance", peer);
        }
        if (!oldChildren.isEmpty()) {
            for (IPeerNode oldPeerNode : oldChildren) {
                model.getService(IPeerModelUpdateService.class).remove(oldPeerNode);
            }
        }
    }

    protected void refreshStaticPeers(List<IPeerNode> oldChildren, IPeerModel model) {
        Assert.isNotNull(oldChildren);
        Assert.isNotNull((Object)model);
        File[] roots = this.getStaticPeerLookupDirectories();
        if (roots.length > 0) {
            HashMap<String, IPeer> peers = new HashMap<String, IPeer>();
            File[] fileArray = roots;
            int n = roots.length;
            int n2 = 0;
            while (n2 < n) {
                File root = fileArray[n2];
                File[] candidates = root.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        Path path = new Path(pathname.getAbsolutePath());
                        return path.getFileExtension() != null && path.getFileExtension().toLowerCase().equals("peer");
                    }
                });
                if (candidates != null && candidates.length > 0) {
                    File[] fileArray2 = candidates;
                    int n3 = candidates.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        File candidate = fileArray2[n4];
                        try {
                            Peer peer;
                            IPeerModelMigrationDelegate delegate;
                            String id;
                            IURIPersistenceService service = (IURIPersistenceService)ServiceManager.getInstance().getService(IURIPersistenceService.class);
                            IPeer tempPeer = (IPeer)service.read(IPeer.class, candidate.getAbsoluteFile().toURI());
                            HashMap<String, String> attrs = new HashMap<String, String>(tempPeer.getAttributes());
                            attrs.put("URI.transient", candidate.getAbsoluteFile().toURI().toString());
                            String name = (String)attrs.get("Name");
                            if (name == null || "".equals(name.trim())) {
                                name = new Path(candidate.getAbsolutePath()).removeFileExtension().lastSegment();
                                attrs.put("Name", name);
                            }
                            if ((id = (String)attrs.get("ID")) == null || "".equals(id.trim()) || "USR:".equals(id.trim())) {
                                String transport = (String)attrs.get("TransportName");
                                String host = (String)attrs.get("Host");
                                String port = (String)attrs.get("Port");
                                if (!(transport == null || host == null || id != null && "USR:".equals(id.trim()))) {
                                    id = String.valueOf(transport.trim()) + ":" + host.trim();
                                    id = String.valueOf(id) + (port != null ? ":" + port.trim() : ":1534");
                                } else {
                                    id = "USR:" + System.currentTimeMillis();
                                    while (peers.containsKey(id)) {
                                        try {
                                            Thread.sleep(20L);
                                        }
                                        catch (InterruptedException interruptedException) {}
                                        id = "USR:" + System.currentTimeMillis();
                                    }
                                }
                                attrs.put("ID", id);
                            }
                            if ((delegate = (IPeerModelMigrationDelegate)ServiceUtils.getDelegateServiceDelegate((Object)(peer = new Peer(attrs)), (Object)peer, IPeerModelMigrationDelegate.class)) != null) {
                                IPeer migratedPeer;
                                Version peerVersion;
                                Version activeVersion = delegate.getVersion();
                                String version = (String)attrs.get("Version");
                                String value = (String)attrs.get("Migrated");
                                boolean migrated = value != null && Boolean.parseBoolean(value);
                                Version version2 = peerVersion = version != null ? new Version(version.trim()) : Version.emptyVersion;
                                if (peerVersion.compareTo(activeVersion) == 0) {
                                    peers.put(peer.getID(), (IPeer)peer);
                                } else if (!migrated && (migratedPeer = delegate.migrate((IPeer)peer)) != null) {
                                    attrs.put("Migrated", Boolean.TRUE.toString());
                                    service.write((Object)new Peer(attrs), null);
                                    attrs = new HashMap(migratedPeer.getAttributes());
                                    attrs.put("URI.transient", null);
                                    attrs.put("Version", activeVersion.toString());
                                    peer = new Peer(attrs);
                                    URI uri = service.getURI((Object)peer);
                                    attrs.put("URI.transient", uri.toString());
                                    service.write((Object)peer, uri);
                                    peers.put(peer.getID(), (IPeer)peer);
                                }
                            } else {
                                peers.put(peer.getID(), (IPeer)peer);
                            }
                        }
                        catch (Throwable throwable) {}
                        ++n4;
                    }
                }
                ++n2;
            }
            if (!oldChildren.isEmpty() || !peers.isEmpty()) {
                this.processPeers(peers, oldChildren, model);
            }
        }
    }

    protected File[] getStaticPeerLookupDirectories() {
        File file;
        ArrayList<File> rootLocations = new ArrayList<File>();
        IPath defaultPath = ModelLocationUtil.getStaticPeersRootLocation();
        if (defaultPath != null && (file = defaultPath.toFile()).canRead() && file.isDirectory() && !rootLocations.contains(file)) {
            rootLocations.add(file);
        }
        return rootLocations.toArray(new File[rootLocations.size()]);
    }
}

