/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.remote.core.operation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.services.IFileSystem;
import org.eclipse.tcf.te.tcf.remote.core.TCFFileStore;
import org.eclipse.tcf.te.tcf.remote.core.operation.PeerInfo;
import org.eclipse.tcf.te.tcf.remote.core.operation.TCFFileStoreOperation;

public class TCFOperationChildStores
extends TCFFileStoreOperation<IFileStore[]> {
    private final List<IFileStore> fFileStores = new ArrayList<IFileStore>();
    private IFileSystem fFileSystem;
    private IFileSystem.IFileHandle fFileHandle;

    public TCFOperationChildStores(TCFFileStore filestore) {
        super(filestore);
    }

    protected void setResult() {
        this.setResult(this.fFileStores.toArray(new IFileStore[this.fFileStores.size()]));
    }

    protected final void setFileSystem(IFileSystem fileSystem) {
        this.fFileSystem = fileSystem;
    }

    protected final void setFileHandle(IFileSystem.IFileHandle fileHandle) {
        this.fFileHandle = fileHandle;
    }

    @Override
    protected IFileStore[] waitForResult(SubMonitor sm) throws CoreException, InterruptedException, OperationCanceledException {
        return (IFileStore[])super.waitForResult(sm);
    }

    @Override
    protected void doExecute() {
        this.getFileSystem(new PeerInfo.DoneGetFileSystem(){

            @Override
            public void done(IFileSystem fileSystem, IStatus status) {
                if (TCFOperationChildStores.this.shallAbort(status)) {
                    return;
                }
                TCFOperationChildStores.this.setFileSystem(fileSystem);
                final String path = TCFOperationChildStores.this.getPath();
                fileSystem.opendir(path, new IFileSystem.DoneOpen(){

                    public void doneOpen(IToken token, IFileSystem.FileSystemException error, IFileSystem.IFileHandle handle) {
                        if (error != null && (path.length() == 0 || path.equals("/"))) {
                            TCFOperationChildStores.this.getFileStore().setIsArtificialRoot();
                            TCFOperationChildStores.this.readRoots();
                        } else if (!TCFOperationChildStores.this.shallAbort((Throwable)error)) {
                            TCFOperationChildStores.this.setFileHandle(handle);
                            TCFOperationChildStores.this.readDir();
                        }
                    }
                });
            }
        });
    }

    protected void readRoots() {
        this.fFileSystem.roots(new IFileSystem.DoneRoots(){

            public void doneRoots(IToken token, IFileSystem.FileSystemException error, IFileSystem.DirEntry[] entries) {
                if (TCFOperationChildStores.this.shallAbort((Throwable)error)) {
                    return;
                }
                IFileSystem.DirEntry[] dirEntryArray = entries;
                int n = entries.length;
                int n2 = 0;
                while (n2 < n) {
                    IFileSystem.DirEntry dirEntry = dirEntryArray[n2];
                    TCFOperationChildStores.this.createFileStore(dirEntry);
                    ++n2;
                }
                TCFOperationChildStores.this.setResult();
            }
        });
    }

    protected void readDir() {
        this.fFileSystem.readdir(this.fFileHandle, new IFileSystem.DoneReadDir(){

            public void doneReadDir(IToken token, IFileSystem.FileSystemException error, IFileSystem.DirEntry[] entries, boolean eof) {
                if (TCFOperationChildStores.this.shallAbort((Throwable)error)) {
                    TCFOperationChildStores.this.closeHandle();
                    return;
                }
                IFileSystem.DirEntry[] dirEntryArray = entries;
                int n = entries.length;
                int n2 = 0;
                while (n2 < n) {
                    IFileSystem.DirEntry dirEntry = dirEntryArray[n2];
                    TCFOperationChildStores.this.createFileStore(dirEntry);
                    ++n2;
                }
                if (eof) {
                    TCFOperationChildStores.this.closeHandle();
                    TCFOperationChildStores.this.setResult();
                } else {
                    TCFOperationChildStores.this.readDir();
                }
            }
        });
    }

    protected void createFileStore(IFileSystem.DirEntry dirEntry) {
        IFileStore child = this.getFileStore().getChild(dirEntry.filename);
        if (child instanceof TCFFileStore) {
            ((TCFFileStore)child).setAttributes(dirEntry.attrs);
        }
        this.fFileStores.add(child);
    }

    protected void closeHandle() {
        if (this.fFileSystem != null && this.fFileHandle != null) {
            this.fFileSystem.close(this.fFileHandle, new IFileSystem.DoneClose(){

                public void doneClose(IToken token, IFileSystem.FileSystemException error) {
                }
            });
            this.fFileSystem = null;
            this.fFileHandle = null;
        }
    }
}

