/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.remote.core;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.remote.core.AbstractRemoteProcessBuilder;
import org.eclipse.remote.core.IRemoteProcess;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.tcf.processes.core.launcher.ProcessLauncher;
import org.eclipse.tcf.te.tcf.remote.core.Messages;
import org.eclipse.tcf.te.tcf.remote.core.TCFConnection;
import org.eclipse.tcf.te.tcf.remote.core.TCFFileStore;
import org.eclipse.tcf.te.tcf.remote.core.TCFProcess;
import org.eclipse.tcf.te.tcf.remote.core.TCFProcessStreams;
import org.eclipse.tcf.te.tcf.remote.core.operation.TCFOperationStartProcess;

public class TCFProcessBuilder
extends AbstractRemoteProcessBuilder {
    private final TCFConnection fConnection;
    private Map<String, String> fEnv;

    public TCFProcessBuilder(TCFConnection connection, List<String> command) {
        super(connection.getRemoteConnection(), command);
        this.fConnection = connection;
    }

    public TCFProcessBuilder(TCFConnection connection, String ... command) {
        this(connection, Arrays.asList(command));
    }

    public IFileStore directory() {
        IFileStore dir = super.directory();
        if (dir == null) {
            dir = this.fConnection.getResource(this.fConnection.getWorkingDirectory());
            this.directory(dir);
        }
        return dir;
    }

    public Map<String, String> environment() {
        if (this.fEnv == null) {
            this.fEnv = new HashMap<String, String>(this.fConnection.getEnv());
        }
        return this.fEnv;
    }

    public int getSupportedFlags() {
        return 0;
    }

    public IRemoteProcess start(int flags) throws IOException {
        if (!this.fConnection.isOpen()) {
            throw new IOException(MessageFormat.format(Messages.TCFProcessBuilder_errorConnectionClosed, this.fConnection.getName()));
        }
        IFileStore dirStore = super.directory();
        String dir = dirStore instanceof TCFFileStore ? ((TCFFileStore)dirStore).getPath() : "";
        List cmd = this.command();
        if (cmd.size() < 1) {
            throw new IOException(Messages.TCFProcessBuilder_errorNoCommand);
        }
        String process = (String)cmd.get(0);
        String[] args = cmd.subList(1, cmd.size()).toArray(new String[cmd.size() - 1]);
        PropertiesContainer launcherProps = new PropertiesContainer();
        launcherProps.setProperty("process.cwd", (Object)dir);
        launcherProps.setProperty("process.path", (Object)process);
        launcherProps.setProperty("process.args", (Object)args);
        launcherProps.setProperty("channel.forceNew", (Object)Boolean.FALSE);
        launcherProps.setProperty("processLaunchFailedMessage", (Object)MessageFormat.format("Failed to launch process {0}", process));
        TCFProcessStreams streamsProxy = new TCFProcessStreams();
        ProcessLauncher launcher = new ProcessLauncher(streamsProxy){

            protected void mergeEnvironment(Map<String, String> processEnv, Map<String, String> processEnvDiff) {
                if (TCFProcessBuilder.this.fEnv != null) {
                    processEnv.clear();
                    processEnv.putAll(TCFProcessBuilder.this.fEnv);
                }
            }
        };
        TCFProcess remoteProcess = new TCFProcess(this, launcher);
        boolean ok = false;
        try {
            new TCFOperationStartProcess(this.fConnection.getPeerNode().getPeer(), launcher, (IPropertiesContainer)launcherProps).execute(SubMonitor.convert(null));
            remoteProcess.connectStreams(streamsProxy, this.redirectErrorStream());
            ok = true;
            TCFProcess tCFProcess = remoteProcess;
            return tCFProcess;
        }
        catch (OperationCanceledException operationCanceledException) {
            return null;
        }
        catch (CoreException e) {
            throw new IOException(Messages.TCFProcessBuilder_errorLaunchingProcess, e);
        }
        finally {
            if (!ok) {
                remoteProcess.destroy();
            }
        }
    }
}

