/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.cdt.ui.breakpoints;

import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointsListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.breakpoints.provisional.IBreakpointContainer;
import org.eclipse.debug.ui.AbstractBreakpointOrganizerDelegate;
import org.eclipse.tcf.internal.cdt.ui.Activator;
import org.eclipse.tcf.internal.cdt.ui.breakpoints.BreakpointScopeCategory;
import org.eclipse.tcf.internal.cdt.ui.breakpoints.BreakpointScopeContainerAdapterFactory;
import org.eclipse.tcf.internal.cdt.ui.breakpoints.TCFBreakpointScopeExtension;

public class BreakpointScopeOrganizer
extends AbstractBreakpointOrganizerDelegate
implements IBreakpointsListener {
    private static IAdaptable[] DEFAULT_CATEGORY_ARRAY = new IAdaptable[]{new BreakpointScopeCategory(null, null)};

    static {
        Platform.getAdapterManager().registerAdapters((IAdapterFactory)new BreakpointScopeContainerAdapterFactory(), IBreakpointContainer.class);
    }

    public BreakpointScopeOrganizer() {
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointsListener)this);
    }

    public IAdaptable[] getCategories(IBreakpoint breakpoint) {
        IMarker marker = breakpoint.getMarker();
        if (marker != null) {
            String filter = marker.getAttribute("org.eclipse.tcf.debug.ContextQuery", null);
            String contextIds = marker.getAttribute("org.eclipse.tcf.debug.ContextIds", null);
            return new IAdaptable[]{new BreakpointScopeCategory(filter, contextIds)};
        }
        return DEFAULT_CATEGORY_ARRAY;
    }

    public void dispose() {
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointsListener)this);
        super.dispose();
    }

    public void breakpointsAdded(IBreakpoint[] breakpoints) {
    }

    public void breakpointsChanged(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
        this.fireCategoryChanged(null);
    }

    public void breakpointsRemoved(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
    }

    public void addBreakpoint(IBreakpoint breakpoint, IAdaptable category) {
        if (category instanceof BreakpointScopeCategory && breakpoint instanceof ICBreakpoint) {
            String filter = ((BreakpointScopeCategory)category).getFilter();
            String contextIds = ((BreakpointScopeCategory)category).getContextIds();
            ICBreakpoint cBreakpoint = (ICBreakpoint)breakpoint;
            try {
                TCFBreakpointScopeExtension scopeExtension = (TCFBreakpointScopeExtension)cBreakpoint.getExtension("org.eclipse.tcf.debug", TCFBreakpointScopeExtension.class);
                if (scopeExtension != null) {
                    scopeExtension.setPropertiesFilter(filter);
                    scopeExtension.setRawContextIds(contextIds);
                }
            }
            catch (CoreException e) {
                Activator.log(e);
            }
        }
    }

    public boolean canAdd(IBreakpoint breakpoint, IAdaptable category) {
        return category instanceof BreakpointScopeCategory && breakpoint instanceof ICBreakpoint;
    }

    public boolean canRemove(IBreakpoint breakpoint, IAdaptable category) {
        return breakpoint instanceof ICBreakpoint;
    }

    public void removeBreakpoint(IBreakpoint breakpoint, IAdaptable category) {
    }
}

