/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.remote.core.operation;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.services.IFileSystem;
import org.eclipse.tcf.te.tcf.remote.core.TCFFileStore;
import org.eclipse.tcf.te.tcf.remote.core.operation.PeerInfo;
import org.eclipse.tcf.te.tcf.remote.core.operation.TCFFileStoreOperation;

public final class TCFOperationMkDir
extends TCFFileStoreOperation<Object> {
    protected final boolean fShallow;

    public TCFOperationMkDir(TCFFileStore filestore, boolean shallow) {
        super(filestore);
        this.fShallow = shallow;
    }

    @Override
    protected void doExecute() {
        this.getFileSystem(new PeerInfo.DoneGetFileSystem(){

            @Override
            public void done(IFileSystem fileSystem, IStatus status) {
                if (TCFOperationMkDir.this.shallAbort(status)) {
                    return;
                }
                IFileSystem.DoneMkDir callback = new IFileSystem.DoneMkDir(){

                    public void doneMkDir(IToken token, IFileSystem.FileSystemException error) {
                        if (TCFOperationMkDir.this.shallAbort((Throwable)error)) {
                            return;
                        }
                        TCFOperationMkDir.this.setResult(null);
                    }
                };
                TCFOperationMkDir.this.mkdir(fileSystem, TCFOperationMkDir.this.getFileStore(), callback);
            }
        });
    }

    protected void mkdir(final IFileSystem fs, final TCFFileStore fileStore, final IFileSystem.DoneMkDir callback) {
        this.stat(fs, fileStore, new IFileSystem.DoneStat(){

            public void doneStat(IToken token, IFileSystem.FileSystemException error, IFileSystem.FileAttrs attrs) {
                if (error == null) {
                    fileStore.setAttributes(attrs);
                }
                if (error == null && attrs.isDirectory()) {
                    callback.doneMkDir(token, null);
                } else if (error != null && error.getStatus() != 65538) {
                    callback.doneMkDir(token, error);
                } else {
                    IFileStore parent;
                    IFileStore iFileStore = parent = TCFOperationMkDir.this.fShallow ? null : fileStore.getParent();
                    if (parent instanceof TCFFileStore) {
                        TCFOperationMkDir.this.mkdir(fs, (TCFFileStore)parent, new IFileSystem.DoneMkDir(){

                            public void doneMkDir(IToken token, IFileSystem.FileSystemException error) {
                                if (error != null) {
                                    callback.doneMkDir(token, error);
                                } else {
                                    fs.mkdir(fileStore.getPath(), null, callback);
                                }
                            }
                        });
                    } else {
                        fs.mkdir(fileStore.getPath(), null, callback);
                    }
                }
            }
        });
    }
}

