/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.cdt.ui.breakpoints;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.dialogs.SelectionDialog;

public class TCFContextQueryExpressionDialog
extends SelectionDialog {
    private final String[] attributes;
    private String expression_text;
    private int expression_parent;
    private final Map<String, String> expression_attrs = new HashMap<String, String>();
    private final String[] column_names = new String[]{"Parameter", "Value"};
    private int pos;
    private int len;

    protected TCFContextQueryExpressionDialog(Shell parentShell, String[] attributes, String expression) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.attributes = attributes;
        this.expression_text = expression;
        this.len = expression.length();
        this.parseExpression();
    }

    private void parseExpression() {
        if (this.pos < this.len && this.expression_text.charAt(this.pos) == '/') {
            ++this.pos;
            this.expression_parent = this.pos;
            this.expression_attrs.clear();
        }
        while (this.pos < this.len) {
            char ch;
            this.parseExpressionPart();
            if (this.pos >= this.len || (ch = this.expression_text.charAt(this.pos)) != '/') break;
            this.expression_parent = ++this.pos;
            this.expression_attrs.clear();
        }
    }

    private void parseExpressionPart() {
        while (this.pos < this.len) {
            String name = this.parseString();
            if (this.pos < this.len && this.expression_text.charAt(this.pos) == '=') {
                ++this.pos;
                String value = this.parseString();
                this.expression_attrs.put(name, value);
            }
            if (this.pos >= this.len || this.expression_text.charAt(this.pos) != ',') break;
            ++this.pos;
        }
    }

    /*
     * Unable to fully structure code
     */
    private String parseString() {
        block4: {
            bf = new StringBuffer();
            if (this.pos >= this.len || this.expression_text.charAt(this.pos) != '\"') ** GOTO lbl17
            ++this.pos;
            while (this.pos < this.len) {
                if ((ch = this.expression_text.charAt(this.pos++)) != '\"') {
                    if (ch == '\\' && this.pos < this.len) {
                        ch = this.expression_text.charAt(this.pos++);
                    }
                    bf.append(ch);
                    continue;
                }
                break block4;
            }
            break block4;
            while ((ch = this.expression_text.charAt(this.pos)) != '=' && ch != '/' && ch != ',') {
                bf.append(ch);
                ++this.pos;
lbl17:
                // 2 sources

                if (this.pos < this.len) continue;
            }
        }
        return bf.toString();
    }

    protected Control createDialogArea(Composite parent) {
        Composite page = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, true);
        page.setLayout((Layout)gridLayout);
        page.setLayoutData((Object)new GridData(4, 4, true, true));
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
        Table table = new Table(parent, 68096);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setLayout((Layout)tableLayout);
        TableViewer tableViewer = new TableViewer(table);
        tableViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        Control cntrl = tableViewer.getControl();
        cntrl.setLayoutData((Object)new GridData(768));
        TableViewerColumn labelColumn = new TableViewerColumn(tableViewer, 0);
        labelColumn.getColumn().setText(this.column_names[0]);
        TableViewerColumn valueColumn = new TableViewerColumn(tableViewer, 24);
        valueColumn.getColumn().setText(this.column_names[1]);
        tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        tableViewer.setLabelProvider((IBaseLabelProvider)new ParameterTableLabelProvider());
        valueColumn.setEditingSupport((EditingSupport)new ExpressionEditingSupport(valueColumn.getViewer()));
        tableViewer.setInput((Object)this.attributes);
        tableViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                String t1 = (String)e1;
                String t2 = (String)e2;
                return t1.compareTo(t2);
            }
        });
        return parent;
    }

    private void appendString(StringBuffer bf, String s) {
        char ch;
        int l = s.length();
        boolean q = false;
        int i = 0;
        while (!q && i < l) {
            ch = s.charAt(i);
            q = !Character.isDigit(ch) && !Character.isLetter(ch);
            ++i;
        }
        if (!q) {
            bf.append(s);
            return;
        }
        bf.append('\"');
        i = 0;
        while (i < l) {
            ch = s.charAt(i);
            if (ch == '\\' || ch == '\"') {
                bf.append('\\');
            }
            bf.append(ch);
            ++i;
        }
        bf.append('\"');
    }

    public String getExpression() {
        StringBuffer bf = new StringBuffer();
        String[] stringArray = this.attributes;
        int n = this.attributes.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            String value = this.expression_attrs.get(name);
            if (value != null && value.length() > 0) {
                if (bf.length() > 0) {
                    bf.append(',');
                }
                this.appendString(bf, name);
                bf.append('=');
                this.appendString(bf, value);
            }
            ++n2;
        }
        return String.valueOf(this.expression_text.substring(0, this.expression_parent)) + bf.toString();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Select Expression Parameters");
    }

    public final class ExpressionEditingSupport
    extends EditingSupport {
        private TextCellEditor editor;
        private ColumnViewer viewer;

        private ExpressionEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.viewer = viewer;
            this.editor = new TextCellEditor((Composite)this.getViewer().getControl(), 0);
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected Object getValue(Object element) {
            String value = (String)TCFContextQueryExpressionDialog.this.expression_attrs.get((String)element);
            if (value == null) {
                value = "";
            }
            return value;
        }

        protected void setValue(Object element, Object value) {
            String name = (String)element;
            String str = (String)value;
            if (str == null || str.length() == 0) {
                TCFContextQueryExpressionDialog.this.expression_attrs.remove(name);
            } else {
                TCFContextQueryExpressionDialog.this.expression_attrs.put(name, str);
            }
            this.viewer.update(element, null);
        }
    }

    private final class ParameterTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ParameterTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int column) {
            if (column == 0) {
                return (String)element;
            }
            return (String)TCFContextQueryExpressionDialog.this.expression_attrs.get((String)element);
        }
    }
}

