/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.remote.core;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.remote.core.AbstractRemoteConnectionManager;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionWorkingCopy;
import org.eclipse.remote.core.IRemoteServices;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.events.ChangeEvent;
import org.eclipse.tcf.te.runtime.events.EventManager;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.events.IEventListener;
import org.eclipse.tcf.te.tcf.locator.interfaces.IPeerModelListener;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.model.ModelManager;
import org.eclipse.tcf.te.tcf.remote.core.Messages;
import org.eclipse.tcf.te.tcf.remote.core.TCFConnection;
import org.eclipse.tcf.te.tcf.remote.core.TCFEclipseFileSystem;
import org.eclipse.tcf.te.tcf.remote.core.TCFRemoteServices;

public class TCFConnectionManager
extends AbstractRemoteConnectionManager
implements IPeerModelListener,
IEventListener {
    private final Map<String, TCFConnection> fConnections = Collections.synchronizedMap(new HashMap());
    private int fInitialized = 0;

    public TCFConnectionManager(TCFRemoteServices services) {
        super((IRemoteServices)services);
    }

    protected TCFRemoteServices getRemoteServices() {
        return (TCFRemoteServices)super.getRemoteServices();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        Map<String, TCFConnection> map = this.fConnections;
        synchronized (map) {
            if (this.fInitialized > 0) {
                return;
            }
            this.fInitialized = 1;
            Protocol.invokeLater((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    EventManager.getInstance().addEventListener((IEventListener)TCFConnectionManager.this, ChangeEvent.class);
                    IPeerModel peerModel = ModelManager.getPeerModel();
                    peerModel.addListener((IPeerModelListener)TCFConnectionManager.this);
                    Map map = TCFConnectionManager.this.fConnections;
                    synchronized (map) {
                        IPeerNode[] iPeerNodeArray = peerModel.getPeerNodes();
                        int n = iPeerNodeArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IPeerNode peerNode = iPeerNodeArray[n2];
                            String name = peerNode.getPeer().getName();
                            TCFConnection connection = (TCFConnection)TCFConnectionManager.this.fConnections.get(name);
                            if (connection != null) {
                                connection.setPeerNode(peerNode);
                            } else {
                                TCFConnectionManager.this.fConnections.put(name, new TCFConnection(TCFConnectionManager.this.getRemoteServices(), peerNode));
                            }
                            ++n2;
                        }
                        Iterator it = TCFConnectionManager.this.fConnections.values().iterator();
                        while (it.hasNext()) {
                            TCFConnection conn = (TCFConnection)it.next();
                            if (conn.getPeerNode() != null) continue;
                            it.remove();
                        }
                        TCFConnectionManager.this.fInitialized = 2;
                        TCFConnectionManager.this.fConnections.notifyAll();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForInitialization(IProgressMonitor monitor) {
        Map<String, TCFConnection> map = this.fConnections;
        synchronized (map) {
            if (this.fInitialized == 2) {
                return;
            }
            if (this.fInitialized == 0) {
                this.initialize();
            }
            while (this.fInitialized != 2) {
                if (monitor.isCanceled()) {
                    return;
                }
                try {
                    this.fConnections.wait(500L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modelChanged(IPeerModel model, IPeerNode peerNode, boolean added) {
        String name = peerNode.getPeer().getName();
        if (added) {
            Map<String, TCFConnection> map = this.fConnections;
            synchronized (map) {
                if (!this.fConnections.containsKey(name)) {
                    this.fConnections.put(name, new TCFConnection(this.getRemoteServices(), peerNode));
                }
            }
        } else {
            TCFConnection connection = this.fConnections.remove(name);
            if (connection != null) {
                connection.setConnectedTCF(false);
            }
        }
    }

    public void modelDisposed(IPeerModel model) {
        this.fConnections.clear();
    }

    public void eventFired(EventObject event) {
        IPeerNode peerNode;
        TCFConnection connection;
        ChangeEvent changeEvent = (ChangeEvent)event;
        Object source = changeEvent.getSource();
        if (source instanceof IPeerNode && "ConnectState".equals(changeEvent.getEventId()) && (connection = this.fConnections.get((peerNode = (IPeerNode)source).getPeer().getName())) != null) {
            Object val = changeEvent.getNewValue();
            boolean connected = val instanceof Number && ((Number)val).intValue() == 11;
            connection.setConnectedTCF(connected);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRemoteConnection getConnection(String name) {
        Map<String, TCFConnection> map = this.fConnections;
        synchronized (map) {
            TCFConnection connection = this.fConnections.get(name);
            if (connection == null && this.fInitialized < 2) {
                connection = new TCFConnection(this.getRemoteServices(), name);
                this.fConnections.put(name, connection);
            }
        }
        return this.fConnections.get(name);
    }

    public IRemoteConnection getConnection(URI uri) {
        String connName = TCFEclipseFileSystem.getConnectionNameFor(uri);
        if (connName != null) {
            return this.getConnection(connName);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IRemoteConnection> getConnections() {
        Map<String, TCFConnection> map = this.fConnections;
        synchronized (map) {
            return new ArrayList<IRemoteConnection>(this.fConnections.values());
        }
    }

    public IRemoteConnectionWorkingCopy newConnection(String name) throws RemoteConnectionException {
        throw new RemoteConnectionException(Messages.TCFConnectionManager_errorNoCreateConnection);
    }

    public void removeConnection(IRemoteConnection conn) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void open(IPeerNode peerNode, IProgressMonitor monitor) throws RemoteConnectionException {
        final boolean[] done = new boolean[1];
        Callback callback = new Callback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void internalDone(Object caller, IStatus status) {
                boolean[] blArray = done;
                synchronized (done) {
                    done[0] = true;
                    done.notify();
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
            }
        };
        boolean[] blArray = done;
        synchronized (done) {
            peerNode.changeConnectState(11, (ICallback)callback, monitor);
            try {
                if (!done[0]) {
                    done.wait();
                }
            }
            catch (InterruptedException e) {
                throw new RemoteConnectionException((Throwable)e);
            }
            if (peerNode.getConnectState() != 11) {
                String msg;
                IStatus status = callback.getStatus();
                if (status != null && !status.isOK() && (msg = status.getMessage()) != null && msg.length() > 0) {
                    throw new RemoteConnectionException(msg, status.getException());
                }
                throw new RemoteConnectionException(Messages.TCFConnectionManager_errorCannotConnect, status != null ? status.getException() : null);
            }
            return;
        }
    }
}

