/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.customcharts.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swtchart.Chart;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.extensions.core.ChartSettings;
import org.eclipse.swtchart.extensions.core.IChartSettings;
import org.eclipse.swtchart.extensions.core.ScrollableChart;
import org.eclipse.swtchart.extensions.piecharts.CircularSeriesData;
import org.eclipse.swtchart.extensions.piecharts.ICircularSeriesData;
import org.eclipse.swtchart.extensions.piecharts.ICircularSeriesSettings;
import org.eclipse.swtchart.extensions.piecharts.PieChart;
import org.eclipse.swtchart.model.Node;
import org.eclipse.swtchart.support.CircularLegend;

public class ParallelPieCharts {
    private Composite composite;
    private List<PieChart> linkedPieCharts;
    private CircularLegend legend;
    private boolean redrawOnClick;
    private ISeries.SeriesType seriesType;
    private int noOfCharts;
    private int noOfSlices;
    private String[] legendLabels;
    private CircularSeriesData[] dataArray;

    public ParallelPieCharts(Composite parent, ISeries.SeriesType type, boolean redraw) {
        this.composite = parent;
        this.redrawOnClick = redraw;
        this.seriesType = type;
        this.linkedPieCharts = new ArrayList<PieChart>();
        parent.setLayout((Layout)new FillLayout());
    }

    public void addPieChartSeries(String[] labels, double[][] val) {
        this.noOfCharts = val[0].length;
        this.legendLabels = labels;
        this.noOfSlices = labels.length;
        double[] values = new double[this.noOfSlices];
        this.dataArray = new CircularSeriesData[this.noOfCharts];
        int i = 0;
        while (i != this.noOfCharts) {
            this.dataArray[i] = new CircularSeriesData();
            this.dataArray[i].getSettings().setSeriesType(this.seriesType);
            values = new double[this.noOfSlices];
            int j = 0;
            while (j != this.noOfSlices) {
                values[j] = val[j][i];
                ++j;
            }
            this.dataArray[i].setSeries(this.legendLabels, values);
            this.setCircularSettings(this.dataArray[i]);
            PieChart pieChart = new PieChart(this.composite, 0);
            pieChart.addSeriesData((ICircularSeriesData)this.dataArray[i]);
            this.linkedPieCharts.add(pieChart);
            this.setSettings(i);
            ++i;
        }
        i = 0;
        while (i != this.noOfCharts) {
            int j = 0;
            while (j != this.noOfCharts) {
                if (i != j) {
                    this.linkedPieCharts.get(i).addLinkedScrollableChart((ScrollableChart)this.linkedPieCharts.get(j));
                }
                ++j;
            }
            ++i;
        }
    }

    public void addChild(String parentId, String childId, double[] vals) {
        if (vals.length != this.noOfCharts) {
            return;
        }
        int i = 0;
        while (i != this.noOfCharts) {
            Node parent = this.dataArray[i].getNodeById(parentId);
            parent.addChild(childId, vals[i]);
            this.setSettings(i);
            ++i;
        }
    }

    public void addChildren(String parentId, String[] childrenId, double[][] vals) {
        if (vals.length != this.noOfCharts || vals[0].length != childrenId.length) {
            return;
        }
        int i = 0;
        while (i != childrenId.length) {
            this.addChild(parentId, childrenId[i], vals[i]);
            this.setSettings(i);
            ++i;
        }
    }

    public void setChartTitles(String[] titles) {
        int length = Math.min(this.noOfCharts, titles.length);
        int i = 0;
        while (i != length) {
            this.linkedPieCharts.get(i).getChartSettings().setTitle(titles[i]);
            PieChart pieChart = this.linkedPieCharts.get(i);
            ChartSettings chartSettings = (ChartSettings)pieChart.getChartSettings();
            chartSettings.setTitleColor(Display.getDefault().getSystemColor(2));
            pieChart.applySettings((IChartSettings)chartSettings);
            ++i;
        }
    }

    public void setRedrawOnClick(boolean redrawOnClick) {
        this.redrawOnClick = redrawOnClick;
        int i = 0;
        while (i != this.noOfCharts) {
            this.setSettings(i);
            ++i;
        }
    }

    private void setSettings(int index) {
        PieChart pieChart = this.linkedPieCharts.get(index);
        pieChart.setLayoutData((Object)new GridData(1808));
        if (index == this.noOfCharts - 1) {
            if (this.legend == null) {
                this.legend = new CircularLegend(this.composite, 0);
            }
            this.legend.setChart((Chart)pieChart.getBaseChart());
            this.legend.updateLayoutData();
            this.legend.setVisible(true);
        }
        ChartSettings chartSettings = (ChartSettings)pieChart.getChartSettings();
        chartSettings.setLegendVisible(false);
        chartSettings.setTitleColor(Display.getDefault().getSystemColor(2));
        chartSettings.setLegendExtendedVisible(false);
        chartSettings.setShowLegendMarker(false);
        pieChart.applySettings((IChartSettings)chartSettings);
    }

    private void setCircularSettings(CircularSeriesData circularSeriesData) {
        ICircularSeriesSettings settings = circularSeriesData.getSettings();
        if (this.redrawOnClick) {
            settings.setRedrawOnClick(true);
            settings.setSliceColor(Display.getDefault().getSystemColor(2));
        } else {
            settings.setSliceColor(Display.getDefault().getSystemColor(1));
            settings.setRedrawOnClick(false);
        }
    }
}

