/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.export.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.export.core.Messages;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.ISeriesSettings;
import org.eclipse.swtchart.extensions.core.ResourceSupport;
import org.eclipse.swtchart.extensions.core.SeriesListUI;

public class ExportSettingsDialog
extends TitleAreaDialog {
    private BaseChart baseChart;
    private Map<String, ISeriesSettings> cache;
    private SeriesListUI seriesListUI;
    private IPreferenceStore preferenceStore = ResourceSupport.getPreferenceStore();
    private Combo comboScaleX;
    private Combo comboScaleY;
    private int indexAxisX;
    private int indexAxisY;

    public ExportSettingsDialog(Shell parent, BaseChart baseChart) {
        super(parent);
        this.baseChart = baseChart;
        ISeries[] seriesArray = baseChart.getSeriesSet().getSeries();
        this.cache = new HashMap<String, ISeriesSettings>();
        ISeries[] iSeriesArray = seriesArray;
        int n = seriesArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISeries series = iSeriesArray[n2];
            String id = series.getId();
            ISeriesSettings seriesSetting = baseChart.getSeriesSettings(id);
            if (seriesSetting != null) {
                this.cache.put(id, seriesSetting);
            }
            ++n2;
        }
    }

    public void create() {
        super.create();
        this.setTitle(Messages.getString("EXPORT_AXIS_SELECTION"));
        this.setMessage(Messages.getString("SELECT_X_Y_TO_EXPORT"), 1);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(composite, 0);
        container.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        this.createSelectionAxisX(container);
        this.createSelectionAxisY(container);
        this.createSeriesList(container);
        return composite;
    }

    private void createSeriesList(Composite container) {
        this.seriesListUI = new SeriesListUI(container, 68354);
        this.seriesListUI.setTableSortable(this.preferenceStore.getBoolean("sortLegendTable"));
        Table table = this.seriesListUI.getTable();
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        table.setLayoutData((Object)gridData);
        this.seriesListUI.setInput((Object)this.baseChart.getSeriesSet().getSeries());
    }

    private void createSelectionAxisX(Composite container) {
        Label label = new Label(container, 0);
        label.setText(Messages.getString("X_AXIS"));
        String[] axisLabelsX = this.baseChart.getAxisLabels("X_AXIS");
        this.comboScaleX = new Combo(container, 8);
        this.comboScaleX.setItems(axisLabelsX);
        this.comboScaleX.setLayoutData((Object)new GridData(768));
        if (axisLabelsX.length > 0) {
            this.comboScaleX.select(0);
        }
    }

    private void createSelectionAxisY(Composite container) {
        Label label = new Label(container, 0);
        label.setText(Messages.getString("Y_AXIS"));
        String[] axisLabelsY = this.baseChart.getAxisLabels("Y_AXIS");
        this.comboScaleY = new Combo(container, 8);
        this.comboScaleY.setItems(axisLabelsY);
        this.comboScaleY.setLayoutData((Object)new GridData(768));
        if (axisLabelsY.length > 0) {
            this.comboScaleY.select(0);
        }
    }

    protected boolean isResizable() {
        return true;
    }

    private void saveInput() {
        this.indexAxisX = this.comboScaleX.getSelectionIndex();
        this.indexAxisY = this.comboScaleY.getSelectionIndex();
    }

    protected void okPressed() {
        this.saveInput();
        super.okPressed();
    }

    public int getIndexAxisSelectionX() {
        return this.indexAxisX;
    }

    public int getIndexAxisSelectionY() {
        return this.indexAxisY;
    }

    public void reset(BaseChart baseChart) {
        ISeries[] seriesArray;
        ISeries[] iSeriesArray = seriesArray = baseChart.getSeriesSet().getSeries();
        int n = seriesArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISeries series = iSeriesArray[n2];
            ISeriesSettings seriesSettings = this.cache.get(series.getId());
            if (seriesSettings != null) {
                baseChart.applySeriesSettings(series, seriesSettings);
            }
            ++n2;
        }
    }
}

