/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.export.images;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swtchart.extensions.core.BaseChart;

public class ImageSupplier {
    public void saveImage(ImageData imageData, String fileName, int format) {
        ImageLoader imageLoader = new ImageLoader();
        imageLoader.data = new ImageData[]{imageData};
        imageLoader.save(fileName, format);
    }

    public ImageData getImageData(BaseChart baseChart) {
        baseChart.redraw();
        baseChart.update();
        Point baseChartSize = baseChart.getSize();
        ChartImageDataProvider chartImageDataProvider = new ChartImageDataProvider(baseChartSize.x, baseChartSize.y);
        Image image = null;
        GC gc = null;
        try {
            ImageData imageData;
            image = new Image((Device)baseChart.getDisplay(), (ImageDataProvider)chartImageDataProvider);
            gc = new GC((Drawable)baseChart);
            gc.copyArea(image, 0, 0);
            ImageData imageData2 = imageData = image.getImageData();
            return imageData2;
        }
        finally {
            if (gc != null && !gc.isDisposed()) {
                gc.dispose();
            }
            if (image != null && !image.isDisposed()) {
                image.dispose();
            }
        }
    }

    private class ChartImageDataProvider
    implements ImageDataProvider {
        private ImageData imageData;

        public ChartImageDataProvider(int width, int height) {
            PaletteData palette = new PaletteData(255, 65280, 0xFF0000);
            this.imageData = new ImageData(width, height, 32, palette);
        }

        public ImageData getImageData(int zoom) {
            if (zoom != 100) {
                return null;
            }
            return this.imageData;
        }
    }
}

