/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.jcommons.io;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.statet.internal.jcommons.io.AbstractArchiveStringUrl;
import org.eclipse.statet.internal.jcommons.io.CommonsUriInternals;
import org.eclipse.statet.jcommons.io.UriUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public final class JarStringUrl
extends AbstractArchiveStringUrl {
    private final int scheme2SepIndex;
    private final int jarSepIndex;
    private final int fragSepIndex;

    public JarStringUrl(String urlString, int scheme2SepIndex, int jarSepIndex) {
        super(urlString);
        int fragmentIdx = urlString.indexOf(35, jarSepIndex);
        this.scheme2SepIndex = scheme2SepIndex;
        this.jarSepIndex = jarSepIndex;
        this.fragSepIndex = fragmentIdx != -1 ? fragmentIdx : urlString.length();
    }

    public JarStringUrl(String urlString) throws URISyntaxException {
        super(urlString);
        if (!CommonsUriInternals.isSchemeUrl(urlString, "jar")) {
            throw new IllegalArgumentException("url= " + urlString);
        }
        int schemeSep2Idx = urlString.indexOf(58, 4);
        if (schemeSep2Idx == -1 || !UriUtils.isValidScheme(urlString, 4, schemeSep2Idx)) {
            throw new URISyntaxException(urlString, "Valid scheme for JAR file is missing", 4);
        }
        int jarSepIdx = urlString.indexOf("!/", schemeSep2Idx + 1);
        if (jarSepIdx == -1) {
            throw new URISyntaxException(urlString, "JAR content separator '!/' is missing", jarSepIdx);
        }
        int fragmentIdx = urlString.indexOf(35, jarSepIdx);
        this.scheme2SepIndex = schemeSep2Idx;
        this.jarSepIndex = jarSepIdx;
        this.fragSepIndex = fragmentIdx != -1 ? fragmentIdx : urlString.length();
    }

    @Override
    public boolean isNested() {
        return false;
    }

    @Override
    public String getOuterArchiveType() {
        return "jar";
    }

    @Override
    public String getOuterArchiveScheme() {
        return this.getUrlString().substring(4, this.scheme2SepIndex);
    }

    @Override
    protected String createOuterArchiveUrl(String urlString) {
        return urlString.substring(4, this.jarSepIndex);
    }

    @Override
    public String getInnerArchiveType() {
        return "jar";
    }

    @Override
    public URI getInnerArchiveUrl() throws URISyntaxException {
        return this.getOuterArchiveUrl();
    }

    @Override
    public String getInnerArchiveUrlString() {
        return this.getOuterArchiveUrlString();
    }

    @Override
    protected String createEntryPath(String urlString) {
        return urlString.substring(this.jarSepIndex + 2, this.fragSepIndex);
    }

    public String createInnerEntryUrlString(String entryPath) {
        String urlString = this.getUrlString();
        StringBuilder sb = new StringBuilder(urlString.length() + entryPath.length() + 2);
        sb.append("jar:nested:");
        sb.append(urlString, 9, this.jarSepIndex);
        sb.append("/!");
        sb.append(urlString, this.jarSepIndex + 2, this.fragSepIndex);
        sb.append("!/");
        sb.append(entryPath);
        sb.append(urlString, this.fragSepIndex, urlString.length());
        return sb.toString();
    }
}

