/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.model.rpkg;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.statet.dsl.core.source.ast.DslAstNode;
import org.eclipse.statet.dsl.dcf.core.source.ast.Field;
import org.eclipse.statet.dsl.dcf.core.source.ast.Value;
import org.eclipse.statet.internal.r.core.model.rpkg.BasicRPkgDescrSourceElement;
import org.eclipse.statet.internal.r.core.model.rpkg.Messages;
import org.eclipse.statet.internal.r.core.model.rpkg.RPkgDescrFieldSourceElement;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.Asts;
import org.eclipse.statet.ltk.core.source.SourceContent;
import org.eclipse.statet.ltk.issues.core.IssueRequestor;
import org.eclipse.statet.ltk.issues.core.impl.AbstractSourceIssueReporter;
import org.eclipse.statet.r.core.model.RPkgDescrFieldDefinition;
import org.eclipse.statet.r.core.model.RPkgDescriptions;
import org.eclipse.statet.r.core.model.rpkg.RPkgDescrField;
import org.eclipse.statet.r.core.model.rpkg.RPkgDescrSourceUnitModelInfo;

@NonNullByDefault
public class RPkgDescrModelInspector
extends AbstractSourceIssueReporter {
    private final HashMap<String, Object> fieldsMap = new HashMap();

    public RPkgDescrModelInspector() {
        super("RPkg.Descr");
    }

    protected void clear() {
        super.clear();
        this.fieldsMap.clear();
    }

    public void run(RPkgDescrSourceUnitModelInfo modelInfo, SourceContent content, IssueRequestor requestor) {
        try {
            try {
                this.init(content, requestor);
                this.checkFields(modelInfo);
                this.flush();
            }
            catch (OperationCanceledException operationCanceledException) {
                this.clear();
            }
        }
        finally {
            this.clear();
        }
    }

    private void checkFields(RPkgDescrSourceUnitModelInfo modelInfo) {
        String pkgType = "Package";
        ArrayList<RPkgDescrFieldDefinition> missingRequired = new ArrayList<RPkgDescrFieldDefinition>();
        for (RPkgDescrFieldDefinition fieldDef : RPkgDescriptions.getRequiredFieldDefinitions()) {
            String value;
            RPkgDescrField field = (RPkgDescrField)modelInfo.getField(fieldDef.getName());
            if (field == null) {
                missingRequired.add(fieldDef);
                continue;
            }
            if (fieldDef != RPkgDescriptions.Type_FIELD || (value = field.getValueText()) == null) continue;
            pkgType = value;
        }
        if (modelInfo.getField(RPkgDescriptions.Authors_R_FIELD.getName()) != null) {
            missingRequired.remove(RPkgDescriptions.Author_FIELD);
            missingRequired.remove(RPkgDescriptions.Maintainer_FIELD);
        }
        if (!missingRequired.isEmpty()) {
            ((BasicRPkgDescrSourceElement)modelInfo.getSourceElement()).setModelStatusCode(4196368);
            for (RPkgDescrFieldDefinition fieldDef : missingRequired) {
                this.addProblem(2, 4196368, this.getMessageBuilder().bind(Messages.Descr_FieldRequiredMissing_message, (Object)fieldDef.getName()));
            }
        }
        ImList fields = modelInfo.getFields();
        for (RPkgDescrField field : fields) {
            RPkgDescrFieldDefinition fieldDef;
            String name = field.getElementName().getSegmentName();
            if (name == null) continue;
            RPkgDescrFieldSourceElement element = (RPkgDescrFieldSourceElement)field;
            Object prev = this.fieldsMap.put(name, element);
            if (prev != null) {
                if (prev instanceof List) {
                    this.fieldsMap.put(name, ImCollections.addElement((List)((List)prev), (Object)element));
                } else {
                    this.fieldsMap.put(name, ImCollections.newList((Object[])new Object[]{prev, element}));
                }
            }
            if ((fieldDef = element.getFieldDef()) == null) continue;
            Field fieldNode = (Field)ObjectUtils.nonNullAssert((Object)element.getAdapter(Field.class));
            if (Asts.hasErrors((AstNode)fieldNode)) {
                element.setModelStatusCode(0x400000);
                continue;
            }
            if (fieldDef == RPkgDescriptions.Encoding_FIELD) {
                this.requireNonEmptyValue(element, fieldNode, 2);
                continue;
            }
            if (fieldDef == RPkgDescriptions.Type_FIELD) {
                this.requireNonEmptyValue(element, fieldNode, 2);
                continue;
            }
            if (fieldDef == RPkgDescriptions.Package_FIELD) {
                this.checkRPkgName(element, fieldNode, pkgType);
                continue;
            }
            if (fieldDef == RPkgDescriptions.License_FIELD) {
                this.requireNonEmptyValue(element, fieldNode, 2);
                continue;
            }
            if (fieldDef == RPkgDescriptions.Author_FIELD || fieldDef == RPkgDescriptions.Maintainer_FIELD || fieldDef == RPkgDescriptions.Authors_R_FIELD) {
                this.requireNonEmptyValue(element, fieldNode, 2);
                continue;
            }
            if (fieldDef == RPkgDescriptions.NeedsCompilation_FIELD) {
                this.requireNonEmptyValue(element, fieldNode, 2);
                continue;
            }
            switch (fieldDef.getDataType()) {
                case 1: {
                    this.checkLogicalValue(fieldDef, element, fieldNode, 2);
                    break;
                }
                case 4: {
                    this.checkUrlValue(fieldDef, element, fieldNode, 1);
                    break;
                }
            }
        }
        for (Map.Entry<String, Object> entry : this.fieldsMap.entrySet()) {
            if (!(entry.getValue() instanceof List)) continue;
            String message = this.getMessageBuilder().bind(Messages.Descr_FieldDuplicate_message, (Object)entry.getKey());
            List elements = (List)entry.getValue();
            for (RPkgDescrFieldSourceElement element : elements) {
                TextRegion range = element.getNameSourceRange();
                this.addProblem(element, 1, 2099296, message, range.getStartOffset(), range.getEndOffset());
            }
        }
    }

    private @Nullable String requireNonEmptyValue(RPkgDescrFieldSourceElement element, Field fieldNode, int problemSeverity) {
        String text = element.getValueText();
        if (text == null || text.isEmpty()) {
            DslAstNode valueNode = fieldNode.getValue();
            this.addProblem(element, problemSeverity, 4196624, this.getMessageBuilder().bind(Messages.Descr_FieldValueMissing_message, (Object)element.getElementName().getDisplayName()), valueNode.getLength() == 0 ? valueNode.getStartOffset() - 1 : valueNode.getStartOffset(), valueNode.getEndOffset());
            return null;
        }
        return text;
    }

    private void checkRPkgName(RPkgDescrFieldSourceElement element, Field fieldNode, String pkgType) {
        String text = this.requireNonEmptyValue(element, fieldNode, 2);
        if (text == null) {
            return;
        }
        int l = text.length();
        int idx = 0;
        while (idx < l) {
            switch (text.charAt(idx)) {
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    break;
                }
                default: {
                    this.addProblem(element, 2, 4196640, this.getMessageBuilder().bind(Messages.RPkgName_InvalidChar_message, (Object)this.getMessageUtil().checkFullQuoteText(text)), this.getValueTextStartOffset(fieldNode, idx), this.getValueTextEndOffset(fieldNode, idx + 1));
                    return;
                }
            }
            ++idx;
        }
        switch (text.charAt(0)) {
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'G': 
            case 'H': 
            case 'I': 
            case 'J': 
            case 'K': 
            case 'L': 
            case 'M': 
            case 'N': 
            case 'O': 
            case 'P': 
            case 'Q': 
            case 'R': 
            case 'S': 
            case 'T': 
            case 'U': 
            case 'V': 
            case 'W': 
            case 'X': 
            case 'Y': 
            case 'Z': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': 
            case 'g': 
            case 'h': 
            case 'i': 
            case 'j': 
            case 'k': 
            case 'l': 
            case 'm': 
            case 'n': 
            case 'o': 
            case 'p': 
            case 'q': 
            case 'r': 
            case 's': 
            case 't': 
            case 'u': 
            case 'v': 
            case 'w': 
            case 'x': 
            case 'y': 
            case 'z': {
                break;
            }
            default: {
                this.addProblem(element, 2, 4196640, this.getMessageBuilder().bind(Messages.RPkgName_InvalidFirstChar_message, (Object)this.getMessageUtil().checkFullQuoteText(text)), this.getValueTextStartOffset(fieldNode, 0), this.getValueTextEndOffset(fieldNode, 1));
                return;
            }
        }
        if (l < 2) {
            this.addValueProblem(element, 2, 4196640, this.getMessageBuilder().bind(Messages.RPkgName_InvalidSingleChar_message, (Object)this.getMessageUtil().checkFullQuoteText(text)), fieldNode);
            return;
        }
        if (text.charAt(l - 1) == '.') {
            this.addProblem(element, 2, 4196640, this.getMessageBuilder().bind(Messages.RPkgName_InvalidEndCharDot_message, (Object)this.getMessageUtil().checkFullQuoteText(text)), this.getValueTextStartOffset(fieldNode, l - 1), this.getValueTextEndOffset(fieldNode, l));
            return;
        }
    }

    private void checkLogicalValue(RPkgDescrFieldDefinition fieldDef, RPkgDescrFieldSourceElement element, Field fieldNode, int problemSeverity) {
        String text = this.requireNonEmptyValue(element, fieldNode, problemSeverity);
        if (text == null) {
            return;
        }
        if (RPkgDescriptions.parseLogical(text) < 0) {
            this.addValueProblem(element, problemSeverity, 4196640, this.getMessageBuilder().bind(Messages.Descr_FieldValueInvalid_LogiLiteral_message, (Object)fieldDef.getName()), fieldNode);
            return;
        }
    }

    private void checkUrlValue(RPkgDescrFieldDefinition fieldDef, RPkgDescrFieldSourceElement element, Field fieldNode, int problemSeverity) {
        String text = this.requireNonEmptyValue(element, fieldNode, problemSeverity);
        if (text == null) {
            return;
        }
        try {
            new URI(text);
        }
        catch (URISyntaxException e) {
            int c;
            String message = this.getMessageBuilder().bind(Messages.Descr_FieldValueInvalid_Url_message, (Object)fieldDef.getName());
            int index = e.getIndex();
            int n = c = index >= 0 ? (int)text.charAt(index) : -1;
            if ((c == 32 || c == 10) && text.startsWith("http", index + 1)) {
                index = -1;
            } else {
                String reason = e.getReason();
                if (reason.length() > 0) {
                    StringBuilder sb = this.getMessageUtil().getStringBuilder();
                    int cp0 = reason.codePointAt(0);
                    sb.appendCodePoint(Character.toLowerCase(cp0));
                    sb.append(reason, Character.charCount(cp0), reason.length());
                    reason = sb.toString();
                }
                message = String.valueOf(message) + ' ' + this.getMessageBuilder().bind(Messages.Descr_FieldValueInvalid_Url_Detail_message, (Object)this.getMessageUtil().checkFullQuoteText(text), (Object)reason);
            }
            if (index >= 0) {
                this.addProblem(element, problemSeverity, 4196640, message, this.getValueTextStartOffset(fieldNode, index), this.getValueTextEndOffset(fieldNode, index + 1));
            }
            this.addValueProblem(element, problemSeverity, 4196640, message, fieldNode);
        }
    }

    private int getValueTextStartOffset(Field fieldNode, int offset) {
        DslAstNode valueNode = fieldNode.getValue();
        if (valueNode instanceof Value) {
            ImList textRegions = ((Value)valueNode).getTextRegions();
            for (TextRegion textRegion : textRegions) {
                if (offset < textRegion.getLength()) {
                    return textRegion.getStartOffset() + offset;
                }
                if (offset == textRegion.getLength()) {
                    SourceContent sourceContent = this.getSourceContent();
                    int sourceOffset = textRegion.getStartOffset() + offset;
                    if (sourceOffset < sourceContent.getLength() && sourceContent.getChar(sourceOffset) == '\n') {
                        return sourceOffset - 1;
                    }
                    return sourceOffset;
                }
                offset -= 1 + textRegion.getLength();
            }
        }
        return valueNode.getStartOffset();
    }

    private int getValueTextEndOffset(Field fieldNode, int offset) {
        DslAstNode valueNode = fieldNode.getValue();
        if (valueNode instanceof Value) {
            ImList textRegions = ((Value)valueNode).getTextRegions();
            for (TextRegion textRegion : textRegions) {
                if (offset <= textRegion.getLength()) {
                    return textRegion.getStartOffset() + offset;
                }
                offset -= 1 + textRegion.getLength();
            }
        }
        return valueNode.getEndOffset();
    }

    private final void addProblem(BasicRPkgDescrSourceElement element, int problemSeverity, int code, String message, int startOffset, int endOffset) {
        element.setModelStatusCode(code);
        this.addProblem(problemSeverity, code, message, startOffset, endOffset);
    }

    private void addValueProblem(BasicRPkgDescrSourceElement element, int problemSeverity, int code, String message, Field fieldNode) {
        ImList textRegions;
        element.setModelStatusCode(code);
        DslAstNode valueNode = fieldNode.getValue();
        if (valueNode instanceof Value && !(textRegions = ((Value)valueNode).getTextRegions()).isEmpty()) {
            this.addProblem(problemSeverity, code, message, ((TextRegion)textRegions.get(0)).getStartOffset(), ((TextRegion)textRegions.get(textRegions.size() - 1)).getEndOffset());
            return;
        }
        this.addProblem(problemSeverity, code, message, valueNode.getStartOffset(), valueNode.getEndOffset());
    }
}

