/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.util.data;

import org.eclipse.statet.ecommons.waltable.core.data.DataCell;
import org.eclipse.statet.ecommons.waltable.core.data.SpanningDataProvider;
import org.eclipse.statet.ecommons.waltable.util.data.DummyBodyDataProvider;

public class DummySpanningBodyDataProvider
extends DummyBodyDataProvider
implements SpanningDataProvider {
    private static final long BLOCK_SIZE = 4L;
    private static final long CELL_SPAN = 2L;

    public DummySpanningBodyDataProvider(long columnCount, long rowCount) {
        super(columnCount, rowCount);
    }

    @Override
    public DataCell getCellByPosition(long columnPosition, long rowPosition) {
        long columnBlock = columnPosition / 4L;
        long rowBlock = rowPosition / 4L;
        boolean isSpanned = this.isEven(columnBlock + rowBlock) && columnPosition % 4L < 2L && rowPosition % 4L < 2L;
        long columnSpan = isSpanned ? 2L : 1L;
        long rowSpan = isSpanned ? 2L : 1L;
        long cellColumnPosition = columnPosition;
        long cellRowPosition = rowPosition;
        if (isSpanned) {
            cellColumnPosition -= columnPosition % 4L;
            cellRowPosition -= rowPosition % 4L;
        }
        return new DataCell(cellColumnPosition, cellRowPosition, columnSpan, rowSpan);
    }

    private boolean isEven(long i) {
        return i % 2L == 0L;
    }
}

