/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.redocs.wikitext.r.commonmark.core;

import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.statet.docmlet.wikitext.commonmark.core.CommonmarkLanguage;
import org.eclipse.statet.docmlet.wikitext.core.markup.MarkupConfig;
import org.eclipse.statet.docmlet.wikitext.core.markup.MarkupParser2;
import org.eclipse.statet.docmlet.wikitext.core.markup.WikitextMarkupLanguage;
import org.eclipse.statet.docmlet.wikitext.core.source.BlockWeaveParticipant;
import org.eclipse.statet.docmlet.wikitext.core.source.RegexBlockWeaveParticipant;
import org.eclipse.statet.docmlet.wikitext.core.source.RegexInlineWeaveParticipant;
import org.eclipse.statet.docmlet.wikitext.core.source.WeaveLanguageProcessor;
import org.eclipse.statet.docmlet.wikitext.core.source.extdoc.ExtdocMarkupLanguage;
import org.eclipse.statet.docmlet.wikitext.core.source.extdoc.TexMathDollarsDisplayWeaveParticipant;
import org.eclipse.statet.docmlet.wikitext.core.source.extdoc.TexMathDollarsInlineWeaveParticipant;
import org.eclipse.statet.docmlet.wikitext.core.source.extdoc.TexMathSBackslashDisplayWeaveParticipant;
import org.eclipse.statet.docmlet.wikitext.core.source.extdoc.TexMathSBackslashInlineWeaveParticipant;
import org.eclipse.statet.docmlet.wikitext.core.source.extdoc.YamlBlockWeaveParticipant;
import org.eclipse.statet.internal.redocs.wikitext.r.commonmark.core.RChunkPartitionNodeScanner;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.core.source.SourceContent;
import org.eclipse.statet.redocs.r.core.source.AbstractRChunkPartitionNodeScanner;
import org.eclipse.statet.redocs.wikitext.r.commonmark.core.RCommonmarkConfig;
import org.eclipse.statet.redocs.wikitext.r.core.source.RweaveMarkupLanguage;

@NonNullByDefault
public class RCommonmarkLanguage
extends CommonmarkLanguage
implements ExtdocMarkupLanguage,
RweaveMarkupLanguage {
    public static final String COMMONMARK_RWEAVE_LANGUAGE_NAME = "CommonMark+R";
    private static final ImList<String> INDENT_PREFIXES = ImCollections.newList((Object[])new String[]{" ", "\t"});
    private static final Pattern CHUNK_START_LINE_PATTERN = Pattern.compile("\\A[ \\t]*+```[ \\t]*+(?:\\{\\.?r)(.*?)}?\\s*\\z");
    private static final Pattern CHUNK_REF_LINE_PATTERN = Pattern.compile("\\A[ \\t]*+<<(.*?)(?:>>)?+\\p{all}*\\z");
    private static final Pattern CHUNK_END_LINE_PATTERN = Pattern.compile("\\A[ \\t]*+```[ \\t]*+(?!\\{\\.?r)\\p{all}*\\z");
    private static final Pattern INLINE_PATTERN = Pattern.compile("`r ([^`]+)`");
    private @Nullable RCommonmarkConfig configuredConfig;
    private @Nullable WeaveLanguageProcessor weaveProcessor;
    private @Nullable RChunkPartitionNodeScanner rPartitionScanner;

    public RCommonmarkLanguage() {
        this(null, 0, null);
    }

    public RCommonmarkLanguage(String scope, int mode, @Nullable RCommonmarkConfig config) {
        super(scope, mode, (MarkupConfig)config);
        assert ("CommonMark\u2002[StatET]".equals(this.getName()));
        this.setName(COMMONMARK_RWEAVE_LANGUAGE_NAME);
        this.setExtendsLanguage("CommonMark\u2002[StatET]");
        this.setMarkupConfig((MarkupConfig)config);
    }

    public RCommonmarkLanguage clone() {
        return (RCommonmarkLanguage)super.clone();
    }

    public RCommonmarkLanguage clone(String scope, int mode) {
        return (RCommonmarkLanguage)super.clone(scope, mode);
    }

    public void setMarkupConfig(@Nullable MarkupConfig config) {
        super.setMarkupConfig(config);
    }

    public @Nullable RCommonmarkConfig getMarkupConfig() {
        return (RCommonmarkConfig)super.getMarkupConfig();
    }

    protected void configure(WeaveLanguageProcessor weaveProcessor, @Nullable RCommonmarkConfig config) {
        weaveProcessor.addChunkParticipant((BlockWeaveParticipant)new RegexBlockWeaveParticipant("R", 1, CHUNK_START_LINE_PATTERN, CHUNK_END_LINE_PATTERN){

            protected void appendReplacement(StringBuilder sb, String source, int startOffset, int endOffset) {
                int offset = startOffset;
                while (offset < endOffset) {
                    char c = source.charAt(offset);
                    if (c != ' ' && c != '\t') break;
                    ++offset;
                }
                if (startOffset < offset) {
                    sb.append(source, startOffset, offset);
                }
                super.appendReplacement(sb, source, startOffset, endOffset);
            }
        });
        weaveProcessor.addInlineParticipants(new RegexInlineWeaveParticipant("R", 2, INLINE_PATTERN));
        if (config != null) {
            if (config.isYamlMetadataEnabled()) {
                weaveProcessor.addChunkParticipant((BlockWeaveParticipant)new YamlBlockWeaveParticipant());
            }
            if (config.isTexMathDollarsEnabled()) {
                weaveProcessor.addInlineParticipants((RegexInlineWeaveParticipant)new TexMathDollarsDisplayWeaveParticipant(this.isModeEnabled(16)));
                weaveProcessor.addInlineParticipants((RegexInlineWeaveParticipant)new TexMathDollarsInlineWeaveParticipant(this.isModeEnabled(16)));
            }
            if (config.isTexMathSBackslashEnabled()) {
                weaveProcessor.addInlineParticipants((RegexInlineWeaveParticipant)new TexMathSBackslashDisplayWeaveParticipant());
                weaveProcessor.addInlineParticipants((RegexInlineWeaveParticipant)new TexMathSBackslashInlineWeaveParticipant());
            }
        }
    }

    public void processContent(MarkupParser2 parser, SourceContent content, boolean asDocument) {
        RCommonmarkConfig config;
        if (parser == null) {
            throw new NullPointerException("parser");
        }
        if (content == null) {
            throw new NullPointerException("content");
        }
        if (parser.getBuilder() == null) {
            throw new NullPointerException("parser.builder");
        }
        WeaveLanguageProcessor weaveProcessor = this.weaveProcessor;
        if (weaveProcessor == null) {
            this.weaveProcessor = weaveProcessor = new WeaveLanguageProcessor();
        }
        if ((config = this.getMarkupConfig()) != this.configuredConfig) {
            weaveProcessor.clearConfig();
            this.configure(weaveProcessor, config);
            this.configuredConfig = config;
        }
        String markupContent = weaveProcessor.preprocess(content, parser.getBuilder(), parser.getFlags());
        MarkupParser2 baseParser = new MarkupParser2((WikitextMarkupLanguage)this, (DocumentBuilder)weaveProcessor, parser.getFlags());
        this.doProcessContent(baseParser, new SourceContent(content.getStamp(), markupContent), asDocument);
        weaveProcessor.finish();
    }

    public List<String> getIndentPrefixes() {
        return INDENT_PREFIXES;
    }

    public Pattern getRChunkStartLinePattern() {
        return CHUNK_START_LINE_PATTERN;
    }

    public Pattern getRChunkRefLinePattern() {
        return CHUNK_REF_LINE_PATTERN;
    }

    public Pattern getRChunkEndLinePattern() {
        return CHUNK_END_LINE_PATTERN;
    }

    public AbstractRChunkPartitionNodeScanner getRChunkPartitionScanner() {
        RChunkPartitionNodeScanner rPartitionScanner = this.rPartitionScanner;
        if (rPartitionScanner == null) {
            this.rPartitionScanner = rPartitionScanner = new RChunkPartitionNodeScanner();
        }
        return rPartitionScanner;
    }
}

