/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.wikitext.core.source;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.Locator;
import org.eclipse.statet.docmlet.wikitext.core.markup.WikitextLocator;
import org.eclipse.statet.docmlet.wikitext.core.source.BlockWeaveParticipant;
import org.eclipse.statet.docmlet.wikitext.core.source.EmbeddingAttributes;
import org.eclipse.statet.docmlet.wikitext.core.source.ImageByRefAttributes;
import org.eclipse.statet.docmlet.wikitext.core.source.LabelInfo;
import org.eclipse.statet.docmlet.wikitext.core.source.LinkByRefAttributes;
import org.eclipse.statet.docmlet.wikitext.core.source.LinkRefDefinitionAttributes;
import org.eclipse.statet.docmlet.wikitext.core.source.RegexInlineWeaveParticipant;
import org.eclipse.statet.docmlet.wikitext.core.source.SourceTextBlockAttributes;
import org.eclipse.statet.docmlet.wikitext.core.source.WeaveParticipant;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.BasicTextRegion;
import org.eclipse.statet.jcommons.text.core.TextLineInformation;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.core.source.SourceContent;

public class WeaveLanguageProcessor
extends DocumentBuilder {
    private static final boolean DEBUGGING = false;
    private SourceContent orgContent;
    private final List<BlockWeaveParticipant> chunkParticipants = new ArrayList<BlockWeaveParticipant>();
    private final List<RegexInlineWeaveParticipant> inlineParticipants = new ArrayList<RegexInlineWeaveParticipant>();
    private Matcher inlineMatcher;
    private final List<Embedded> embeddedList = new ArrayList<Embedded>();
    private final EmbeddedIterator embeddedIterator = new EmbeddedIterator();
    private int maxOffset;
    private int lastOffset;
    private int[] endSpanFix = new int[16];
    private int endSpanFixIdx;
    private int ignoreCounter;
    private final ExplLocator orgLocator = new ExplLocator();
    private int flags;
    private DocumentBuilder builder;
    private boolean finished;
    private final StringBuilder sBuilder = new StringBuilder();

    public void clearConfig() {
        this.chunkParticipants.clear();
        this.inlineParticipants.clear();
        this.inlineMatcher = null;
    }

    public void addChunkParticipant(BlockWeaveParticipant participant) {
        if (participant == null) {
            throw new NullPointerException("participant");
        }
        this.chunkParticipants.add(participant);
    }

    public void addInlineParticipants(RegexInlineWeaveParticipant participant) {
        if (participant == null) {
            throw new NullPointerException("participant");
        }
        this.inlineParticipants.add(participant);
        this.inlineMatcher = null;
    }

    private Pattern combineInlineParticipants() {
        int n = this.inlineParticipants.size();
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            return this.inlineParticipants.get(0).getPattern();
        }
        this.sBuilder.setLength(0);
        int i = 0;
        while (i < n) {
            this.sBuilder.append("|(?:");
            this.sBuilder.append(this.inlineParticipants.get(i).getPattern().pattern());
            this.sBuilder.append(')');
            ++i;
        }
        return Pattern.compile(this.sBuilder.substring(1));
    }

    public String preprocess(SourceContent content, DocumentBuilder builder, int flags) {
        String checkedContent;
        this.orgContent = content;
        this.builder = builder;
        this.builder.setLocator((Locator)this.orgLocator);
        this.flags = flags;
        this.orgLocator.reset();
        this.finished = false;
        this.lastOffset = 0;
        this.endSpanFixIdx = -1;
        String source = content.getString();
        this.embeddedList.clear();
        int iPart = 0;
        while (iPart < this.chunkParticipants.size()) {
            this.chunkParticipants.get(iPart).reset(content);
            ++iPart;
        }
        iPart = 0;
        while (iPart < this.inlineParticipants.size()) {
            this.inlineParticipants.get(iPart).reset(content);
            ++iPart;
        }
        if (this.inlineMatcher == null) {
            Pattern pattern = this.combineInlineParticipants();
            if (pattern != null) {
                this.inlineMatcher = pattern.matcher(source);
            }
        } else {
            this.inlineMatcher.reset(source);
        }
        this.sBuilder.setLength(0);
        this.sBuilder.ensureCapacity(source.length() + 40);
        int endOffset = 0;
        TextLineInformation lines = content.getStringLines();
        int lineEndOffset = lines.getStartOffset(0);
        int numLines = lines.getNumberOfLines();
        int line = 0;
        while (line < numLines) {
            int lineOffset = lineEndOffset;
            lineEndOffset = lines.getEndOffset(line);
            int nPart = this.chunkParticipants.size();
            int iPart2 = 0;
            while (iPart2 < nPart) {
                BlockWeaveParticipant part = this.chunkParticipants.get(iPart2);
                if (part.checkStartLine(lineOffset, lineEndOffset)) {
                    this.append(source, endOffset, part.getStartOffset());
                    int checkedBeginOffset = this.sBuilder.length();
                    part.appendReplacement(this.sBuilder, source, part.getStartOffset(), lineEndOffset);
                    int checkedEndOffset = this.sBuilder.length();
                    endOffset = source.length();
                    while (++line < numLines) {
                        lineOffset = lineEndOffset;
                        if (!part.checkEndLine(lineOffset, lineEndOffset = lines.getEndOffset(line))) continue;
                        endOffset = lineEndOffset;
                        break;
                    }
                    this.embeddedList.add(new EmbeddedChunk(part, checkedBeginOffset, checkedEndOffset, part.getStartOffset(), endOffset));
                }
                ++iPart2;
            }
            ++line;
        }
        if (this.sBuilder.length() > 0 || this.inlineMatcher != null && this.inlineMatcher.find()) {
            this.append(source, endOffset, source.length());
            checkedContent = this.sBuilder.toString();
        } else {
            checkedContent = source;
        }
        this.embeddedIterator.reset();
        this.ignoreCounter = 0;
        this.maxOffset = checkedContent.length();
        return checkedContent;
    }

    private void append(String source, int begin, int end) {
        if (begin < end) {
            int shift = begin - this.sBuilder.length();
            int offset = begin;
            Matcher matcher = this.inlineMatcher;
            if (matcher != null) {
                matcher.region(begin, end);
                int nPart = this.inlineParticipants.size();
                block0: while (matcher.find()) {
                    int length;
                    int matchStart = matcher.start();
                    if (offset < matchStart) {
                        this.sBuilder.append(source, offset, matchStart);
                    }
                    if ((length = (offset = matcher.end()) - matchStart) > 0) {
                        this.sBuilder.append('\ufffc');
                        --length;
                        while (length > 0) {
                            int l = Math.min(length, 40);
                            this.sBuilder.append(WeaveParticipant.REPLACEMENT_STRING, 0, l);
                            length -= l;
                        }
                    }
                    int iPart = 0;
                    while (iPart < nPart) {
                        int groupNum = iPart + 1;
                        if (matcher.start(groupNum) >= 0) {
                            this.embeddedList.add(new EmbeddedInline(this.inlineParticipants.get(iPart), matchStart - shift, offset - shift, matcher.start(groupNum), matcher.end(groupNum)));
                            continue block0;
                        }
                        ++iPart;
                    }
                }
            }
            this.sBuilder.append(source, offset, end);
        }
    }

    public void clear() {
        this.orgContent = null;
        int iPart = 0;
        while (iPart < this.chunkParticipants.size()) {
            this.chunkParticipants.get(iPart).reset(null);
            ++iPart;
        }
        iPart = 0;
        while (iPart < this.inlineParticipants.size()) {
            this.inlineParticipants.get(iPart).reset(null);
            ++iPart;
        }
        this.builder = null;
    }

    /*
     * Unable to fully structure code
     */
    private void processEmbedded(int toOffset) {
        if (toOffset >= this.lastOffset) ** GOTO lbl10
        return;
lbl-1000:
        // 1 sources

        {
            embedded = this.embeddedIterator.getNext();
            if (embedded instanceof EmbeddedChunk) {
                this.sendChunk((EmbeddedChunk)embedded);
            } else {
                this.sendInline((EmbeddedInline)embedded);
            }
            this.lastOffset = embedded.getEndOffset();
            this.embeddedIterator.consume();
lbl10:
            // 2 sources

            ** while (this.embeddedIterator.hasNext((int)toOffset))
        }
lbl11:
        // 1 sources

    }

    private void sendChunk(EmbeddedChunk chunk) {
        BlockWeaveParticipant part = chunk.getParticipant();
        this.orgLocator.setTo(chunk.getBeginOffset());
        this.builder.beginBlock(DocumentBuilder.BlockType.CODE, (Attributes)new EmbeddingAttributes(part.getForeignTypeId(), chunk.getEmbedDescr(), (TextRegion)new BasicTextRegion(chunk.getOrgBeginOffset(), chunk.getOrgEndOffset())));
        this.orgLocator.setShift(chunk.getShift());
        this.orgLocator.setTo(chunk.getEndOffset());
        this.builder.endBlock();
    }

    private void sendInline(EmbeddedInline inline) {
        if ((this.flags & 0x20) != 0) {
            RegexInlineWeaveParticipant part = inline.getParticipant();
            this.orgLocator.setTo(inline.getBeginOffset(), inline.getEndOffset());
            this.builder.beginSpan(DocumentBuilder.SpanType.CODE, (Attributes)new EmbeddingAttributes(((WeaveParticipant)part).getForeignTypeId(), inline.getEmbedDescr(), (TextRegion)new BasicTextRegion(inline.getContentBeginOffset(), inline.getContentEndOffset())));
            this.orgLocator.setTo(inline.getEndOffset());
            this.builder.endSpan();
        }
    }

    private int getSegmentBeginOffset() {
        return Math.min(this.locator.getLineDocumentOffset() + this.locator.getLineCharacterOffset(), this.maxOffset);
    }

    private int getSegmentEndOffset() {
        return Math.min(this.locator.getLineDocumentOffset() + this.locator.getLineSegmentEndOffset(), this.maxOffset);
    }

    private LabelInfo updateOffsets(LabelInfo labelInfo) {
        if (labelInfo == null) {
            return null;
        }
        return new LabelInfo(labelInfo.getLabel(), this.orgLocator.computeOffset(labelInfo.getStartOffset()), this.orgLocator.computeOffset(labelInfo.getEndOffset()));
    }

    private ImList<TextRegion> updateOffsets(List<? extends TextRegion> regions) {
        if (regions == null) {
            return null;
        }
        EmbeddedChunkIterator embeddedIter = new EmbeddedChunkIterator(this.embeddedIterator);
        int shift = this.orgLocator.shift;
        int last = this.lastOffset;
        Object[] updated = new TextRegion[regions.size()];
        int i = 0;
        for (TextRegion textRegion : regions) {
            int endOffset;
            int l;
            int offset = textRegion.getStartOffset();
            while (embeddedIter.hasNext(offset)) {
                shift = embeddedIter.getNext().getShift();
                last = embeddedIter.getNext().getEndOffset();
                embeddedIter.consume();
            }
            if (offset < last) {
                offset = last;
            }
            int beginOffset = shift + offset;
            offset = textRegion.getEndOffset();
            if (embeddedIter.hasNext(offset) || (l = (endOffset = shift + offset) - beginOffset) <= 0 && (l != 0 || textRegion.getLength() != 0)) continue;
            updated[i++] = new BasicTextRegion(beginOffset, endOffset);
        }
        return ImCollections.newList((Object[])updated, (int)0, (int)i);
    }

    public void beginDocument() {
        this.orgLocator.setTo(0);
        this.builder.beginDocument();
    }

    public void endDocument() {
        int endOffset;
        this.finished = true;
        this.processEmbedded(Integer.MAX_VALUE);
        this.lastOffset = endOffset = this.locator.getDocumentOffset();
        this.orgLocator.setTo(endOffset);
        this.builder.endDocument();
    }

    public void finish() {
        if (!this.finished) {
            this.finished = true;
            this.processEmbedded(Integer.MAX_VALUE);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void beginBlock(DocumentBuilder.BlockType type, Attributes attributes) {
        int beginOffset = this.locator.getDocumentOffset();
        this.processEmbedded(beginOffset);
        if (beginOffset < this.lastOffset) {
            ++this.ignoreCounter;
            return;
        }
        this.lastOffset = beginOffset;
        this.orgLocator.setTo(beginOffset);
        Attributes attributes2 = attributes;
        if (attributes2 instanceof SourceTextBlockAttributes) {
            void textBlockAttributes;
            SourceTextBlockAttributes sourceTextBlockAttributes = (SourceTextBlockAttributes)attributes2;
            SourceTextBlockAttributes cfr_ignored_0 = (SourceTextBlockAttributes)attributes2;
            textBlockAttributes.setTextRegions(this.updateOffsets((List<? extends TextRegion>)textBlockAttributes.getTextRegions()));
        }
        this.builder.beginBlock(type, attributes);
    }

    public void endBlock() {
        if (this.ignoreCounter > 0) {
            --this.ignoreCounter;
            return;
        }
        int endOffset = this.locator.getLineDocumentOffset();
        this.processEmbedded(endOffset);
        if (endOffset > this.lastOffset) {
            this.lastOffset = endOffset;
        }
        this.orgLocator.setTo(this.lastOffset);
        this.builder.endBlock();
    }

    public void beginSpan(DocumentBuilder.SpanType type, Attributes attributes) {
        if ((this.flags & 0x10) == 0) {
            return;
        }
        int beginOffset = this.getSegmentBeginOffset();
        int endOffset = this.getSegmentEndOffset();
        this.processEmbedded(beginOffset);
        if (beginOffset < this.lastOffset) {
            ++this.ignoreCounter;
            return;
        }
        if (++this.endSpanFixIdx >= this.endSpanFix.length) {
            this.endSpanFix = Arrays.copyOf(this.endSpanFix, this.endSpanFix.length + 16);
        }
        this.endSpanFix[this.endSpanFixIdx] = endOffset;
        this.lastOffset = beginOffset;
        this.orgLocator.setTo(beginOffset, endOffset);
        this.builder.beginSpan(type, attributes);
    }

    public void endSpan() {
        if ((this.flags & 0x10) == 0) {
            return;
        }
        if (this.ignoreCounter > 0) {
            --this.ignoreCounter;
            return;
        }
        int endOffset = Math.max(this.getSegmentEndOffset(), this.endSpanFix[this.endSpanFixIdx--]);
        this.processEmbedded(endOffset);
        if (endOffset > this.lastOffset) {
            this.lastOffset = endOffset;
        }
        this.orgLocator.setTo(this.lastOffset);
        this.builder.endSpan();
    }

    public void beginHeading(int level, Attributes attributes) {
        int beginOffset = this.locator.getDocumentOffset();
        this.processEmbedded(beginOffset);
        if (beginOffset < this.lastOffset) {
            ++this.ignoreCounter;
            return;
        }
        this.lastOffset = beginOffset;
        this.orgLocator.setTo(beginOffset);
        this.builder.beginHeading(level, attributes);
    }

    public void endHeading() {
        if (this.ignoreCounter > 0) {
            --this.ignoreCounter;
            return;
        }
        int endOffset = this.locator.getLineDocumentOffset();
        this.processEmbedded(endOffset);
        if (endOffset > this.lastOffset) {
            this.lastOffset = endOffset;
        }
        this.orgLocator.setTo(this.lastOffset);
        this.builder.endHeading();
    }

    public void characters(String text) {
        if ((this.flags & 0x10) == 0) {
            return;
        }
        int offset = this.locator.getDocumentOffset();
        int endOffset = this.getSegmentEndOffset();
        int lastIdx = 0;
        while (this.embeddedIterator.hasNext(endOffset)) {
            int textIdx;
            Embedded embedded = this.embeddedIterator.getNext();
            int n = textIdx = lastIdx < text.length() ? text.indexOf(65532, lastIdx) : -1;
            if (textIdx < 0 || embedded.getTextLength() <= 0) {
                endOffset = this.embeddedIterator.getNextOffset();
                lastIdx = text.length();
                break;
            }
            this.orgLocator.setTo(offset, embedded.getBeginOffset());
            this.builder.characters(text.substring(lastIdx, textIdx));
            lastIdx = textIdx + embedded.getTextLength();
            if (embedded instanceof EmbeddedChunk) {
                this.sendChunk((EmbeddedChunk)embedded);
            } else {
                this.sendInline((EmbeddedInline)embedded);
            }
            this.lastOffset = offset = embedded.getEndOffset();
            this.embeddedIterator.consume();
        }
        if (offset < endOffset && lastIdx < text.length()) {
            this.lastOffset = endOffset;
            this.orgLocator.setTo(offset, endOffset);
            this.builder.characters(text.substring(lastIdx, text.length()));
        }
    }

    public void entityReference(String entity) {
        int endOffset;
        if ((this.flags & 0x10) == 0) {
            return;
        }
        int beginOffset = this.getSegmentBeginOffset();
        if (beginOffset >= (endOffset = this.getSegmentEndOffset())) {
            return;
        }
        this.processEmbedded(endOffset);
        if (beginOffset > this.lastOffset) {
            return;
        }
        this.orgLocator.setTo(beginOffset, endOffset);
        this.builder.entityReference(entity);
    }

    /*
     * WARNING - void declaration
     */
    public void image(Attributes attributes, String url) {
        int endOffset;
        if ((this.flags & 0x10) == 0) {
            return;
        }
        int beginOffset = this.getSegmentBeginOffset();
        if (beginOffset >= (endOffset = this.getSegmentEndOffset())) {
            return;
        }
        this.processEmbedded(endOffset);
        if (beginOffset > this.lastOffset) {
            return;
        }
        Attributes attributes2 = attributes;
        if (attributes2 instanceof ImageByRefAttributes) {
            void refAttributes;
            ImageByRefAttributes imageByRefAttributes = (ImageByRefAttributes)attributes2;
            ImageByRefAttributes cfr_ignored_0 = (ImageByRefAttributes)attributes2;
            refAttributes.setReferenceLabel(this.updateOffsets(refAttributes.getReferenceLabel()));
        }
        this.orgLocator.setTo(beginOffset, endOffset);
        this.builder.image(attributes, url);
    }

    /*
     * WARNING - void declaration
     */
    public void link(Attributes attributes, String hrefOrHashName, String text) {
        int endOffset;
        if ((this.flags & 0x10) == 0) {
            return;
        }
        int beginOffset = this.getSegmentBeginOffset();
        if (beginOffset >= (endOffset = this.getSegmentEndOffset())) {
            return;
        }
        this.processEmbedded(endOffset);
        if (beginOffset < this.lastOffset) {
            return;
        }
        Attributes attributes2 = attributes;
        if (attributes2 instanceof LinkRefDefinitionAttributes) {
            void refAttributes;
            LinkRefDefinitionAttributes linkRefDefinitionAttributes = (LinkRefDefinitionAttributes)attributes2;
            LinkRefDefinitionAttributes cfr_ignored_0 = (LinkRefDefinitionAttributes)attributes2;
            refAttributes.setReferenceLabel(this.updateOffsets(refAttributes.getReferenceLabel()));
        } else {
            Attributes attributes3 = attributes;
            if (attributes3 instanceof LinkByRefAttributes) {
                void refAttributes;
                LinkByRefAttributes linkByRefAttributes = (LinkByRefAttributes)attributes3;
                LinkByRefAttributes cfr_ignored_1 = (LinkByRefAttributes)attributes3;
                refAttributes.setReferenceLabel(this.updateOffsets(refAttributes.getReferenceLabel()));
            }
        }
        this.lastOffset = endOffset;
        this.orgLocator.setTo(beginOffset, endOffset);
        this.builder.link(attributes, hrefOrHashName, text);
    }

    public void imageLink(Attributes linkAttributes, Attributes imageAttributes, String href, String imageUrl) {
        int endOffset;
        if ((this.flags & 0x10) == 0) {
            return;
        }
        int beginOffset = this.getSegmentBeginOffset();
        if (beginOffset >= (endOffset = this.getSegmentEndOffset())) {
            return;
        }
        this.processEmbedded(endOffset);
        if (beginOffset < this.lastOffset) {
            return;
        }
        this.lastOffset = endOffset;
        this.orgLocator.setTo(beginOffset, endOffset);
        this.builder.imageLink(linkAttributes, imageAttributes, href, imageUrl);
    }

    public void acronym(String text, String definition) {
        int endOffset;
        if ((this.flags & 0x10) == 0) {
            return;
        }
        int beginOffset = this.getSegmentBeginOffset();
        if (beginOffset >= (endOffset = this.getSegmentEndOffset())) {
            return;
        }
        this.processEmbedded(endOffset);
        if (beginOffset < this.lastOffset) {
            return;
        }
        this.lastOffset = endOffset;
        this.orgLocator.setTo(beginOffset, endOffset);
        this.builder.acronym(text, definition);
    }

    public void lineBreak() {
        if ((this.flags & 0x10) == 0) {
            return;
        }
        int beginOffset = this.locator.getDocumentOffset();
        this.orgLocator.setTo(beginOffset);
        this.builder.lineBreak();
    }

    public void charactersUnescaped(String literal) {
        int endOffset;
        if ((this.flags & 0x10) == 0) {
            return;
        }
        int beginOffset = this.getSegmentBeginOffset();
        if (beginOffset >= (endOffset = this.getSegmentEndOffset())) {
            return;
        }
        this.processEmbedded(endOffset);
        if (beginOffset < this.lastOffset) {
            return;
        }
        this.lastOffset = endOffset;
        this.orgLocator.setTo(beginOffset, endOffset);
        this.builder.charactersUnescaped(literal);
    }

    private static abstract class Embedded {
        private final int startOffset;
        private final int endOffset;
        private final int embedDescr;

        public Embedded(int startOffset, int endOffset, int embedDescr) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.embedDescr = embedDescr;
        }

        public abstract WeaveParticipant getParticipant();

        public final int getEmbedDescr() {
            return this.embedDescr;
        }

        public final int getBeginOffset() {
            return this.startOffset;
        }

        public final int getEndOffset() {
            return this.endOffset;
        }

        public final int getLength() {
            return this.endOffset - this.startOffset;
        }

        public abstract int getOrgLength();

        public abstract int getTextLength();
    }

    private static final class EmbeddedChunk
    extends Embedded {
        private final BlockWeaveParticipant participant;
        private final int orgStartOffset;
        private final int orgEndOffset;

        public EmbeddedChunk(BlockWeaveParticipant participant, int beginOffset, int endOffset, int orgBeginOffset, int orgEndOffset) {
            super(beginOffset, endOffset, participant.getEmbedDescr());
            this.participant = participant;
            this.orgStartOffset = orgBeginOffset;
            this.orgEndOffset = orgEndOffset;
        }

        @Override
        public BlockWeaveParticipant getParticipant() {
            return this.participant;
        }

        public int getShift() {
            return this.orgEndOffset - this.getEndOffset();
        }

        public int getOrgBeginOffset() {
            return this.orgStartOffset;
        }

        public int getOrgEndOffset() {
            return this.orgEndOffset;
        }

        @Override
        public int getOrgLength() {
            return this.orgEndOffset - this.orgStartOffset;
        }

        @Override
        public int getTextLength() {
            return this.getParticipant().getTextLength();
        }
    }

    private class EmbeddedChunkIterator
    extends EmbeddedIterator {
        public EmbeddedChunkIterator(EmbeddedIterator iter0) {
            super(iter0);
            this.consumeToChunk();
        }

        @Override
        public EmbeddedChunk getNext() {
            return (EmbeddedChunk)super.getNext();
        }

        @Override
        public void consume() {
            super.consume();
            this.consumeToChunk();
        }

        @Override
        public void consumeTo(int offset) {
            super.consumeTo(offset);
            this.consumeToChunk();
        }
    }

    private static final class EmbeddedInline
    extends Embedded {
        private final RegexInlineWeaveParticipant participant;
        private final int contentStartOffset;
        private final int contentEndOffset;

        public EmbeddedInline(RegexInlineWeaveParticipant participant, int beginOffset, int endOffset, int contentStartOffset, int contentEndOffset) {
            super(beginOffset, endOffset, participant.getEmbedDescr());
            this.participant = participant;
            this.contentStartOffset = contentStartOffset;
            this.contentEndOffset = contentEndOffset;
        }

        @Override
        public RegexInlineWeaveParticipant getParticipant() {
            return this.participant;
        }

        public int getContentBeginOffset() {
            return this.contentStartOffset;
        }

        public int getContentEndOffset() {
            return this.contentEndOffset;
        }

        @Override
        public int getOrgLength() {
            return this.getLength();
        }

        @Override
        public int getTextLength() {
            return this.getLength();
        }
    }

    private class EmbeddedIterator {
        private int nextIdx;
        private Embedded nextObject;
        private int nextOffset;

        public EmbeddedIterator() {
            this.reset();
        }

        public EmbeddedIterator(EmbeddedIterator iter0) {
            this.updateNext(iter0.nextIdx);
        }

        public void reset() {
            this.updateNext(0);
        }

        private void updateNext(int idx) {
            int total = WeaveLanguageProcessor.this.embeddedList.size();
            if (idx < total) {
                this.nextIdx = idx;
                this.nextObject = WeaveLanguageProcessor.this.embeddedList.get(idx);
                this.nextOffset = this.nextObject.getBeginOffset();
            } else {
                this.nextIdx = total;
                this.nextObject = null;
                this.nextOffset = Integer.MAX_VALUE;
            }
        }

        public final int getNextOffset() {
            return this.nextOffset;
        }

        public @Nullable Embedded getNext() {
            return this.nextObject;
        }

        public final boolean hasNext(int offset) {
            return offset > this.nextOffset;
        }

        public void consume() {
            this.updateNext(this.nextIdx + 1);
        }

        public void consumeTo(int offset) {
            while (offset > this.nextOffset && offset > this.nextObject.getEndOffset()) {
                this.updateNext(this.nextIdx + 1);
            }
        }

        public void consumeToChunk() {
            while (this.nextObject != null && !(this.nextObject instanceof EmbeddedChunk)) {
                this.updateNext(this.nextIdx + 1);
            }
        }
    }

    private final class ExplLocator
    implements Locator,
    WikitextLocator {
        private int lineNumber;
        private int shift;
        private int beginOffset;
        private int endOffset;

        public void setShift(int offset) {
            this.shift = offset;
        }

        private void setOffset(int offset) {
            if (this.beginOffset != offset) {
                this.beginOffset = offset;
                this.lineNumber = -1;
            }
            this.endOffset = offset;
        }

        public int computeOffset(int offset) {
            return this.shift + offset;
        }

        public void setTo(int beginOffset) {
            this.setOffset(this.computeOffset(beginOffset));
        }

        public void setTo(int beginOffset, int endOffset) {
            this.setOffset(this.computeOffset(beginOffset));
            if (endOffset > beginOffset) {
                this.endOffset = this.computeOffset(endOffset);
            }
        }

        public void reset() {
            this.shift = 0;
            this.beginOffset = 0;
            this.endOffset = 0;
            this.lineNumber = -1;
        }

        @Override
        public int getLineNumber() {
            if (this.lineNumber < 0) {
                TextLineInformation lines = WeaveLanguageProcessor.this.orgContent.getStringLines();
                this.lineNumber = lines.getLineOfOffset(this.beginOffset);
            }
            return this.lineNumber;
        }

        private TextLineInformation getLines() {
            TextLineInformation lines = WeaveLanguageProcessor.this.orgContent.getStringLines();
            if (this.lineNumber < 0) {
                this.lineNumber = lines.getLineOfOffset(this.beginOffset);
            }
            return lines;
        }

        @Override
        public int getLineOffset() {
            return this.getLines().getStartOffset(this.lineNumber);
        }

        public int getLineDocumentOffset() {
            return this.getLineOffset();
        }

        @Override
        public int getLineLength() {
            return this.getLines().getLength(this.lineNumber);
        }

        public int getLineEndOffset() {
            return this.getLines().getEndOffset(this.lineNumber);
        }

        public int getDocumentOffset() {
            return this.beginOffset;
        }

        @Override
        public int getBeginOffset() {
            return this.beginOffset;
        }

        public int getLineCharacterOffset() {
            return this.beginOffset - this.getLineOffset();
        }

        @Override
        public int getEndOffset() {
            return this.endOffset;
        }

        public int getLineSegmentEndOffset() {
            return this.endOffset - this.getLineOffset();
        }
    }
}

