/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.nico;

import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.statet.ecommons.text.TextUtil;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.r.nico.IRSrcref;

public class RSrcref
implements IRSrcref {
    private final int fFirstLine;
    private final int fFirstColumn;
    private final int fLastLine;
    private final int fLastColumn;

    public static int getOffset(AbstractDocument document, int line, int column) throws BadLocationException {
        int currentColumn = 0;
        int currentOffset = document.getLineOffset(line);
        int l = document.getLength();
        while (currentColumn < column) {
            if (currentOffset >= l) {
                return -1;
            }
            char c = document.getChar(currentOffset++);
            switch (c) {
                case '\n': 
                case '\r': {
                    return -1;
                }
                case '\t': {
                    currentColumn += 8 - currentColumn % 8;
                    break;
                }
                default: {
                    ++currentColumn;
                }
            }
        }
        return currentOffset;
    }

    public RSrcref(int beginLine, int beginColumn, int endLine, int endColumn) {
        this.fFirstLine = beginLine;
        this.fFirstColumn = beginColumn;
        this.fLastLine = endLine;
        this.fLastColumn = endColumn;
    }

    public RSrcref(IDocument document, TextRegion region) throws BadLocationException {
        this.fFirstLine = document.getLineOfOffset(region.getStartOffset());
        this.fFirstColumn = TextUtil.getColumn((IDocument)document, (int)region.getStartOffset(), (int)this.fFirstLine, (int)8);
        this.fLastLine = document.getLineOfOffset(region.getEndOffset());
        this.fLastColumn = TextUtil.getColumn((IDocument)document, (int)(region.getEndOffset() - 1), (int)this.fLastLine, (int)8);
    }

    @Override
    public boolean hasBeginDetail() {
        return this.fFirstLine >= 0 && this.fFirstColumn >= 0;
    }

    @Override
    public int getFirstLine() {
        return this.fFirstLine;
    }

    @Override
    public int getFirstColumn() {
        return this.fFirstColumn;
    }

    @Override
    public boolean hasEndDetail() {
        return this.fLastLine >= 0 && this.fLastColumn >= 0;
    }

    @Override
    public int getLastLine() {
        return this.fLastLine;
    }

    @Override
    public int getLastColumn() {
        return this.fLastColumn;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append("\n\t").append("firstChar= ").append("in line ").append(this.fFirstLine >= 0 ? Integer.valueOf(this.fFirstLine) : "NA").append(" at column ").append(this.fFirstColumn >= 0 ? Integer.valueOf(this.fFirstColumn) : "NA");
        sb.append("\n\t").append("lastChar= ").append("in line ").append(this.fLastLine >= 0 ? Integer.valueOf(this.fLastLine) : "NA").append(" at column ").append(this.fLastColumn >= 0 ? Integer.valueOf(this.fLastColumn) : "NA");
        return sb.toString();
    }
}

