/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.yaml.core.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.statet.dsl.core.model.DslElementName;
import org.eclipse.statet.dsl.core.source.ast.DslAstNode;
import org.eclipse.statet.dsl.core.source.ast.KeyValuePair;
import org.eclipse.statet.dsl.core.source.ast.NodeType;
import org.eclipse.statet.dsl.core.source.ast.PropertiesContainer;
import org.eclipse.statet.dsl.core.source.ast.SeqEntry;
import org.eclipse.statet.dsl.core.source.ast.SourceComponent;
import org.eclipse.statet.internal.yaml.core.model.BasicYamlSourceElement;
import org.eclipse.statet.internal.yaml.core.model.CompositeSourceElement;
import org.eclipse.statet.internal.yaml.core.model.ContainerSourceElement;
import org.eclipse.statet.internal.yaml.core.model.ElementNameCreator;
import org.eclipse.statet.internal.yaml.core.model.TermElement;
import org.eclipse.statet.internal.yaml.core.model.YamlSourceUnitModelInfoImpl;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIdentityList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ast.core.AstInfo;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.yaml.core.model.YamlChunkElement;
import org.eclipse.statet.yaml.core.model.YamlSourceElement;
import org.eclipse.statet.yaml.core.model.YamlSourceUnitModelInfo;
import org.eclipse.statet.yaml.core.source.ast.YamlDocument;

@NonNullByDefault
public class SourceAnalyzer {
    private SourceUnit sourceUnit = (SourceUnit)ObjectUtils.nonNullLateInit();
    private AstInfo ast = (AstInfo)ObjectUtils.nonNullLateInit();
    private @Nullable List<YamlChunkElement> chunkElements;
    private final ElementNameCreator nameCreator = new ElementNameCreator();
    private final List<ArrayList<YamlSourceElement>> containerBuilderStack = new ArrayList<ArrayList<YamlSourceElement>>();
    private int depth = -1;

    /*
     * Unable to fully structure code
     */
    public YamlSourceUnitModelInfoImpl createModel(SourceUnit sourceUnit, AstInfo ast) {
        try {
            this.sourceUnit = sourceUnit;
            this.ast = ast;
            rootNode = (SourceComponent)ast.getRoot();
            element = new ContainerSourceElement.SourceContainer(this.sourceUnit, ast.getStamp(), (DslAstNode)rootNode);
            this.processSourceLines(element, rootNode);
            var7_6 = modelInfo = new YamlSourceUnitModelInfoImpl(ast, element);
            ** while (this.depth >= 0)
        }
        catch (Throwable var6_7) {
            ** while (this.depth >= 0)
        }
lbl-1000:
        // 1 sources

        {
            this.containerBuilderStack.get(this.depth--).clear();
            continue;
        }
lbl11:
        // 1 sources

        return var7_6;
lbl-1000:
        // 1 sources

        {
            this.containerBuilderStack.get(this.depth--).clear();
            continue;
        }
lbl16:
        // 1 sources

        throw var6_7;
    }

    public void beginChunkSession(SourceUnit sourceUnit, AstInfo ast) {
        this.sourceUnit = sourceUnit;
        this.ast = ast;
        if (this.chunkElements == null) {
            this.chunkElements = new ArrayList<YamlChunkElement>();
        }
    }

    public void processChunk(YamlChunkElement element, SourceComponent sourceComponent) {
        List chunkElements = (List)ObjectUtils.nonNullAssert(this.chunkElements);
        chunkElements.add(element);
        this.processSourceLines(element, sourceComponent);
    }

    public YamlSourceUnitModelInfo stopChunkSession() {
        List chunkElements = (List)ObjectUtils.nonNullAssert(this.chunkElements);
        try {
            CompositeSourceElement compositeElement = new CompositeSourceElement(this.sourceUnit, this.ast.getStamp(), chunkElements, (TextRegion)this.ast.getRoot());
            YamlSourceUnitModelInfoImpl yamlSourceUnitModelInfoImpl = new YamlSourceUnitModelInfoImpl(this.ast, compositeElement);
            return yamlSourceUnitModelInfoImpl;
        }
        finally {
            this.sourceUnit = null;
            chunkElements.clear();
        }
    }

    private List<YamlSourceElement> enter(ContainerSourceElement element) {
        ArrayList<YamlSourceElement> containerBuilder;
        int depth;
        if ((depth = ++this.depth) < this.containerBuilderStack.size()) {
            containerBuilder = this.containerBuilderStack.get(depth);
        } else {
            containerBuilder = new ArrayList();
            this.containerBuilderStack.add(containerBuilder);
        }
        return containerBuilder;
    }

    private void exit(ContainerSourceElement element, List<YamlSourceElement> builder) {
        element.children = ImCollections.concatList(element.children, builder);
        builder.clear();
        --this.depth;
    }

    private void processSourceLines(ContainerSourceElement element, SourceComponent sourceComponent) {
        List<YamlSourceElement> builder = this.enter(element);
        int docCount = element.children.size();
        int childIndex = 0;
        while (childIndex < sourceComponent.getChildCount()) {
            DslAstNode childNode = sourceComponent.getChild(childIndex);
            if (childNode instanceof YamlDocument) {
                BasicYamlSourceElement childElement = this.createDocumentElement(element, (YamlDocument)childNode);
                childElement.occurrenceCount = docCount++;
                childElement.name = DslElementName.create((int)81, (String)Integer.toString(childElement.occurrenceCount + 1));
                builder.add(childElement);
            }
            ++childIndex;
        }
        this.exit(element, builder);
    }

    private BasicYamlSourceElement createDocumentElement(ContainerSourceElement parent, YamlDocument node) {
        ContainerSourceElement.CollectionContainer element = new ContainerSourceElement.CollectionContainer(1040, parent, (DslAstNode)node, (DslAstNode)node);
        List<YamlSourceElement> builder = this.enter(element);
        ImIdentityList<DslAstNode> contentNodes = node.getContentNodes();
        int childIndex = 0;
        while (childIndex < contentNodes.size()) {
            DslAstNode childNode = (DslAstNode)contentNodes.get(childIndex);
            BasicYamlSourceElement childElement = this.createContentElement(parent, childNode);
            childElement.occurrenceCount = childIndex++;
            childElement.name = DslElementName.create((int)15, (String)"");
            builder.add(childElement);
        }
        this.exit(element, builder);
        return element;
    }

    /*
     * WARNING - void declaration
     */
    private BasicYamlSourceElement createContentElement(ContainerSourceElement parent, DslAstNode node) {
        DslAstNode contentNode = node;
        switch (node.getNodeType()) {
            case SEQ_ENTRY: {
                if (node.getDslParent().getNodeType() != NodeType.SEQ) break;
                contentNode = ((SeqEntry)node).getValue();
                break;
            }
            case KEY_VALUE_ENTRY: {
                if (node.getDslParent().getNodeType() != NodeType.MAP) break;
                contentNode = ((KeyValuePair)node).getValue();
                break;
            }
        }
        if (contentNode.getNodeType() == NodeType.PROPERTIES_CONTAINER) {
            contentNode = ((PropertiesContainer)contentNode).getNode();
        }
        switch (contentNode.getNodeType()) {
            case SEQ: {
                ContainerSourceElement.CollectionContainer element = new ContainerSourceElement.CollectionContainer(2560, parent, node, contentNode);
                if (this.depth <= 2 || this.hasNonScalarChild(contentNode)) {
                    List<YamlSourceElement> builder = this.enter(element);
                    int childIndex = 0;
                    while (childIndex < contentNode.getChildCount()) {
                        BasicYamlSourceElement childElement;
                        DslAstNode childNode = contentNode.getChild(childIndex);
                        if (childNode instanceof KeyValuePair) {
                            childElement = this.createContentElement(element, childNode);
                            childElement.name = this.nameCreator.createSeqEntry(childIndex);
                        } else {
                            childElement = this.createContentElement(element, childNode);
                            childElement.name = this.nameCreator.createSeqEntry(childIndex);
                        }
                        builder.add(childElement);
                        ++childIndex;
                    }
                    this.exit(element, builder);
                }
                return element;
            }
            case MAP: {
                ContainerSourceElement.CollectionContainer element = new ContainerSourceElement.CollectionContainer(2576, parent, node, contentNode);
                List<YamlSourceElement> builder = this.enter(element);
                int childIndex = 0;
                while (childIndex < contentNode.getChildCount()) {
                    BasicYamlSourceElement childElement;
                    DslAstNode childNode = contentNode.getChild(childIndex);
                    DslAstNode dslAstNode = childNode;
                    if (dslAstNode instanceof KeyValuePair) {
                        void entry;
                        KeyValuePair cfr_ignored_0 = (KeyValuePair)dslAstNode;
                        KeyValuePair cfr_ignored_1 = (KeyValuePair)dslAstNode;
                        childElement = this.createContentElement(element, childNode);
                        childElement.name = this.nameCreator.createMapKey(entry.getKey());
                        childElement.nameRegion = entry.getKey();
                    } else {
                        childElement = this.createContentElement(element, childNode);
                        childElement.name = this.nameCreator.createMapKey(null);
                    }
                    builder.add(childElement);
                    ++childIndex;
                }
                this.exit(element, builder);
                return element;
            }
            case SCALAR: {
                return new TermElement(2816, parent, node);
            }
            case ALIAS: {
                return new TermElement(3584, parent, node);
            }
            case ERROR: {
                return new TermElement(3840, parent, node);
            }
        }
        return new TermElement(0, parent, node);
    }

    private boolean hasNonScalarChild(DslAstNode node) {
        int childIndex = 0;
        while (childIndex < node.getChildCount()) {
            DslAstNode child = node.getChild(childIndex);
            switch (child.getNodeType()) {
                case PROPERTIES_CONTAINER: 
                case MAP: {
                    return true;
                }
                case SEQ: 
                case SEQ_ENTRY: 
                case KEY_VALUE_ENTRY: {
                    if (!this.hasNonScalarChild(child)) break;
                    return true;
                }
            }
            ++childIndex;
        }
        return false;
    }
}

