/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.ui.workbench.WorkbenchUIUtils;
import org.eclipse.statet.internal.ltk.ui.EditingMessages;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.model.core.ElementSet;
import org.eclipse.statet.ltk.model.core.element.SourceStructElement;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorAssociated;
import org.eclipse.statet.ltk.ui.util.LTKSelectionUtils;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

@NonNullByDefault
public abstract class AbstractSourceDocumentHandler<TSourceUnit extends SourceUnit>
extends AbstractHandler {
    protected static final byte DIRECT = 0;
    protected static final byte SHOW_BUSY = 1;
    protected static final byte BACKGROUND = 2;

    protected abstract String getTaskLabel();

    protected abstract boolean isEditTask();

    public void setEnabled(@Nullable Object evaluationContext) {
        IWorkbenchPart activePart = WorkbenchUIUtils.getActivePart((Object)evaluationContext);
        ISelection selection = WorkbenchUIUtils.getCurrentSelection((Object)evaluationContext);
        if (activePart == null) {
            return;
        }
        SourceEditor sourceEditor = this.getSourceEditor(activePart);
        if (sourceEditor != null && selection instanceof ITextSelection) {
            SourceUnit sourceUnit = sourceEditor.getSourceUnit();
            this.setBaseEnabled(sourceUnit != null && (!this.isEditTask() || sourceEditor.isEditable(false)));
            return;
        }
        if (selection instanceof IStructuredSelection) {
            SourceStructElement[] selectedElements = LTKSelectionUtils.getSelectedSourceStructElements((IStructuredSelection)selection);
            this.setBaseEnabled(selectedElements != null && selectedElements.length > 0 && this.checkSourceUnits(selectedElements));
            return;
        }
        this.setBaseEnabled(false);
    }

    public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
        NullProgressMonitor monitor;
        SourceEditor sourceEditor;
        ISelection selection;
        IWorkbenchPart activePart;
        block7: {
            activePart = WorkbenchUIUtils.getActivePart((Object)event.getApplicationContext());
            selection = WorkbenchUIUtils.getCurrentSelection((Object)event.getApplicationContext());
            if (activePart == null) {
                return null;
            }
            sourceEditor = this.getSourceEditor(activePart);
            try {
                ExecData data;
                monitor = new NullProgressMonitor();
                if (sourceEditor == null || !(selection instanceof ITextSelection)) break block7;
                SourceUnit sourceUnit = sourceEditor.getSourceUnit();
                if (sourceUnit != null && this.isSourceUnitSupported(sourceUnit) && (!this.isEditTask() || sourceEditor.isEditable(true)) && (data = this.createExecData(event, activePart, sourceEditor, ImCollections.newList((Object)sourceUnit), (ITextSelection)selection, null, (IProgressMonitor)monitor)) != null) {
                    this.execute(data);
                    return null;
                }
                return null;
            }
            catch (Exception e) {
                throw new ExecutionException(NLS.bind((String)EditingMessages.GenericAction_error_message, (Object)this.getTaskLabel()), (Throwable)e);
            }
        }
        if (selection instanceof IStructuredSelection) {
            ExecData data;
            ImList<TSourceUnit> sourceUnits;
            Object[] selectedElements = LTKSelectionUtils.getSelectedSourceStructElements((IStructuredSelection)selection);
            if (selectedElements != null && selectedElements.length > 0 && (sourceUnits = this.createSourceUnits((SourceStructElement[])selectedElements, (IProgressMonitor)monitor)) != null && (data = this.createExecData(event, activePart, sourceEditor, sourceUnits, null, (List<SourceStructElement>)ImCollections.newList((Object[])selectedElements), (IProgressMonitor)monitor)) != null) {
                this.execute(data);
                return null;
            }
            return null;
        }
        return null;
    }

    private @Nullable SourceEditor getSourceEditor(IWorkbenchPart part) {
        if (part instanceof SourceEditor) {
            return (SourceEditor)part;
        }
        SourceEditor editor = (SourceEditor)part.getAdapter(SourceEditor.class);
        if (editor != null) {
            return editor;
        }
        SourceEditorAssociated editorAssociated = (SourceEditorAssociated)part.getAdapter(SourceEditorAssociated.class);
        if (editorAssociated != null) {
            return editorAssociated.getSourceEditor();
        }
        return null;
    }

    private boolean checkSourceUnits(SourceStructElement[] selectedElements) {
        SourceUnit lastSourceUnit = null;
        ArrayList<SourceUnit> sourceUnits = null;
        int i = 0;
        while (i < selectedElements.length) {
            SourceUnit sourceUnit = selectedElements[i].getSourceUnit();
            if (sourceUnit == null) {
                return false;
            }
            if (!(sourceUnit.equals(lastSourceUnit) || sourceUnits != null && sourceUnits.contains(sourceUnit))) {
                if (!this.isSourceUnitSupported(sourceUnit) || this.isEditTask() && !sourceUnit.checkState(false, null)) {
                    return false;
                }
                if (lastSourceUnit == null) {
                    lastSourceUnit = sourceUnit;
                } else {
                    if (sourceUnits == null) {
                        if (!this.isMultiSourceUnitsSupported()) {
                            return false;
                        }
                        sourceUnits = new ArrayList<SourceUnit>();
                        sourceUnits.add(lastSourceUnit);
                    }
                    sourceUnits.add(sourceUnit);
                    lastSourceUnit = sourceUnit;
                }
            }
            ++i;
        }
        return true;
    }

    private @Nullable ImList<TSourceUnit> createSourceUnits(SourceStructElement[] selectedElements, IProgressMonitor monitor) {
        SourceUnit lastSourceUnit = null;
        ArrayList<SourceUnit> sourceUnits = null;
        int i = 0;
        while (i < selectedElements.length) {
            SourceUnit sourceUnit = selectedElements[i].getSourceUnit();
            if (sourceUnit == null) {
                return null;
            }
            if (!(sourceUnit.equals(lastSourceUnit) || sourceUnits != null && sourceUnits.contains(sourceUnit))) {
                if (!this.isSourceUnitSupported(sourceUnit) || this.isEditTask() && !sourceUnit.checkState(true, monitor)) {
                    return null;
                }
                if (lastSourceUnit == null) {
                    lastSourceUnit = sourceUnit;
                } else {
                    if (sourceUnits == null) {
                        if (!this.isMultiSourceUnitsSupported()) {
                            return null;
                        }
                        sourceUnits = new ArrayList<SourceUnit>();
                        sourceUnits.add(lastSourceUnit);
                    }
                    sourceUnits.add(sourceUnit);
                    lastSourceUnit = sourceUnit;
                }
            }
            ++i;
        }
        return sourceUnits == null ? ImCollections.newList(lastSourceUnit) : ImCollections.toList(sourceUnits);
    }

    private void execute(final ExecData data) throws Exception {
        final AtomicReference<Exception> error = new AtomicReference<Exception>();
        switch (this.getExecMode(data)) {
            case 2: {
                try {
                    PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                AbstractSourceDocumentHandler.this.doExecute(data, monitor);
                            }
                            catch (Exception e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    error.set((Exception)e.getTargetException());
                }
                catch (InterruptedException interruptedException) {}
                break;
            }
            case 1: {
                BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            AbstractSourceDocumentHandler.this.doExecute(data, (IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (Exception e) {
                            error.set(e);
                        }
                    }
                });
                break;
            }
            default: {
                this.doExecute(data, (IProgressMonitor)new NullProgressMonitor());
                return;
            }
        }
        if (error.get() != null) {
            throw (Exception)error.get();
        }
    }

    protected abstract boolean isSourceUnitSupported(SourceUnit var1);

    protected boolean isMultiSourceUnitsSupported() {
        return false;
    }

    protected ExecData createExecData(ExecutionEvent event, IWorkbenchPart activePart, @Nullable SourceEditor sourceEditor, ImList<? extends TSourceUnit> sourceUnits, @Nullable ITextSelection textSelection, @Nullable List<SourceStructElement> selectedElements, IProgressMonitor monitor) throws Exception {
        return new ExecData(activePart, sourceEditor, sourceUnits, textSelection, selectedElements != null ? new ElementSet(new Object[]{selectedElements}) : null);
    }

    protected byte getExecMode(ExecData data) {
        return this.isEditTask() ? (byte)1 : 0;
    }

    protected abstract void doExecute(ExecData var1, IProgressMonitor var2) throws Exception;

    protected class ExecData {
        private final IWorkbenchPart activePart;
        private final @Nullable SourceEditor sourceEditor;
        private final ImList<? extends TSourceUnit> sourceUnits;
        final @Nullable ITextSelection textSelection;
        final @Nullable ElementSet elementSelection;

        public ExecData(@Nullable IWorkbenchPart activePart, SourceEditor sourceEditor, @Nullable ImList<? extends TSourceUnit> sourceUnits, @Nullable ITextSelection textSelection, ElementSet elementSet) {
            this.activePart = activePart;
            this.sourceEditor = sourceEditor;
            this.sourceUnits = sourceUnits;
            this.textSelection = textSelection;
            this.elementSelection = elementSet;
        }

        public IWorkbenchPart getActivePart() {
            return this.activePart;
        }

        public @Nullable SourceEditor getSourceEditor() {
            return this.sourceEditor;
        }

        public ImList<? extends TSourceUnit> getSourceUnits() {
            return this.sourceUnits;
        }

        public @Nullable ITextSelection getTextSelection() {
            return this.textSelection;
        }

        public @Nullable ElementSet getElementSelection() {
            return this.elementSelection;
        }
    }
}

