/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.util;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class StatusLineMessageManager {
    private static final long NO_CLEAR = 0L;
    private final IStatusLineManager statusLineManager;
    private final Display display;
    private final boolean showIcons;
    private final Handler infoHandler = new Handler();
    private final Handler errorHandler = new Handler();

    private static final long toClear(long nano) {
        return nano != 0L ? nano : 1L;
    }

    public StatusLineMessageManager(IStatusLineManager statusLineManager) {
        this(statusLineManager, true);
    }

    public StatusLineMessageManager(IStatusLineManager statusLineManager, boolean showIcons) {
        this.statusLineManager = statusLineManager;
        this.display = UIAccess.getDisplay();
        this.showIcons = showIcons;
    }

    protected IStatusLineManager getStatusLine() {
        return this.statusLineManager;
    }

    public void setMessage(IStatus status) {
        this.setMessage(status, 30);
    }

    public void setMessage(IStatus status, int timeout) {
        this.getHandler(status).setMessage(status, timeout);
    }

    public void setSelectionMessage(IStatus status) {
        this.infoHandler.setDefaultMessage(status);
    }

    public void clear(IStatus status) {
        this.getHandler(status).clear(status);
    }

    public void clearAll() {
        this.infoHandler.clear();
        this.errorHandler.clear();
    }

    private Handler getHandler(IStatus status) {
        return status.getSeverity() == 4 ? this.errorHandler : this.infoHandler;
    }

    private Image getIcon(int severity) {
        if (!this.showIcons) {
            return null;
        }
        switch (severity) {
            case 1: {
                return JFaceResources.getImage((String)"dialog_messasge_info_image");
            }
            case 2: {
                return JFaceResources.getImage((String)"dialog_messasge_warning_image");
            }
            case 4: {
                return JFaceResources.getImage((String)"dialog_message_error_image");
            }
        }
        return null;
    }

    private class Handler
    implements Runnable {
        private IStatus status;
        private IStatus defaultStatus;
        private long clearTime;
        private long scheduledTime;

        private void doSetMessage(Image icon, String message) {
            if (this == StatusLineMessageManager.this.errorHandler) {
                StatusLineMessageManager.this.getStatusLine().setErrorMessage(icon, message);
            } else {
                StatusLineMessageManager.this.getStatusLine().setMessage(icon, message);
            }
        }

        public void setMessage(IStatus status, int timeout) {
            Image icon = StatusLineMessageManager.this.getIcon(status.getSeverity());
            String message = status.getMessage();
            this.status = status;
            if (timeout > 0) {
                this.clearTime = StatusLineMessageManager.toClear(System.nanoTime() + (long)timeout * 1000000000L);
                if (this.scheduledTime > this.clearTime) {
                    this.scheduledTime = 0L;
                    StatusLineMessageManager.this.display.timerExec(-1, (Runnable)this);
                }
                if (this.scheduledTime == 0L) {
                    this.scheduledTime = this.clearTime;
                    StatusLineMessageManager.this.display.timerExec(timeout * 1000, (Runnable)this);
                }
            } else {
                this.clearTime = 0L;
            }
            this.doSetMessage(icon, message);
        }

        public void setDefaultMessage(IStatus status) {
            if (status != null) {
                this.defaultStatus = status;
                this.setMessage(status, 0);
            } else {
                status = this.defaultStatus;
                this.defaultStatus = null;
                this.clear(status);
            }
        }

        public void clear(IStatus status) {
            if (this.status == status) {
                this.clear();
            }
        }

        public void clear() {
            if (this.defaultStatus != null) {
                this.setMessage(this.defaultStatus, 0);
            } else {
                this.status = null;
                this.clearTime = 0L;
                this.doSetMessage(null, null);
            }
        }

        @Override
        public void run() {
            if (this.clearTime != 0L) {
                long remaining = this.clearTime - System.nanoTime();
                if (remaining > 4000000L) {
                    this.scheduledTime = this.clearTime;
                    StatusLineMessageManager.this.display.timerExec((int)((remaining + 800000L) / 1000000L), (Runnable)this);
                    return;
                }
                this.clear();
            }
            this.scheduledTime = 0L;
        }
    }
}

