/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rhelp.core.index;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.store.SimpleFSDirectory;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Constants;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
final class REnvIndexUtils {
    public static final BytesRef[] toByteRefTerms(List<String> stringValues) {
        BytesRef[] terms = new BytesRef[stringValues.size()];
        int i = 0;
        while (i < terms.length) {
            terms[i] = new BytesRef((CharSequence)stringValues.get(i));
            ++i;
        }
        return terms;
    }

    public static final BytesRef toByteRefTerm(String stringValue) {
        BytesRef term = new BytesRef((CharSequence)stringValue);
        return term;
    }

    public static final String toString(byte[] stringValue) {
        return new String(stringValue, StandardCharsets.UTF_8);
    }

    public static final FSDirectory getDirectory(Path path) throws IOException {
        if (Constants.WINDOWS) {
            return new SimpleFSDirectory(path);
        }
        return new NIOFSDirectory(path);
    }

    private REnvIndexUtils() {
    }
}

