/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.core.runtime;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.internal.nico.core.Messages;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.ts.core.ToolCommandData;
import org.eclipse.statet.nico.core.runtime.ConsoleService;
import org.eclipse.statet.nico.core.runtime.ToolWorkspace;
import org.eclipse.statet.nico.core.util.AbstractConsoleCommandHandler;

@NonNullByDefault
public class HistoryOperationsHandler
extends AbstractConsoleCommandHandler {
    public static final String LOAD_HISTORY_COMMAND_ID = "console/loadHistory";
    public static final String SAVE_HISTORY_COMMAND_ID = "console/saveHistory";
    public static final String ADDTO_HISTORY_COMMAND_ID = "console/addtoHistory";

    @Override
    public Status execute(String id, ConsoleService service, ToolCommandData data, ProgressMonitor m) {
        return switch (id) {
            case LOAD_HISTORY_COMMAND_ID -> this.loadHistory(service, data, m);
            case SAVE_HISTORY_COMMAND_ID -> this.saveHistory(service, data, m);
            case ADDTO_HISTORY_COMMAND_ID -> {
                String item = data.getStringRequired("text");
                service.getTool().getHistory().addCommand(item, service.getController().getCurrentSubmitType());
                yield Status.OK_STATUS;
            }
            default -> throw new UnsupportedOperationException();
        };
    }

    protected Status loadHistory(ConsoleService tools, ToolCommandData data, ProgressMonitor m) {
        try {
            CoreException fileException = null;
            IFileStore fileStore = null;
            String filename = data.getStringRequired("filename");
            ToolWorkspace workspaceData = tools.getWorkspaceData();
            try {
                fileStore = workspaceData.toFileStore(filename);
            }
            catch (CoreException e) {
                fileException = e;
            }
            Object status = fileStore == null ? new ErrorStatus("org.eclipse.statet.nico.core", NLS.bind((String)Messages.ToolController_FileOperation_error_CannotResolve_message, (Object)filename), (Throwable)fileException) : tools.getTool().getHistory().load(fileStore, workspaceData.getEncoding(), false, m);
            tools.handleStatus((Status)status, m);
            return status;
        }
        catch (OperationCanceledException e) {
            return Status.CANCEL_STATUS;
        }
    }

    protected Status saveHistory(ConsoleService tools, ToolCommandData data, ProgressMonitor m) {
        try {
            CoreException fileException = null;
            IFileStore fileStore = null;
            String filename = data.getStringRequired("filename");
            ToolWorkspace workspaceData = tools.getWorkspaceData();
            try {
                fileStore = workspaceData.toFileStore(filename);
            }
            catch (CoreException e) {
                fileException = e;
            }
            Object status = fileStore == null ? new ErrorStatus("org.eclipse.statet.nico.core", NLS.bind((String)Messages.ToolController_FileOperation_error_CannotResolve_message, (Object)filename), (Throwable)fileException) : tools.getTool().getHistory().save(fileStore, 0, workspaceData.getEncoding(), false, m);
            tools.handleStatus((Status)status, m);
            return status;
        }
        catch (OperationCanceledException e) {
            return Status.CANCEL_STATUS;
        }
    }
}

