/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.issues.core.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.statet.ecommons.runtime.core.util.MessageBuilder;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.core.source.SourceContent;
import org.eclipse.statet.ltk.core.util.SourceMessageUtil;
import org.eclipse.statet.ltk.issues.core.IssueRequestor;
import org.eclipse.statet.ltk.issues.core.Problem;
import org.eclipse.statet.ltk.issues.core.impl.BasicProblem;

@NonNullByDefault
public class AbstractSourceIssueReporter {
    private final String modelTypeId;
    private SourceContent sourceContent = (SourceContent)((Object)ObjectUtils.nonNullLateInit());
    private IssueRequestor requestor = (IssueRequestor)ObjectUtils.nonNullLateInit();
    private final SourceMessageUtil messageUtil = new SourceMessageUtil();
    private final MessageBuilder messageBuilder = new MessageBuilder();
    private final List<Problem> problemBuffer = new ArrayList<Problem>(100);

    public AbstractSourceIssueReporter(String modelTypeId) {
        this.modelTypeId = modelTypeId;
    }

    public final String getModelTypeId() {
        return this.modelTypeId;
    }

    protected SourceContent getSourceContent() {
        return this.sourceContent;
    }

    protected void init(SourceContent content, IssueRequestor requestor) {
        this.sourceContent = (SourceContent)((Object)ObjectUtils.nonNullAssert((Object)((Object)content)));
        this.messageUtil.setSourceContent(content);
        this.requestor = (IssueRequestor)ObjectUtils.nonNullAssert((Object)requestor);
    }

    protected void flush() {
        if (!this.problemBuffer.isEmpty()) {
            this.requestor.acceptProblems(this.modelTypeId, this.problemBuffer);
        }
    }

    protected void clear() {
        this.problemBuffer.clear();
        this.sourceContent = null;
        this.requestor = null;
    }

    protected final SourceMessageUtil getMessageUtil() {
        return this.messageUtil;
    }

    protected final MessageBuilder getMessageBuilder() {
        return this.messageBuilder;
    }

    protected final void addProblem(int severity, int code, String message, int startOffset, int endOffset) {
        if (startOffset < this.sourceContent.getStartOffset()) {
            startOffset = this.sourceContent.getStartOffset();
            if (endOffset < startOffset) {
                endOffset = startOffset;
            }
        } else if (endOffset <= startOffset) {
            endOffset = startOffset + 1;
        }
        if (endOffset > this.sourceContent.getEndOffset()) {
            endOffset = this.sourceContent.getEndOffset();
        }
        int line = this.sourceContent.getStringLines().getLineOfOffset(startOffset);
        this.problemBuffer.add(new BasicProblem(this.modelTypeId, severity, code, message, line, startOffset, endOffset));
        if (this.problemBuffer.size() >= 100) {
            this.requestor.acceptProblems(this.modelTypeId, this.problemBuffer);
            this.problemBuffer.clear();
        }
    }

    protected final void addProblem(int severity, int code, String message) {
        this.problemBuffer.add(new BasicProblem(this.modelTypeId, severity, code, message));
        if (this.problemBuffer.size() >= 100) {
            this.requestor.acceptProblems(this.modelTypeId, this.problemBuffer);
            this.problemBuffer.clear();
        }
    }
}

