/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.painter.cell;

import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import org.eclipse.statet.ecommons.waltable.core.config.ConfigRegistry;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerCell;
import org.eclipse.statet.ecommons.waltable.core.style.CellStyling;
import org.eclipse.statet.ecommons.waltable.core.style.HorizontalAlignment;
import org.eclipse.statet.ecommons.waltable.core.style.Style;
import org.eclipse.statet.ecommons.waltable.core.style.TextDecorationLine;
import org.eclipse.statet.ecommons.waltable.layer.cell.CellDisplayConversionUtils;
import org.eclipse.statet.ecommons.waltable.painter.cell.BackgroundPainter;
import org.eclipse.statet.ecommons.waltable.util.GUIHelper;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;

public abstract class AbstractTextPainter
extends BackgroundPainter {
    protected static final String EMPTY = "";
    protected static final char DOT = '\u2026';
    private static final Pattern NEW_LINE_PATTERN = Pattern.compile("\\n\\r|\\r\\n|\\n|\\r");
    private static final String NEW_LINE_SEPARATOR = System.lineSeparator();
    private static final int DEFAULT_SPACING = 3;
    public static final int DEFAULT_DRAW_STYLES = 3;
    private static final Map<TemporaryMapKey, Integer> temporaryMap = new WeakHashMap<TemporaryMapKey, Integer>();
    protected final boolean wrapText;
    protected final boolean paintBg;
    protected final boolean paintFg;
    protected final int spacing;
    protected final boolean calculateByTextLength;
    protected final boolean calculateByTextHeight;
    protected final int swtDrawStyle;
    private boolean underline;
    private boolean strikethrough;

    public AbstractTextPainter() {
        this(false, true, -1, false);
    }

    public AbstractTextPainter(boolean wrapText, boolean paintBg) {
        this(wrapText, paintBg, -1, false);
    }

    public AbstractTextPainter(boolean wrapText, boolean paintBg, int spacing) {
        this(wrapText, paintBg, spacing, false);
    }

    public AbstractTextPainter(boolean wrapText, boolean paintBg, int spacing, boolean calculate) {
        this(wrapText, paintBg, spacing, calculate, calculate, 3);
    }

    public AbstractTextPainter(boolean wrapText, boolean paintBg, int spacing, boolean calculateByTextLength, boolean calculateByTextHeight, int swtDrawStyle) {
        this.wrapText = wrapText;
        this.paintBg = paintBg;
        this.paintFg = true;
        this.spacing = spacing >= 0 ? spacing : 3;
        this.calculateByTextLength = calculateByTextLength;
        this.calculateByTextHeight = calculateByTextHeight;
        if (wrapText) {
            swtDrawStyle |= 2;
        }
        this.swtDrawStyle = swtDrawStyle;
    }

    protected String convertDataType(LayerCell cell, ConfigRegistry configRegistry) {
        return CellDisplayConversionUtils.convertDataType(cell, configRegistry);
    }

    protected void setupGCFromConfig(GC gc, Style cellStyle) {
        Color fg = cellStyle.getAttributeValue(CellStyling.FOREGROUND_COLOR);
        Color bg = cellStyle.getAttributeValue(CellStyling.BACKGROUND_COLOR);
        Font font = cellStyle.getAttributeValue(CellStyling.FONT);
        gc.setAntialias(-1);
        gc.setTextAntialias(-1);
        gc.setFont(font);
        gc.setForeground(fg != null ? fg : GUIHelper.COLOR_LIST_FOREGROUND);
        gc.setBackground(bg != null ? bg : GUIHelper.COLOR_LIST_BACKGROUND);
    }

    protected boolean renderUnderlined(Style cellStyle) {
        Set<TextDecorationLine> lines = cellStyle.getAttributeValue(CellStyling.TEXT_DECORATION_LINES);
        if (lines != null) {
            return lines.contains((Object)TextDecorationLine.UNDERLINE);
        }
        return this.underline;
    }

    protected boolean renderStrikethrough(Style cellStyle) {
        Set<TextDecorationLine> lines = cellStyle.getAttributeValue(CellStyling.TEXT_DECORATION_LINES);
        if (lines != null) {
            return lines.contains((Object)TextDecorationLine.STRIKETHROUGH);
        }
        return this.strikethrough;
    }

    protected int getNumberOfNewLines(String text) {
        String[] lines = NEW_LINE_PATTERN.split(text);
        return lines.length;
    }

    protected long getHorizontalAlignmentIndent(HorizontalAlignment horizontalAlignment, long width, long textWidth) {
        if (horizontalAlignment == null) {
            horizontalAlignment = HorizontalAlignment.CENTER;
        }
        switch (horizontalAlignment) {
            case CENTER: {
                return (width - textWidth) / 2L;
            }
            case RIGHT: {
                return width - textWidth;
            }
        }
        return 0L;
    }

    protected int getWidthFromCache(GC gc, String text) {
        TemporaryMapKey key = new TemporaryMapKey(text, gc.getFont());
        Integer width = temporaryMap.get(key);
        if (width == null) {
            width = gc.textExtent((String)text, (int)this.swtDrawStyle).x;
            temporaryMap.put(key, width);
        }
        return width;
    }

    protected String getTextToDisplay(LayerCell cell, GC gc, long availableLength, String text) {
        StringBuilder output = new StringBuilder();
        text = text.trim();
        long textLength = this.getWidthFromCache(gc, text);
        if (this.calculateByTextLength && this.wrapText) {
            if (availableLength < textLength) {
                String[] lines;
                textLength = availableLength;
                String[] stringArray = lines = NEW_LINE_PATTERN.split(text);
                int n = lines.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] words;
                    String line = stringArray[n2];
                    if (output.length() > 0) {
                        output.append(NEW_LINE_SEPARATOR);
                    }
                    String[] stringArray2 = words = line.split("\\s");
                    int n3 = words.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String word = stringArray2[n4];
                        textLength = Math.max(textLength, (long)this.getWidthFromCache(gc, word));
                        ++n4;
                    }
                    String computedText = EMPTY;
                    String[] stringArray3 = words;
                    int n5 = words.length;
                    n3 = 0;
                    while (n3 < n5) {
                        String word = stringArray3[n3];
                        computedText = this.computeTextToDisplay(computedText, word, gc, textLength);
                        ++n3;
                    }
                    output.append(computedText);
                    ++n2;
                }
            } else {
                output.append(text);
            }
        } else if (this.calculateByTextLength && !this.wrapText) {
            output.append(this.modifyTextToDisplay(text, gc, textLength));
        } else if (!this.calculateByTextLength && this.wrapText) {
            String[] lines;
            String[] stringArray = lines = NEW_LINE_PATTERN.split(text);
            int n = lines.length;
            int n6 = 0;
            while (n6 < n) {
                String line = stringArray[n6];
                if (output.length() > 0) {
                    output.append(NEW_LINE_SEPARATOR);
                }
                String[] words = line.split("\\s");
                String computedText = EMPTY;
                String[] stringArray4 = words;
                int n7 = words.length;
                int n8 = 0;
                while (n8 < n7) {
                    String word = stringArray4[n8];
                    computedText = this.computeTextToDisplay(computedText, word, gc, availableLength);
                    ++n8;
                }
                output.append(computedText);
                ++n6;
            }
        } else if (!this.calculateByTextLength && !this.wrapText) {
            output.append(this.modifyTextToDisplay(text, gc, availableLength));
        }
        return output.toString();
    }

    private String computeTextToDisplay(String one, String two, GC gc, long availableSpace) {
        String result = one;
        if (one == null || one.length() == 0 || one.endsWith(NEW_LINE_SEPARATOR)) {
            result = String.valueOf(result) + two;
        } else if (one.indexOf(NEW_LINE_SEPARATOR) == -1) {
            if ((long)this.getWidthFromCache(gc, one) == availableSpace || (long)this.getWidthFromCache(gc, String.valueOf(one) + " " + two) >= availableSpace) {
                result = String.valueOf(result) + NEW_LINE_SEPARATOR;
                result = String.valueOf(result) + this.modifyTextToDisplay(two, gc, availableSpace);
            } else {
                result = String.valueOf(result) + ' ';
                result = String.valueOf(result) + two;
            }
        } else {
            String endString = one.substring(one.lastIndexOf(NEW_LINE_SEPARATOR) + 1);
            if ((long)this.getWidthFromCache(gc, endString) == availableSpace || (long)this.getWidthFromCache(gc, String.valueOf(endString) + " " + two) >= availableSpace) {
                result = String.valueOf(result) + NEW_LINE_SEPARATOR;
                result = String.valueOf(result) + two;
            } else {
                result = String.valueOf(result) + ' ';
                result = String.valueOf(result) + two;
            }
        }
        return result;
    }

    private String modifyTextToDisplay(String text, GC gc, long availableLength) {
        long textLength = this.getWidthFromCache(gc, text);
        if (textLength > availableLength) {
            String[] lines;
            StringBuilder result = new StringBuilder();
            String[] stringArray = lines = (this.swtDrawStyle & 2) == 0 ? NEW_LINE_PATTERN.split(text, 1) : NEW_LINE_PATTERN.split(text);
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                long lineLength;
                String line = stringArray[n2];
                if (result.length() > 0) {
                    result.append(NEW_LINE_SEPARATOR);
                }
                if ((lineLength = (long)this.getWidthFromCache(gc, line)) > availableLength) {
                    int numExtraChars = 0;
                    int newStringLength = line.length();
                    String trialLabelText = String.valueOf(line) + '\u2026';
                    long newTextExtent = this.getWidthFromCache(gc, trialLabelText);
                    while (newTextExtent > availableLength + 1L && newStringLength > 0) {
                        double avgWidthPerChar = (double)newTextExtent / (double)trialLabelText.length();
                        newStringLength = line.length() - (numExtraChars += 1 + (int)((double)(newTextExtent - availableLength) / avgWidthPerChar));
                        if (newStringLength <= 0) continue;
                        trialLabelText = String.valueOf(line.substring(0, newStringLength)) + '\u2026';
                        newTextExtent = this.getWidthFromCache(gc, trialLabelText);
                    }
                    if (numExtraChars > line.length()) {
                        numExtraChars = line.length();
                    }
                    String testString = line;
                    int i = 0;
                    while (i < line.length()) {
                        testString = String.valueOf(line.substring(0, line.length() + i - numExtraChars)) + '\u2026';
                        textLength = this.getWidthFromCache(gc, testString);
                        if (textLength >= availableLength) {
                            if (line.length() + i - numExtraChars < 1) {
                                line = EMPTY;
                                break;
                            }
                            line = String.valueOf(line.substring(0, line.length() + i - numExtraChars - 1)) + '\u2026';
                            break;
                        }
                        ++i;
                    }
                }
                result.append(line);
                ++n2;
            }
            return result.toString();
        }
        return text;
    }

    public void setUnderline(boolean underline) {
        this.underline = underline;
    }

    public void setStrikethrough(boolean strikethrough) {
        this.strikethrough = strikethrough;
    }

    private static final class TemporaryMapKey {
        private final String text;
        private final Font font;

        public TemporaryMapKey(String text, Font font) {
            this.text = text;
            this.font = font;
        }

        public int hashCode() {
            return this.text.hashCode() + this.font.hashCode();
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TemporaryMapKey)) {
                return false;
            }
            TemporaryMapKey other = (TemporaryMapKey)obj;
            return this.text.equals(other.text) && this.font.equals((Object)other.font);
        }
    }
}

