/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.core.swt.painters;

import java.util.function.Function;
import org.eclipse.statet.ecommons.waltable.core.config.ConfigRegistry;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.core.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.core.layer.Layer;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerDim;
import org.eclipse.statet.ecommons.waltable.core.style.GridStyling;
import org.eclipse.statet.ecommons.waltable.core.swt.painters.CellLayerPainter;
import org.eclipse.statet.ecommons.waltable.painter.cell.GraphicsUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

@NonNullByDefault
public class GridLineCellLayerPainter
extends CellLayerPainter {
    private final Function<ConfigRegistry, Color> gridLineColorSupplier;

    public GridLineCellLayerPainter(Function<ConfigRegistry, Color> gridLineColorSupplier) {
        this.gridLineColorSupplier = gridLineColorSupplier;
    }

    public GridLineCellLayerPainter() {
        this(new GridStyling.ConfigGridLineColorSupplier());
    }

    @Override
    public LRectangle adjustCellBounds(long columnPosition, long rowPosition, LRectangle bounds) {
        return new LRectangle(bounds.x, bounds.y, Math.max(bounds.width - 1L, 0L), Math.max(bounds.height - 1L, 0L));
    }

    @Override
    public void paintLayer(Layer natLayer, GC gc, int xOffset, int yOffset, Rectangle pixelRectangle, ConfigRegistry configRegistry) {
        gc.setForeground(this.gridLineColorSupplier.apply(configRegistry));
        this.drawHorizontalLines(natLayer, gc, pixelRectangle);
        this.drawVerticalLines(natLayer, gc, pixelRectangle);
        super.paintLayer(natLayer, gc, xOffset, yOffset, pixelRectangle, configRegistry);
    }

    protected void drawHorizontalLines(Layer natLayer, GC gc, Rectangle rectangle) {
        int startX = GraphicsUtils.safe(rectangle.x);
        int endX = GraphicsUtils.safe((long)rectangle.x + Math.min(natLayer.getWidth() - 1L, (long)rectangle.width));
        LayerDim dim = natLayer.getDim(Orientation.VERTICAL);
        long endPosition = Math.min(dim.getPositionCount(), dim.getPositionByPixel(rectangle.y + rectangle.height - 1) + 1L);
        long position = dim.getPositionByPixel(rectangle.y);
        while (position < endPosition) {
            int size = dim.getPositionSize(position);
            if (size > 0) {
                int y = GraphicsUtils.safe(dim.getPositionStart(position) + (long)size - 1L);
                gc.drawLine(startX, y, endX, y);
            }
            ++position;
        }
    }

    protected void drawVerticalLines(Layer natLayer, GC gc, Rectangle rectangle) {
        int startY = GraphicsUtils.safe(rectangle.y);
        int endY = GraphicsUtils.safe((long)rectangle.y + Math.min(natLayer.getHeight() - 1L, (long)rectangle.height));
        LayerDim dim = natLayer.getDim(Orientation.HORIZONTAL);
        long endPosition = Math.min(dim.getPositionCount(), dim.getPositionByPixel(rectangle.x + rectangle.width - 1) + 1L);
        long position = dim.getPositionByPixel(rectangle.x);
        while (position < endPosition) {
            long size = dim.getPositionSize(position);
            if (size > 0L) {
                int x = GraphicsUtils.safe(dim.getPositionStart(position) + size - 1L);
                gc.drawLine(x, startY, x, endY);
            }
            ++position;
        }
    }
}

