/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.text.core.treepartitioner;

import java.io.IOException;
import java.io.PrintStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.DocumentPartitioningChangedEvent;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IDocumentPartitionerExtension;
import org.eclipse.jface.text.IDocumentPartitionerExtension2;
import org.eclipse.jface.text.IDocumentPartitionerExtension3;
import org.eclipse.jface.text.IDocumentPartitioningListenerExtension2;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.statet.ecommons.text.core.DocumentEnhancement;
import org.eclipse.statet.ecommons.text.core.treepartitioner.NodePosition;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartition;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionNode;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionNodeScan;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionNodeScanner;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionNodeType;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionUtils;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionerScan;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;

@NonNullByDefault
public class TreePartitioner
implements IDocumentPartitioner,
IDocumentPartitionerExtension,
IDocumentPartitionerExtension2,
IDocumentPartitionerExtension3 {
    static final boolean DEBUG = Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.statet.ecommons.text.core/TreePartitioner"));
    static final boolean DEBUG_PRINT = Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.statet.ecommons.text.core/TreePartitioner/printTree"));
    private static final String CONTENT_TYPES_CATEGORY = "org.eclipse.statet.ecommons.text.TreePartitionerNodes";
    private final String partitioningId;
    protected final TreePartitionNodeScanner scanner;
    protected final ImList<String> legalContentTypes;
    private boolean isInitialized = false;
    protected IDocument document;
    private @Nullable DocumentEnhancement documentEnh;
    protected int previousDocumentLength;
    protected final DefaultPositionUpdater positionUpdater;
    private final String positionCategory;
    private final NodePosition rootPosition;
    private TreePartitionNodeType startType;
    private TreePartitionerScan scan;
    private @Nullable DocumentRewriteSession activeRewriteSession;
    private @Nullable RewriteSessionUpdater activeRewriteUpdater;
    private @Nullable IDocumentPartitioningListenerExtension2 partitioningListener;
    private @Nullable IRegion partitioningChangeRegion;

    public TreePartitioner(String partitioningId, TreePartitionNodeScanner scanner, List<String> legalContentTypes) {
        this.partitioningId = (String)ObjectUtils.nonNullAssert((Object)partitioningId);
        this.scanner = (TreePartitionNodeScanner)ObjectUtils.nonNullAssert((Object)scanner);
        this.legalContentTypes = ImCollections.toIdentityList(legalContentTypes);
        this.positionCategory = "org.eclipse.statet.ecommons.text.TreePartitionerNodes:" + this.partitioningId;
        this.positionUpdater = new DefaultPositionUpdater(this.positionCategory);
        this.rootPosition = new RootNode(scanner.getDefaultRootType());
    }

    protected final String getPartitioningId() {
        return this.partitioningId;
    }

    public @NonNull String[] getManagingPositionCategories() {
        return new String[]{this.positionCategory};
    }

    public void setStartType(TreePartitionNodeType type) {
        this.startType = type;
        this.clear();
    }

    public final void connect(IDocument document) {
        this.connect(document, false);
    }

    public void connect(IDocument document, boolean delayInitialization) {
        Assert.isNotNull((Object)document);
        Assert.isTrue((!document.containsPositionCategory(this.positionCategory) ? 1 : 0) != 0);
        this.document = document;
        this.document.addPositionCategory(this.positionCategory);
        this.documentEnh = DocumentEnhancement.get(this.document);
        this.isInitialized = false;
        if (!delayInitialization) {
            this.checkInitialization();
        }
    }

    protected final void checkInitialization() {
        if (!this.isInitialized) {
            this.initialize();
        }
    }

    protected void clear() {
        try {
            this.rootPosition.children.clear();
            this.document.removePositionCategory(this.positionCategory);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            // empty catch block
        }
        this.document.addPositionCategory(this.positionCategory);
        this.isInitialized = false;
    }

    protected void initialize() {
        IDocumentPartitioningListenerExtension2 partitioningListener;
        this.isInitialized = true;
        this.partitioningChangeRegion = null;
        DocumentEnhancement documentEnh = this.documentEnh;
        if (documentEnh != null && (partitioningListener = this.partitioningListener) == null) {
            partitioningListener = new IDocumentPartitioningListenerExtension2(){

                public void documentPartitioningChanged(DocumentPartitioningChangedEvent event) {
                    TreePartitioner.this.updatePartitioningChange(event);
                }
            };
            documentEnh.addPrePartitioningListener(partitioningListener);
            this.partitioningListener = partitioningListener;
        }
        if (this.scan == null) {
            this.scan = new TreePartitionerScan(this);
        }
        this.scan.init(0, this.document.getLength(), this.rootPosition);
        this.scan.markDirtyRegion(0, Integer.MAX_VALUE);
        if (this.startType != null) {
            this.scan.addBeginPosition(this.startType);
        }
        try {
            try {
                this.scanner.execute(this.scan);
            }
            catch (TreePartitionNodeScan.BreakException breakException) {
                if (DEBUG) {
                    this.check(DEBUG_PRINT);
                }
            }
        }
        finally {
            if (DEBUG) {
                this.check(DEBUG_PRINT);
            }
        }
    }

    public void disconnect() {
        DocumentEnhancement documentEnh;
        Assert.isTrue((boolean)this.document.containsPositionCategory(this.positionCategory));
        try {
            this.document.removePositionCategory(this.positionCategory);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            // empty catch block
        }
        if (this.activeRewriteSession != null) {
            RewriteSessionUpdater rewriteUpdater = this.activeRewriteUpdater;
            if (rewriteUpdater != null) {
                this.activeRewriteUpdater = null;
                this.document.removePositionUpdater((IPositionUpdater)rewriteUpdater);
            }
            this.activeRewriteSession = null;
        }
        if ((documentEnh = this.documentEnh) != null) {
            this.documentEnh = null;
            IDocumentPartitioningListenerExtension2 partitioningListener = this.partitioningListener;
            if (partitioningListener != null) {
                this.partitioningListener = null;
                documentEnh.removePrePartitioningListener(partitioningListener);
            }
        }
    }

    public void documentAboutToBeChanged(DocumentEvent e) {
        if (this.isInitialized) {
            Assert.isTrue((e.getDocument() == this.document ? 1 : 0) != 0);
            this.previousDocumentLength = e.getDocument().getLength();
        }
    }

    public final boolean documentChanged(DocumentEvent e) {
        if (this.isInitialized) {
            IRegion region = this.documentChanged2(e);
            return region != null;
        }
        return false;
    }

    public @Nullable IRegion documentChanged2(DocumentEvent event) {
        if (!this.isInitialized) {
            return null;
        }
        Assert.isTrue((event.getDocument() == this.document ? 1 : 0) != 0);
        this.positionUpdater.update(event);
        return this.updatePartitioning(event.getOffset(), event.getOffset() + (event.getText() != null ? event.getText().length() : 0));
    }

    protected final @Nullable IRegion updatePartitioning(int startOffset, int endOffset) {
        try {
            block13: {
                this.partitioningChangeRegion = null;
                int lineOfOffset = this.document.getLineOfOffset(startOffset);
                TreePartitionNodeScan.State startState = new TreePartitionNodeScan.State(this.document.getLineOffset(lineOfOffset > 0 ? lineOfOffset - 1 : 0));
                if (startState.offset > 0) {
                    startState.node = this.findPositionPreferOpen(startState.offset);
                    this.scanner.checkRestartState(startState, this.document, this);
                }
                if (startState.offset == 0) {
                    startState.node = this.rootPosition;
                }
                this.scan.init(startState.offset, this.document.getLength(), (NodePosition)startState.node);
                this.scan.markDirtyStart(startState.offset);
                this.scan.markDirtyEnd(endOffset);
                if (startState.offset == 0 && this.startType != null) {
                    this.scan.addBeginPosition(this.startType);
                }
                try {
                    try {
                        this.scanner.execute(this.scan);
                    }
                    catch (TreePartitionNodeScan.BreakException breakException) {
                        if (DEBUG) {
                            this.check(DEBUG_PRINT);
                        }
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    if (DEBUG) {
                        this.check(DEBUG_PRINT);
                    }
                    throw throwable;
                }
                if (DEBUG) {
                    this.check(DEBUG_PRINT);
                }
            }
            return this.scan.createDirtyRegion();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            this.clear();
            return new Region(0, this.document.getLength());
        }
    }

    final void addPosition(NodePosition position) throws BadLocationException, BadPositionCategoryException {
        this.document.addPosition(this.positionCategory, (Position)position);
    }

    final void removePosition(NodePosition position) throws BadPositionCategoryException {
        this.document.removePosition(this.positionCategory, (Position)position);
    }

    final NodePosition findPosition(int offset) {
        NodePosition p;
        block2: {
            int idx;
            List<NodePosition> children;
            p = this.rootPosition;
            do {
                assert (p.includes(offset));
                children = p.children;
                int childCount = children.size();
                if (childCount <= 0 || (idx = NodePosition.indexOf(children, offset)) < 0) break block2;
            } while ((p = children.get(idx)).getLength() != 0 || idx + 1 < children.size() && (p = children.get(idx + 1)).includes(offset));
            return p.parent;
        }
        return p;
    }

    public String getContentType(int offset) {
        this.checkInitialization();
        NodePosition position = this.findPosition(offset);
        return position.type.getPartitionType();
    }

    private TreePartition createPartition(NodePosition p, int childIdx) {
        int startOffset = childIdx > 0 ? p.children.get(childIdx - 1).getEndOffset() : p.getOffset();
        int endOffset = childIdx >= 0 && childIdx < p.children.size() ? p.children.get(childIdx).getOffset() : p.getEndOffset();
        return new TreePartition(startOffset, endOffset, p);
    }

    public TreePartition getPartition(int offset) {
        NodePosition p;
        block2: {
            int idx;
            block3: {
                List<NodePosition> children;
                this.checkInitialization();
                p = this.rootPosition;
                do {
                    assert (p.includes(offset));
                    children = p.children;
                    int childCount = children.size();
                    if (childCount <= 0) break block2;
                    idx = NodePosition.indexOf(children, offset);
                    if (idx < 0) break block3;
                } while ((p = p.children.get(idx)).getLength() != 0 || idx + 1 < children.size() && (p = children.get(idx + 1)).includes(offset));
                return this.createPartition(p.parent, idx);
            }
            return this.createPartition(p, -(idx + 1));
        }
        return this.createPartition(p, -1);
    }

    private int addPartition(List<TreePartition> partitions, NodePosition p, int startOffset, int endOffset) {
        startOffset = Math.max(startOffset, p.getOffset());
        endOffset = Math.min(endOffset, p.getEndOffset());
        List<NodePosition> children = p.children;
        int childIdx = 0;
        int childCount = children.size();
        if (childCount > 0) {
            if (p.getOffset() < startOffset && (childIdx = NodePosition.indexOf(children, startOffset)) < 0) {
                childIdx = -(childIdx + 1);
            }
            while (childIdx < childCount) {
                NodePosition child = children.get(childIdx);
                if (child.getOffset() > endOffset) break;
                if (startOffset < child.getOffset()) {
                    partitions.add(new TreePartition(startOffset, child.getOffset(), p));
                }
                startOffset = this.addPartition(partitions, child, startOffset, endOffset);
                ++childIdx;
            }
        }
        if (startOffset < endOffset) {
            partitions.add(new TreePartition(startOffset, endOffset, p));
        }
        return endOffset;
    }

    public final @NonNull TreePartition[] computePartitioning(int offset, int length) {
        this.checkInitialization();
        ArrayList<TreePartition> partitions = new ArrayList<TreePartition>();
        try {
            this.addPartition(partitions, this.rootPosition, offset, offset + length);
        }
        catch (RuntimeException ex) {
            this.clear();
            throw ex;
        }
        return partitions.toArray(new TreePartition[partitions.size()]);
    }

    public @NonNull String[] getLegalContentTypes() {
        return (String[])this.legalContentTypes.toArray((Object[])new String[this.legalContentTypes.size()]);
    }

    protected final boolean isSupportedPartitionType(String contentType) {
        return contentType != null && this.legalContentTypes.contains((Object)contentType);
    }

    final NodePosition findPositionPreferOpen(int offset) {
        NodePosition p = this.rootPosition;
        while (true) {
            NodePosition child;
            assert (p.includes(offset) || p.getEndOffset() == offset);
            List<NodePosition> children = p.children;
            int idx = -1;
            int childCount = children.size();
            if (childCount <= 0) break;
            idx = NodePosition.indexOf(children, offset);
            if (idx >= 0) {
                child = children.get(idx);
                if (child.getOffset() < offset || child.type.prefereAtBegin(child, this.document)) {
                    p = child;
                    continue;
                }
            } else {
                idx = -(idx + 1);
            }
            if (idx <= 0 || (child = children.get(idx - 1)).getEndOffset() != offset || !child.type.prefereAtEnd(child, this.document)) break;
            p = child;
        }
        return p;
    }

    private TreePartition getPartitionPreferOpen(int offset) {
        int idx;
        this.checkInitialization();
        NodePosition p = this.rootPosition;
        while (true) {
            NodePosition child;
            assert (p.includes(offset) || p.getEndOffset() == offset);
            List<NodePosition> children = p.children;
            idx = -1;
            int childCount = children.size();
            if (childCount <= 0) break;
            idx = NodePosition.indexOf(children, offset);
            if (idx >= 0) {
                child = p.children.get(idx);
                if (child.getOffset() < offset || child.type.prefereAtBegin(child, this.document)) {
                    p = child;
                    continue;
                }
            } else {
                idx = -(idx + 1);
            }
            if (idx <= 0 || (child = p.children.get(idx - 1)).getEndOffset() != offset || !child.type.prefereAtEnd(child, this.document)) break;
            p = child;
        }
        return this.createPartition(p, idx);
    }

    public String getContentType(int offset, boolean preferOpenPartitions) {
        this.checkInitialization();
        NodePosition position = preferOpenPartitions ? this.findPositionPreferOpen(offset) : this.findPosition(offset);
        return position.type.getPartitionType();
    }

    public TreePartitionNode getTreeNode(int offset, boolean preferOpenPartitions) {
        this.checkInitialization();
        return preferOpenPartitions ? this.findPositionPreferOpen(offset) : this.findPosition(offset);
    }

    public TreePartition getPartition(int offset, boolean preferOpenPartitions) {
        return preferOpenPartitions ? this.getPartitionPreferOpen(offset) : this.getPartition(offset);
    }

    private int addPartitionIncludeZeroLength(List<TreePartition> partitions, NodePosition p, int startOffset, int endOffset) {
        startOffset = Math.max(startOffset, p.getOffset());
        endOffset = Math.min(endOffset, p.getEndOffset());
        List<NodePosition> children = p.children;
        int childIdx = 0;
        int childCount = children.size();
        if (childCount > 0) {
            if (p.getOffset() < startOffset && (childIdx = NodePosition.indexOf(children, startOffset)) < 0) {
                childIdx = -(childIdx + 1);
            }
            while (childIdx < childCount) {
                NodePosition child = children.get(childIdx);
                if (child.getOffset() > endOffset) break;
                if (startOffset <= child.getOffset()) {
                    partitions.add(new TreePartition(startOffset, child.getOffset(), p));
                }
                startOffset = this.addPartitionIncludeZeroLength(partitions, child, startOffset, endOffset);
                ++childIdx;
            }
        }
        if (startOffset < endOffset || startOffset == endOffset && (--childIdx < 0 || startOffset == children.get(childIdx).getEndOffset())) {
            partitions.add(new TreePartition(startOffset, endOffset, p));
        }
        return endOffset;
    }

    private @NonNull TreePartition[] computePartitioningIncludeZeroLength(int offset, int length) {
        this.checkInitialization();
        ArrayList<TreePartition> partitions = new ArrayList<TreePartition>();
        try {
            this.addPartitionIncludeZeroLength(partitions, this.rootPosition, offset, offset + length);
        }
        catch (RuntimeException ex) {
            this.clear();
            throw ex;
        }
        return partitions.toArray(new TreePartition[partitions.size()]);
    }

    public @NonNull TreePartition[] computePartitioning(int offset, int length, boolean includeZeroLengthPartitions) {
        return includeZeroLengthPartitions ? this.computePartitioningIncludeZeroLength(offset, length) : this.computePartitioning(offset, length);
    }

    public void startRewriteSession(DocumentRewriteSession session) throws IllegalStateException {
        if (this.activeRewriteSession != null) {
            throw new IllegalStateException();
        }
        this.activeRewriteSession = session;
        if (this.isInitialized && session.getSessionType() == DocumentRewriteSessionType.UNRESTRICTED_SMALL) {
            RewriteSessionUpdater rewriteUpdater = new RewriteSessionUpdater();
            this.document.addPositionUpdater((IPositionUpdater)rewriteUpdater);
            this.activeRewriteUpdater = rewriteUpdater;
        }
    }

    public void stopRewriteSession(DocumentRewriteSession session) {
        if (this.activeRewriteSession == session) {
            this.flushRewriteSession();
        }
    }

    public @Nullable DocumentRewriteSession getActiveRewriteSession() {
        return this.activeRewriteSession;
    }

    protected final void flushRewriteSession() {
        this.activeRewriteSession = null;
        RewriteSessionUpdater rewriteUpdater = this.activeRewriteUpdater;
        if (rewriteUpdater != null) {
            this.activeRewriteUpdater = null;
            this.document.removePositionUpdater((IPositionUpdater)rewriteUpdater);
            if (this.isInitialized) {
                this.partitioningChangeRegion = rewriteUpdater.startOffset >= 0 ? this.updatePartitioning(rewriteUpdater.startOffset, rewriteUpdater.endOffset) : new Region(0, 0);
            }
            return;
        }
        this.clear();
    }

    private void updatePartitioningChange(DocumentPartitioningChangedEvent event) {
        IRegion changeRegion = this.partitioningChangeRegion;
        if (changeRegion != null && event.getChangedRegion(this.partitioningId) != null) {
            event.setPartitionChange(this.partitioningId, changeRegion.getOffset(), changeRegion.getLength());
            this.partitioningChangeRegion = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void check(boolean printInfo) {
        try {
            this.validateChildren(this.rootPosition);
            if (printInfo) {
                System.out.println("[TreePartitioner] INFO :");
                System.out.println(this.toString());
            }
        }
        catch (Error e) {
            PrintStream printStream = System.err;
            synchronized (printStream) {
                System.err.println("[TreePartitioner] ERROR Error in document partitioning:");
                System.err.println(this.toString());
                e.printStackTrace(System.err);
                System.err.println("==== document content:\n" + this.document.get() + "\n====");
            }
        }
    }

    private void validateChildren(NodePosition parent) {
        int offset = parent.getOffset();
        int childCount = parent.children.size();
        int childIdx = 0;
        while (childIdx < childCount) {
            NodePosition child = parent.children.get(childIdx);
            if (child.parent != parent) {
                throw new AssertionError((Object)"position.parent");
            }
            if (child.isDeleted()) {
                throw new AssertionError((Object)"position.isDeleted");
            }
            if (child.getOffset() < offset || child.getOffset() > parent.getEndOffset()) {
                throw new AssertionError((Object)"position.offset");
            }
            if (child.getLength() < 0 || child.getEndOffset() > parent.getEndOffset()) {
                throw new AssertionError((Object)"position.length");
            }
            offset = child.getEndOffset();
            this.validateChildren(child);
            ++childIdx;
        }
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        writer.append("TreePartitioner (scanner= " + this.scanner.getClass().getCanonicalName() + "):\n");
        if (!this.isInitialized) {
            writer.append("<no initialized>");
        } else {
            TreePartitionUtils.PartitionPrinter printer = new TreePartitionUtils.PartitionPrinter(writer);
            try {
                printer.print((TreePartitionNode)this.rootPosition, this.document);
                writer.append("====");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return writer.toString();
    }

    private final class RewriteSessionUpdater
    implements IPositionUpdater {
        private int startOffset = -1;
        private int endOffset = -1;

        public void update(DocumentEvent event) {
            if (TreePartitioner.this.activeRewriteSession == null) {
                return;
            }
            TreePartitioner.this.positionUpdater.update(event);
            int eventOffset = event.getOffset();
            int eventOldEndOffset = eventOffset + event.getLength();
            int eventNewLength = event.getText() == null ? 0 : event.getText().length();
            int eventNewEndOffset = eventOffset + eventNewLength;
            if (this.startOffset < 0) {
                this.startOffset = eventOffset;
                this.endOffset = eventNewEndOffset;
            } else {
                if (this.startOffset > eventOffset) {
                    this.startOffset = eventOffset;
                }
                this.endOffset = this.endOffset > eventOldEndOffset ? (this.endOffset += eventNewLength - event.getLength()) : eventNewEndOffset;
            }
        }
    }

    private final class RootNode
    extends NodePosition {
        public RootNode(TreePartitionNodeType type) {
            super(null, 0, Integer.MAX_VALUE, type, 0);
        }

        public void setOffset(int offset) {
        }

        @Override
        public int getStartOffset() {
            return 0;
        }

        @Override
        public int getEndOffset() {
            return TreePartitioner.this.document.getLength();
        }

        public void setLength(int length) {
        }

        @Override
        public int getLength() {
            return TreePartitioner.this.document.getLength();
        }
    }
}

