/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.tex.core.ast;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.statet.docmlet.tex.core.ast.Comment;
import org.eclipse.statet.docmlet.tex.core.ast.ContainerNode;
import org.eclipse.statet.docmlet.tex.core.ast.NodeType;
import org.eclipse.statet.docmlet.tex.core.ast.TexAstNode;
import org.eclipse.statet.docmlet.tex.core.ast.TexAstVisitor;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.AstVisitor;

@NonNullByDefault
public final class SourceComponent
extends ContainerNode {
    private final @Nullable AstNode parent;
    @Nullable ImList<Comment> comments;

    SourceComponent(int statusCode, @Nullable AstNode parent, int startOffset, int endOffset) {
        super(statusCode, null);
        this.parent = parent;
        this.doSetStartEndOffset(startOffset, endOffset);
    }

    SourceComponent(@Nullable AstNode parent, int startOffset, int endOffset) {
        this.parent = parent;
        this.doSetStartEndOffset(startOffset, endOffset);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.SOURCELINES;
    }

    @Override
    public @Nullable AstNode getParent() {
        return this.parent;
    }

    @Override
    public final boolean hasChildren() {
        return this.children.length > 0;
    }

    @Override
    public final int getChildCount() {
        return this.children.length;
    }

    @Override
    public final TexAstNode getChild(int index) {
        return this.children[index];
    }

    @Override
    public final int getChildIndex(AstNode child) {
        int i = 0;
        while (i < this.children.length) {
            if (this.children[i] == child) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public @Nullable ImList<Comment> getComments() {
        return this.comments;
    }

    public final void acceptInChildren(AstVisitor visitor) throws InvocationTargetException {
        TexAstNode[] texAstNodeArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            TexAstNode child = texAstNodeArray[n2];
            visitor.visit((AstNode)child);
            ++n2;
        }
    }

    @Override
    public void acceptInTex(TexAstVisitor visitor) throws InvocationTargetException {
        visitor.visit(this);
    }

    @Override
    public final void acceptInTexChildren(TexAstVisitor visitor) throws InvocationTargetException {
        TexAstNode[] texAstNodeArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            TexAstNode child = texAstNodeArray[n2];
            child.acceptInTex(visitor);
            ++n2;
        }
    }

    @Override
    void setEndNode(int endOffset, TexAstNode endNode) {
        this.doSetEndOffset(endOffset);
    }

    @Override
    void setMissingEnd() {
        if (this.children.length > 0) {
            this.doSetEndOffset(this.children[this.children.length - 1].getEndOffset());
        }
    }
}

