/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.core.model;

import java.util.Arrays;
import org.eclipse.debug.core.DebugException;
import org.eclipse.statet.internal.r.debug.core.model.BasicRVariable;
import org.eclipse.statet.internal.r.debug.core.model.RArrayValue;
import org.eclipse.statet.internal.r.debug.core.model.RDebugTargetImpl;
import org.eclipse.statet.internal.r.debug.core.model.RElementVariableValue;
import org.eclipse.statet.internal.r.debug.core.model.RVariableProxy;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.r.core.data.CombinedRElement;
import org.eclipse.statet.r.debug.core.RIndexedVariableItem;
import org.eclipse.statet.r.debug.core.RValue;
import org.eclipse.statet.r.debug.core.RVariable;
import org.eclipse.statet.rj.data.RDataUtils;
import org.eclipse.statet.rj.data.RStore;

@NonNullByDefault
public class RArrayIndexVariable
extends BasicRVariable
implements RIndexedVariableItem,
RValue {
    private final RArrayValue mainValue;
    private final int[] dimIndex;

    public RArrayIndexVariable(RArrayValue value, int[] index, RVariable parent) {
        super((RDebugTargetImpl)value.getDebugTarget(), parent);
        this.mainValue = value;
        this.dimIndex = index;
    }

    @Override
    public long[] getIndex() {
        long[] index = new long[this.dimIndex.length];
        int i = 0;
        while (i < index.length) {
            index[i] = this.dimIndex[i];
            ++i;
        }
        return index;
    }

    @Override
    public String getName() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        int i = 0;
        while (i < this.mainValue.dimCount - 1) {
            sb.append(this.dimIndex[i] + 1);
            sb.append(", ");
            ++i;
        }
        sb.append(this.dimIndex[this.mainValue.dimCount - 1] + 1);
        sb.append(']');
        String name = this.mainValue.getDimItemName(0, this.dimIndex[0]);
        if (name != null) {
            sb.append(' ');
            sb.append(name);
        }
        return sb.toString();
    }

    public boolean hasValueChanged() throws DebugException {
        return this.mainValue.hasValueChanged(this.dimIndex);
    }

    @Override
    public RValue getValue() throws DebugException {
        return this;
    }

    @Override
    public RVariable getAssignedVariable() {
        return this;
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    @Override
    public String getReferenceTypeName() throws DebugException {
        CombinedRElement element = this.mainValue.element;
        return RDataUtils.getStoreAbbr((RStore)element.getData());
    }

    @Override
    public String getValueString() throws DebugException {
        String data = this.mainValue.getDataExpr(this.dimIndex);
        if (data == null) {
            throw this.newRequestLoadDataFailed();
        }
        return data;
    }

    @Override
    public boolean supportsValueModification() {
        return true;
    }

    @Override
    public boolean verifyValue(String expression) throws DebugException {
        return this.mainValue.validateDataExpr(expression);
    }

    @Override
    public void setValue(String expression) throws DebugException {
        this.mainValue.setDataExpr(this.dimIndex, expression);
    }

    @Override
    public String getDetailString() {
        String data = this.mainValue.getDataExpr(this.dimIndex);
        if (data == null) {
            return "<error>";
        }
        return data;
    }

    public boolean hasVariables() throws DebugException {
        return false;
    }

    public @NonNull RVariable[] getVariables() throws DebugException {
        return RElementVariableValue.NO_VARIABLES;
    }

    public int hashCode() {
        return this.mainValue.hashCode() + Arrays.hashCode(this.dimIndex);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(@Nullable Object obj) {
        block2: {
            block3: {
                void other;
                if (this == obj || this == (obj = RVariableProxy.unproxy(obj))) break block2;
                Object object = obj;
                if (!(object instanceof RArrayIndexVariable)) break block3;
                RArrayIndexVariable rArrayIndexVariable = (RArrayIndexVariable)object;
                RArrayIndexVariable cfr_ignored_0 = (RArrayIndexVariable)object;
                if (this.mainValue.equals(other.mainValue) && Arrays.equals(this.dimIndex, other.dimIndex)) break block2;
            }
            return false;
        }
        return true;
    }
}

