/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.pkgmanager;

import java.util.Collection;
import java.util.regex.Pattern;
import org.eclipse.statet.r.core.pkgmanager.RRepo;
import org.eclipse.statet.r.core.pkgmanager.RRepoSettings;
import org.eclipse.statet.rj.renv.core.RPkgType;

public class RVarRepo
extends RRepo {
    static final String CRAN_MIRROR_VAR = "%cran";
    static final String BIOC_MIRROR_VAR = "%bm";
    static final String BIOC_VERSION_VAR = "%v";
    private static final Pattern CRAN_MIRROR_VAR_PATTERN = Pattern.compile(String.valueOf(Pattern.quote("%cran")) + "/?");
    private static final Pattern BIOC_MIRROR_VAR_PATTERN = Pattern.compile(String.valueOf(Pattern.quote("%bm")) + "/?");
    private static final Pattern BIOC_VERSION_VAR_PATTERN = Pattern.compile(Pattern.quote("%v"));
    private String rawURL = this.getURL();

    static boolean hasVars(String url) {
        return url.indexOf(BIOC_MIRROR_VAR) >= 0 || url.indexOf(BIOC_VERSION_VAR) >= 0 || url.indexOf(CRAN_MIRROR_VAR) >= 0;
    }

    static boolean requireCRANMirror(Collection<RRepo> repos) {
        for (RRepo repo : repos) {
            if (!(repo instanceof RVarRepo) || ((RVarRepo)repo).getRawURL().indexOf(CRAN_MIRROR_VAR) < 0) continue;
            return true;
        }
        return false;
    }

    static boolean requireBioCMirror(Collection<RRepo> repos) {
        for (RRepo repo : repos) {
            if (!(repo instanceof RVarRepo) || ((RVarRepo)repo).getRawURL().indexOf(BIOC_MIRROR_VAR) < 0) continue;
            return true;
        }
        return false;
    }

    static RRepo create(String id, String name, String url, RPkgType pkgType) {
        return RVarRepo.hasVars(url) ? new RVarRepo(id, name, url, pkgType) : new RRepo(id, name, url, pkgType);
    }

    public RVarRepo(String id, String name, String url, RPkgType pkgType) {
        super(id, name, url, pkgType);
    }

    public void updateURL(RRepoSettings settings) {
        String url = this.rawURL;
        if (settings.getCRANMirror() != null) {
            url = CRAN_MIRROR_VAR_PATTERN.matcher(url).replaceAll(settings.getCRANMirror().getURL());
        }
        if (settings.getBioCMirror() != null) {
            url = BIOC_MIRROR_VAR_PATTERN.matcher(url).replaceAll(settings.getBioCMirror().getURL());
        }
        if (settings.getBioCVersion() != null) {
            url = BIOC_VERSION_VAR_PATTERN.matcher(url).replaceAll(settings.getBioCVersion());
        }
        if (!url.equals(this.getURL())) {
            super.setURL(url);
        }
    }

    @Override
    public void setURL(String url) {
        super.setURL(url);
        this.rawURL = url;
    }

    public String getRawURL() {
        return this.rawURL;
    }
}

